/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.uikit.widgets.ThemeableRecyclerView;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class PagerRecyclerView
extends ThemeableRecyclerView {
    private LinearLayoutManager layoutManager;
    private final OnScrollListener scrollListener = new OnScrollListener();

    public PagerRecyclerView(@NonNull Context context) {
        super(context);
    }

    public PagerRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PagerRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setLayoutManager(RecyclerView.LayoutManager layoutManager) {
        if (!(layoutManager instanceof LinearLayoutManager)) {
            throw new IllegalArgumentException("LinearLayoutManager supports only.");
        }
        this.layoutManager = (LinearLayoutManager)layoutManager;
        super.setLayoutManager(layoutManager);
    }

    public boolean performClick() {
        return super.performClick();
    }

    @Nullable
    public LinearLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void setPager(@NonNull Pageable<?> pager) {
        this.scrollListener.setPager(pager);
        this.scrollListener.setLayoutManager(this.layoutManager);
        this.addOnScrollListener(this.scrollListener);
    }

    public void setThreshold(int threshold) {
        this.scrollListener.setThreshold(threshold);
    }

    public int findFirstVisibleItemPosition() {
        return this.layoutManager.findFirstVisibleItemPosition();
    }

    public int findLastVisibleItemPosition() {
        return this.layoutManager.findLastVisibleItemPosition();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeOnScrollListener(this.scrollListener);
        this.scrollListener.dispose();
    }

    public void setOnScrollEndDetectListener(@Nullable OnScrollEndDetectListener scrollEndDetectListener) {
        this.scrollListener.setOnScrollEndDetectListener(scrollEndDetectListener);
    }

    public static enum ScrollDirection {
        Top(-1),
        Bottom(1);

        private final int value;

        private ScrollDirection(int value) {
            this.value = value;
        }

        public int getDirection() {
            return this.value;
        }
    }

    public static interface OnScrollEndDetectListener {
        public void onScrollEnd(ScrollDirection var1);
    }

    public static interface Pageable<T> {
        public T loadPrevious() throws Exception;

        public T loadNext() throws Exception;
    }

    private static final class OnScrollListener
    extends RecyclerView.OnScrollListener {
        private int threshold = 1;
        private Pageable<?> pager;
        private LinearLayoutManager layoutManager;
        private OnScrollEndDetectListener scrollEndDetectListener;
        private final ExecutorService workerThread = Executors.newFixedThreadPool(2);
        private final AtomicBoolean topLoading = new AtomicBoolean(false);
        private final AtomicBoolean bottomLoading = new AtomicBoolean(false);

        public void setPager(@NonNull Pageable<?> pager) {
            this.pager = pager;
        }

        public void setLayoutManager(@Nullable LinearLayoutManager layoutManager) {
            this.layoutManager = layoutManager;
        }

        public void setOnScrollEndDetectListener(@Nullable OnScrollEndDetectListener scrollEndDetectListener) {
            this.scrollEndDetectListener = scrollEndDetectListener;
        }

        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
            int lastVisibleItemPosition = this.layoutManager.findLastVisibleItemPosition();
            int firstVisibleItemPosition = this.layoutManager.findFirstVisibleItemPosition();
            int itemCount = recyclerView.getAdapter().getItemCount();
            if (!recyclerView.canScrollVertically(ScrollDirection.Bottom.getDirection()) && this.scrollEndDetectListener != null) {
                this.scrollEndDetectListener.onScrollEnd(ScrollDirection.Bottom);
            }
            if (!recyclerView.canScrollVertically(ScrollDirection.Top.getDirection()) && this.scrollEndDetectListener != null) {
                this.scrollEndDetectListener.onScrollEnd(ScrollDirection.Top);
            }
            if (this.pager != null && !this.topLoading.get() && itemCount - lastVisibleItemPosition <= this.threshold) {
                this.topLoading.set(true);
                this.workerThread.submit(() -> {
                    try {
                        if (this.layoutManager.getReverseLayout()) {
                            this.pager.loadPrevious();
                        } else {
                            this.pager.loadNext();
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.topLoading.set(false);
                    }
                });
            }
            if (this.pager != null && !this.bottomLoading.get() && firstVisibleItemPosition <= this.threshold) {
                this.bottomLoading.set(true);
                this.workerThread.submit(() -> {
                    try {
                        if (this.layoutManager.getReverseLayout()) {
                            this.pager.loadNext();
                        } else {
                            this.pager.loadPrevious();
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.bottomLoading.set(false);
                    }
                });
            }
        }

        public void setThreshold(int threshold) {
            if (threshold <= 0) {
                throw new IllegalArgumentException("illegal threshold: " + threshold);
            }
            this.threshold = threshold;
        }

        public void dispose() {
            this.workerThread.shutdown();
        }
    }
}

