/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.OpenChannel;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewOpenChannelSettingsBinding;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.utils.ChannelUtils;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.utils.TextUtils;

public class OpenChannelSettingsView
extends FrameLayout {
    private SbViewOpenChannelSettingsBinding binding;
    private OnItemClickListener<OpenChannelSettingMenu> listener;

    public OpenChannelSettingsView(@NonNull Context context) {
        this(context, null);
    }

    public OpenChannelSettingsView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_open_channel_settings_style);
    }

    public OpenChannelSettingsView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ChannelSettings, defStyle, 0);
        try {
            this.binding = (SbViewOpenChannelSettingsBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_open_channel_settings, (ViewGroup)this, (boolean)true);
            int background = a.getResourceId(R.styleable.ChannelSettings_sb_channel_settings_background, R.color.background_50);
            int itemBackground = a.getResourceId(R.styleable.ChannelSettings_sb_channel_settings_item_background, R.drawable.selector_rectangle_light);
            int nameAppearance = a.getResourceId(R.styleable.ChannelSettings_sb_channel_settings_name_appearance, R.style.SendbirdSubtitle1OnLight01);
            int itemAppearance = a.getResourceId(R.styleable.ChannelSettings_sb_channel_settings_item_appearance, R.style.SendbirdSubtitle2OnLight01);
            int descAppearance = a.getResourceId(R.styleable.ChannelSettings_sb_channel_settings_description_appearance, R.style.SendbirdBody2OnLight02);
            int infoTitleAppearance = a.getResourceId(R.styleable.ChannelSettings_sb_channel_settings_description_appearance, R.style.SendbirdBody2OnLight02);
            int infoContentAppearance = a.getResourceId(R.styleable.ChannelSettings_sb_channel_settings_description_appearance, R.style.SendbirdBody2OnLight02);
            boolean useDarkTheme = SendBirdUIKit.isDarkMode();
            int nextTint = useDarkTheme ? R.color.ondark_01 : R.color.onlight_01;
            int divider = useDarkTheme ? R.drawable.sb_line_divider_dark : R.drawable.sb_line_divider_light;
            int iconTint = SendBirdUIKit.getDefaultThemeMode().getPrimaryTintResId();
            int deleteTint = useDarkTheme ? R.color.error_200 : R.color.error_300;
            this.setBackgroundResource(background);
            this.binding.ivParticipantsIcon.setImageDrawable(DrawableUtils.setTintList(this.binding.ivParticipantsIcon.getDrawable(), AppCompatResources.getColorStateList((Context)context, (int)iconTint)));
            this.binding.ivNext.setImageDrawable(DrawableUtils.setTintList(this.binding.ivNext.getDrawable(), AppCompatResources.getColorStateList((Context)context, (int)nextTint)));
            this.binding.ivChannelDeleteIcon.setImageDrawable(DrawableUtils.setTintList(this.binding.ivChannelDeleteIcon.getDrawable(), AppCompatResources.getColorStateList((Context)context, (int)deleteTint)));
            this.binding.participantsItem.setBackgroundResource(itemBackground);
            this.binding.channelDeleteItem.setBackgroundResource(itemBackground);
            this.binding.tvParticipantsTitle.setTextAppearance(context, itemAppearance);
            this.binding.tvChannelDeleteTitle.setTextAppearance(context, itemAppearance);
            this.binding.tvChannelName.setTextAppearance(context, nameAppearance);
            this.binding.tvParticipantsCount.setTextAppearance(context, descAppearance);
            this.binding.tvInformationTitle.setTextAppearance(context, infoTitleAppearance);
            this.binding.tvInformationContent.setTextAppearance(context, infoContentAppearance);
            this.binding.divider0.setBackgroundResource(divider);
            this.binding.divider1.setBackgroundResource(divider);
            this.binding.divider2.setBackgroundResource(divider);
            this.binding.divider3.setBackgroundResource(divider);
            this.binding.participantsItem.setOnClickListener(v -> {
                if (this.listener != null) {
                    this.listener.onItemClick(v, 0, OpenChannelSettingMenu.PARTICIPANTS);
                }
            });
            this.binding.channelDeleteItem.setOnClickListener(v -> {
                if (this.listener != null) {
                    this.listener.onItemClick(v, 0, OpenChannelSettingMenu.DELETE_CHANNEL);
                }
            });
        }
        finally {
            a.recycle();
        }
    }

    public void setOnItemClickListener(OnItemClickListener<OpenChannelSettingMenu> listener) {
        this.listener = listener;
    }

    public OpenChannelSettingsView getLayout() {
        return this;
    }

    public SbViewOpenChannelSettingsBinding getBinding() {
        return this.binding;
    }

    public void drawSettingsView(@NonNull OpenChannel channel) {
        String channelName = channel.getName();
        this.binding.tvChannelName.setText((CharSequence)(TextUtils.isEmpty(channelName) ? "" : channelName));
        this.binding.tvInformationContent.setText((CharSequence)channel.getUrl());
        ChannelUtils.loadChannelCover(this.binding.ccvChannelImage, (BaseChannel)channel);
        this.binding.tvParticipantsCount.setText(ChannelUtils.makeMemberCountText(channel.getParticipantCount()));
    }

    public static enum OpenChannelSettingMenu {
        PARTICIPANTS,
        DELETE_CHANNEL;

    }
}

