/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.consts.MessageGroupType;
import com.sendbird.uikit.databinding.SbViewOpenChannelFileMessageComponentBinding;
import com.sendbird.uikit.utils.DateUtils;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.utils.ViewUtils;
import com.sendbird.uikit.widgets.OpenChannelMessageView;

public class OpenChannelFileMessageView
extends OpenChannelMessageView {
    private SbViewOpenChannelFileMessageComponentBinding binding;
    private int nicknameAppearance;
    private int operatorAppearance;
    private int marginLeftEmpty;
    private int marginLeftNor;

    @Override
    public SbViewOpenChannelFileMessageComponentBinding getBinding() {
        return this.binding;
    }

    @Override
    public View getLayout() {
        return this.binding.getRoot();
    }

    public OpenChannelFileMessageView(Context context) {
        this(context, null);
    }

    public OpenChannelFileMessageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_open_channel_message_file_style);
    }

    public OpenChannelFileMessageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageView, defStyle, 0);
        try {
            this.binding = (SbViewOpenChannelFileMessageComponentBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_open_channel_file_message_component, (ViewGroup)this, (boolean)true);
            int timeAppearance = a.getResourceId(R.styleable.MessageView_sb_message_time_text_appearance, R.style.SendbirdCaption4OnLight03);
            int contentBackground = a.getResourceId(R.styleable.MessageView_sb_message_background, R.drawable.selector_open_channel_message_bg_light);
            int messageAppearance = a.getResourceId(R.styleable.MessageView_sb_message_text_appearance, R.style.SendbirdBody3OnLight01);
            this.nicknameAppearance = a.getResourceId(R.styleable.MessageView_sb_message_sender_name_text_appearance, R.style.SendbirdCaption1OnLight02);
            this.operatorAppearance = a.getResourceId(R.styleable.MessageView_sb_message_operator_name_text_appearance, R.style.SendbirdCaption1Secondary300);
            this.binding.tvSentAt.setTextAppearance(context, timeAppearance);
            this.binding.tvNickname.setTextAppearance(context, this.nicknameAppearance);
            this.binding.contentPanel.setBackgroundResource(contentBackground);
            this.binding.tvFileName.setTextAppearance(context, messageAppearance);
            this.binding.tvFileName.setPaintFlags(this.binding.tvFileName.getPaintFlags() | 8);
            this.marginLeftEmpty = this.getResources().getDimensionPixelSize(R.dimen.sb_size_40);
            this.marginLeftNor = this.getResources().getDimensionPixelSize(R.dimen.sb_size_12);
        }
        finally {
            a.recycle();
        }
    }

    @Override
    public void drawMessage(OpenChannel channel, BaseMessage message, MessageGroupType messageGroupType) {
        ConstraintLayout.LayoutParams params;
        Drawable background;
        FileMessage fileMessage = (FileMessage)message;
        this.binding.tvFileName.setText((CharSequence)fileMessage.getName());
        this.binding.ivStatus.drawStatus(message, (BaseChannel)channel);
        if (channel.isOperator((User)message.getSender())) {
            this.binding.tvNickname.setTextAppearance(this.getContext(), this.operatorAppearance);
        } else {
            this.binding.tvNickname.setTextAppearance(this.getContext(), this.nicknameAppearance);
        }
        int backgroundTint = SendBirdUIKit.isDarkMode() ? R.color.background_600 : R.color.background_50;
        int iconTint = SendBirdUIKit.getDefaultThemeMode().getPrimaryTintResId();
        int inset = (int)this.getContext().getResources().getDimension(R.dimen.sb_size_12);
        if (fileMessage.getType().toLowerCase().startsWith("audio")) {
            background = DrawableUtils.setTintList(this.getContext(), R.drawable.sb_rounded_rectangle_corner_24, backgroundTint);
            Drawable icon = DrawableUtils.setTintList(this.getContext(), R.drawable.icon_file_audio, iconTint);
            this.binding.ivIcon.setImageDrawable(DrawableUtils.createLayerIcon(background, icon, inset));
        } else {
            background = DrawableUtils.setTintList(this.getContext(), R.drawable.sb_rounded_rectangle_corner_24, backgroundTint);
            Drawable icon = DrawableUtils.setTintList(this.getContext(), R.drawable.icon_file_document, iconTint);
            this.binding.ivIcon.setImageDrawable(DrawableUtils.createLayerIcon(background, icon, inset));
        }
        if (messageGroupType == MessageGroupType.GROUPING_TYPE_SINGLE || messageGroupType == MessageGroupType.GROUPING_TYPE_HEAD) {
            this.binding.ivProfileView.setVisibility(0);
            this.binding.tvNickname.setVisibility(0);
            this.binding.tvSentAt.setVisibility(0);
            this.binding.tvSentAt.setText((CharSequence)DateUtils.formatTime(this.getContext(), message.getCreatedAt()));
            ViewUtils.drawNickname((TextView)this.binding.tvNickname, message);
            ViewUtils.drawProfile((ImageView)this.binding.ivProfileView, message);
            params = (ConstraintLayout.LayoutParams)this.binding.contentPanel.getLayoutParams();
            params.leftMargin = this.marginLeftNor;
            this.binding.contentPanel.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            this.binding.ivProfileView.setVisibility(8);
            this.binding.tvNickname.setVisibility(8);
            this.binding.tvSentAt.setVisibility(8);
            params = (ConstraintLayout.LayoutParams)this.binding.contentPanel.getLayoutParams();
            params.leftMargin = this.marginLeftEmpty;
            this.binding.contentPanel.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }
}

