/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewMyMessageStatusBinding;
import com.sendbird.uikit.utils.DrawableUtils;

public class MyMessageStatusView
extends FrameLayout {
    private SbViewMyMessageStatusBinding binding;

    public MyMessageStatusView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public MyMessageStatusView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MyMessageStatusView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.binding = (SbViewMyMessageStatusBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.sb_view_my_message_status, (ViewGroup)this, (boolean)true);
    }

    public void drawError() {
        this.setProgress(false);
        int alertColor = SendBirdUIKit.isDarkMode() ? R.color.error_200 : R.color.error_300;
        this.binding.ivStatus.setImageDrawable(DrawableUtils.setTintList(this.getContext(), R.drawable.icon_error, alertColor));
    }

    public void drawRead() {
        this.setProgress(false);
        int readColor = SendBirdUIKit.getDefaultThemeMode().getSecondaryTintResId();
        this.binding.ivStatus.setImageDrawable(DrawableUtils.setTintList(this.getContext(), R.drawable.icon_done_all, readColor));
    }

    public void drawSent() {
        this.setProgress(false);
        this.binding.ivStatus.setImageDrawable(DrawableUtils.setTintList(this.getContext(), R.drawable.icon_done, SendBirdUIKit.getDefaultThemeMode().getMonoTintResId()));
    }

    public void drawDelivered() {
        this.setProgress(false);
        this.binding.ivStatus.setImageDrawable(DrawableUtils.setTintList(this.getContext(), R.drawable.icon_done_all, SendBirdUIKit.getDefaultThemeMode().getMonoTintResId()));
    }

    public void drawProgress() {
        this.setProgress(true);
    }

    private void setProgress(boolean isProgress) {
        this.setVisibility(0);
        if (isProgress) {
            this.binding.ivStatus.setVisibility(8);
            this.binding.mpvProgressStatus.setVisibility(0);
        } else {
            this.binding.mpvProgressStatus.setVisibility(8);
            this.binding.ivStatus.setVisibility(0);
        }
    }

    public void drawStatus(BaseMessage message, BaseChannel channel) {
        GroupChannel groupChannel;
        if (message == null) {
            return;
        }
        if (channel.isGroupChannel() && ((groupChannel = (GroupChannel)channel).isSuper() || groupChannel.isBroadcast())) {
            return;
        }
        BaseMessage.SendingStatus status = message.getSendingStatus();
        switch (status) {
            case CANCELED: 
            case FAILED: {
                this.setVisibility(0);
                this.drawError();
                break;
            }
            case SUCCEEDED: {
                if (channel.isGroupChannel()) {
                    this.setVisibility(0);
                    GroupChannel groupChannel2 = (GroupChannel)channel;
                    int unreadMemberCount = groupChannel2.getUnreadMemberCount(message);
                    int unDeliveredMemberCount = groupChannel2.getUndeliveredMemberCount(message);
                    if (unreadMemberCount == 0) {
                        this.drawRead();
                        break;
                    }
                    if (unDeliveredMemberCount == 0) {
                        this.drawDelivered();
                        break;
                    }
                    this.drawSent();
                    break;
                }
                this.setVisibility(8);
                break;
            }
            default: {
                this.drawProgress();
            }
        }
    }
}

