/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewMessageRecyclerViewBinding;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.utils.SoftInputUtils;
import com.sendbird.uikit.widgets.PagerRecyclerView;

public class MessageRecyclerView
extends FrameLayout {
    private SbViewMessageRecyclerViewBinding binding;

    public MessageRecyclerView(Context context) {
        this(context, null);
    }

    public MessageRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_channel_message_list_style);
    }

    public MessageRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, @Nullable AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageListView, defStyle, 0);
        try {
            this.binding = (SbViewMessageRecyclerViewBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_message_recycler_view, (ViewGroup)this, (boolean)true);
            boolean useDividerLine = a.getBoolean(R.styleable.MessageListView_sb_pager_recycler_view_use_divide_line, false);
            int dividerColor = a.getColor(R.styleable.MessageListView_sb_pager_recycler_view_divide_line_color, context.getResources().getColor(17170445));
            float dividerHeight = a.getDimension(R.styleable.MessageListView_sb_pager_recycler_view_divide_line_height, 0.0f);
            int recyclerViewBackground = a.getResourceId(R.styleable.MessageListView_sb_message_recyclerview_background, R.color.background_50);
            int tooltipBackground = a.getResourceId(R.styleable.MessageListView_sb_message_recyclerview_tooltip_background, R.drawable.selector_tooltip_background_light);
            int tooltipTextAppearance = a.getResourceId(R.styleable.MessageListView_sb_message_recyclerview_tooltip_textappearance, R.style.SendbirdCaption1Primary300);
            int typingIndicatorTextAppearance = a.getResourceId(R.styleable.MessageListView_sb_message_typing_indicator_textappearance, R.style.SendbirdCaption1OnLight02);
            int scrollBottomBackground = a.getResourceId(R.styleable.MessageListView_sb_message_scroll_bottom_background, R.drawable.selector_scroll_bottom_light);
            int scrollBottomIcon = a.getResourceId(R.styleable.MessageListView_sb_message_scroll_bottom_icon, R.drawable.icon_chevron_down);
            int scrollBottomTintColor = a.getResourceId(R.styleable.MessageListView_sb_message_scroll_bottom_icon_tint, R.color.primary_300);
            this.binding.rvMessageList.setBackgroundResource(recyclerViewBackground);
            this.binding.rvMessageList.setOnTouchListener((v, event) -> {
                SoftInputUtils.hideSoftKeyboard((View)this);
                v.performClick();
                return false;
            });
            this.binding.rvMessageList.setUseDivider(useDividerLine);
            this.binding.rvMessageList.setDividerColor(dividerColor);
            this.binding.rvMessageList.setDividerHeight(dividerHeight);
            this.binding.tvTooltipText.setBackgroundResource(tooltipBackground);
            this.binding.tvTooltipText.setTextAppearance(context, tooltipTextAppearance);
            this.binding.tvTypingIndicator.setTextAppearance(context, typingIndicatorTextAppearance);
            this.binding.ivScrollBottomIcon.setBackgroundResource(scrollBottomBackground);
            this.binding.ivScrollBottomIcon.setImageDrawable(DrawableUtils.setTintList(this.getContext(), scrollBottomIcon, scrollBottomTintColor));
        }
        finally {
            a.recycle();
        }
    }

    public void showTypingIndicator(@NonNull String text) {
        this.binding.tvTypingIndicator.setVisibility(0);
        this.binding.tvTypingIndicator.setText((CharSequence)text);
    }

    public void hideTypingIndicator() {
        this.binding.tvTypingIndicator.setVisibility(8);
    }

    public void showNewMessageTooltip(@NonNull String text) {
        this.binding.vgTooltipBox.setVisibility(0);
        this.binding.tvTooltipText.setText((CharSequence)text);
    }

    public void showScrollBottomButton() {
        this.binding.ivScrollBottomIcon.setVisibility(0);
    }

    public void hideScrollBottomButton() {
        this.binding.ivScrollBottomIcon.setVisibility(8);
    }

    public void hideNewMessageTooltip() {
        this.binding.vgTooltipBox.setVisibility(8);
    }

    public View getLayout() {
        return this.binding.getRoot();
    }

    public PagerRecyclerView getRecyclerView() {
        return this.binding.rvMessageList;
    }

    public View getTooltipView() {
        return this.binding.tvTooltipText;
    }

    public View getScrollBottomView() {
        return this.binding.ivScrollBottomIcon;
    }

    public View getTypingIndicator() {
        return this.binding.tvTypingIndicator;
    }
}

