/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.BindingAdapter;
import androidx.databinding.DataBindingUtil;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.sendbird.android.Reaction;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewEmojiReactionCountComponentBinding;
import com.sendbird.uikit.model.EmojiManager;
import com.sendbird.uikit.utils.DrawableUtils;

public class EmojiReactionCountView
extends FrameLayout {
    private SbViewEmojiReactionCountComponentBinding binding;
    private int emojiFailedDrawableRes;
    private int emojiFailedDrawableResTint;

    public EmojiReactionCountView(@NonNull Context context) {
        this(context, null);
    }

    public EmojiReactionCountView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_emoji_reaction_style);
    }

    public EmojiReactionCountView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.EmojiReactionCount, defStyleAttr, R.style.Widget_SendBird_Emoji);
        try {
            this.binding = (SbViewEmojiReactionCountComponentBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.sb_view_emoji_reaction_count_component, (ViewGroup)this, (boolean)true);
            int textStyleId = a.getResourceId(R.styleable.EmojiReactionCount_sb_emoji_reaction_count_text_appearance, R.style.SendbirdButtonOnLight03);
            this.emojiFailedDrawableRes = a.getResourceId(R.styleable.EmojiReactionCount_sb_emoji_failed_src, R.drawable.icon_question);
            this.emojiFailedDrawableResTint = a.getResourceId(R.styleable.EmojiReactionCount_sb_emoji_failed_src_tint, R.color.onlight_03);
            this.binding.tvCount.setTextAppearance(context, textStyleId);
        }
        finally {
            a.recycle();
        }
    }

    public void setCount(int count) {
        if (this.binding == null) {
            return;
        }
        if (count <= 0) {
            this.binding.tvCount.setVisibility(8);
        } else {
            this.binding.tvCount.setVisibility(0);
            String countText = count > 99 ? this.getContext().getString(R.string.sb_text_channel_reaction_count_max) : String.valueOf(count);
            this.binding.tvCount.setText((CharSequence)countText);
        }
    }

    public void setEmojiUrl(String emojiUrl) {
        if (this.binding != null) {
            int overrideSize = this.getResources().getDimensionPixelSize(R.dimen.sb_size_38);
            ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((View)this.binding.ivEmoji).load(emojiUrl).override(overrideSize, overrideSize)).centerCrop()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(DrawableUtils.setTintList(this.getContext(), this.emojiFailedDrawableRes, this.emojiFailedDrawableResTint))).placeholder(DrawableUtils.setTintList(this.getContext(), this.emojiFailedDrawableRes, this.emojiFailedDrawableResTint))).into((ImageView)this.binding.ivEmoji);
        }
    }

    public EmojiReactionCountView getLayout() {
        return this;
    }

    public SbViewEmojiReactionCountComponentBinding getBinding() {
        return this.binding;
    }

    public void drawReaction(Reaction reaction) {
        if (reaction == null || reaction.getUserIds() == null) {
            return;
        }
        this.setCount(reaction.getUserIds().size());
        this.setEmojiUrl(EmojiManager.getInstance().getEmojiUrl(reaction.getKey()));
    }

    @BindingAdapter(value={"reaction"})
    public static void drawReaction(EmojiReactionCountView view, Reaction reaction) {
        view.drawReaction(reaction);
    }
}

