/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.uikit.interfaces.CustomMemberListQueryHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.vm.BaseViewModel;
import com.sendbird.uikit.widgets.PagerRecyclerView;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class UserTypeListViewModel
extends BaseViewModel
implements LifecycleObserver,
PagerRecyclerView.Pageable<List<User>> {
    private final String CHANNEL_HANDLER_MEMBER_LIST = "CHANNEL_HANDLER_MEMBER_LIST" + System.currentTimeMillis();
    private final MutableLiveData<StatusFrameView.Status> statusFrame = new MutableLiveData();
    private final MutableLiveData<List<User>> memberList = new MutableLiveData();
    private final CustomMemberListQueryHandler<User> queryHandler;
    protected BaseChannel channel;

    private void onResult(List<User> memberList, Exception e) {
        if (e != null) {
            Logger.e(e);
            this.changeAlertStatus(StatusFrameView.Status.ERROR);
            this.notifyDataSetChanged((Collection)this.memberList.getValue());
        } else {
            ArrayList<User> newUsers = new ArrayList<User>(memberList);
            List origin = (List)this.memberList.getValue();
            if (origin != null) {
                newUsers.addAll(0, origin);
            }
            this.applyUserList(newUsers);
        }
    }

    UserTypeListViewModel(BaseChannel channel, CustomMemberListQueryHandler<User> customQuery) {
        this.channel = channel;
        this.queryHandler = customQuery;
    }

    private boolean isCurrentChannel(@NonNull String channelUrl) {
        return channelUrl.equals(this.channel.getUrl());
    }

    private void updateChannel(@NonNull BaseChannel channel) {
        if (this.isCurrentChannel(channel.getUrl())) {
            Logger.i(">> MemberListViewModel::updateChannel()", new Object[0]);
            this.channel = channel;
            this.loadInitial();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    private void onResume() {
        Logger.i(">> MemberListViewModel::onResume()", new Object[0]);
        SendBird.addChannelHandler((String)this.CHANNEL_HANDLER_MEMBER_LIST, (SendBird.ChannelHandler)new SendBird.ChannelHandler(){

            public void onMessageReceived(BaseChannel channel, BaseMessage message) {
            }

            public void onOperatorUpdated(BaseChannel channel) {
                UserTypeListViewModel.this.updateChannel(channel);
            }

            public void onUserMuted(BaseChannel channel, User user) {
                UserTypeListViewModel.this.updateChannel(channel);
            }

            public void onUserUnmuted(BaseChannel channel, User user) {
                UserTypeListViewModel.this.updateChannel(channel);
            }

            public void onUserBanned(BaseChannel channel, User user) {
                UserTypeListViewModel.this.updateChannel(channel);
            }

            public void onUserUnbanned(BaseChannel channel, User user) {
                UserTypeListViewModel.this.updateChannel(channel);
            }

            public void onChannelChanged(BaseChannel channel) {
                UserTypeListViewModel.this.updateChannel(channel);
            }
        });
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    private void onDestroy() {
        Logger.i(">> MemberListViewModel::onDestroy()", new Object[0]);
        SendBird.removeChannelHandler((String)this.CHANNEL_HANDLER_MEMBER_LIST);
    }

    public LiveData<StatusFrameView.Status> getStatusFrame() {
        return this.statusFrame;
    }

    protected void changeAlertStatus(StatusFrameView.Status status) {
        if (!this.hasData() || status == StatusFrameView.Status.NONE) {
            this.statusFrame.postValue((Object)status);
        }
    }

    protected boolean hasData() {
        List origin = (List)this.memberList.getValue();
        return origin != null && origin.size() > 0;
    }

    public LiveData<? extends Collection<?>> getMemberList() {
        return this.memberList;
    }

    private void applyUserList(List<User> newUserList) {
        this.changeAlertStatus(newUserList.size() == 0 ? StatusFrameView.Status.EMPTY : StatusFrameView.Status.NONE);
        this.notifyDataSetChanged(newUserList);
    }

    protected void notifyDataSetChanged(Collection<User> list) {
        this.memberList.postValue(list == null ? new ArrayList() : (List)list);
    }

    public void loadInitial() {
        Logger.d(">> MemberListViewModel::loadInitial()");
        List origin = (List)this.memberList.getValue();
        if (origin != null) {
            origin.clear();
        }
        this.queryHandler.loadInitial(this::onResult);
    }

    @Override
    public List<User> loadPrevious() {
        return Collections.emptyList();
    }

    @Override
    public List<User> loadNext() throws InterruptedException {
        if (this.queryHandler.hasMore()) {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference result = new AtomicReference();
            AtomicReference<Exception> error = new AtomicReference<Exception>();
            try {
                this.queryHandler.load((userList, e) -> {
                    try {
                        if (e != null) {
                            error.set((Exception)((Object)e));
                            return;
                        }
                        result.set(userList);
                    }
                    finally {
                        latch.countDown();
                    }
                });
                latch.await();
            }
            catch (Exception e2) {
                error.set(e2);
                throw e2;
            }
            finally {
                this.onResult((List)result.get(), (Exception)error.get());
            }
            return (List)result.get();
        }
        return Collections.emptyList();
    }
}

