/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import androidx.annotation.NonNull;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.sendbird.android.ApplicationUserListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.interfaces.CustomUserListQueryHandler;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.interfaces.UserListResultHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.tasks.JobResultTask;
import com.sendbird.uikit.tasks.TaskQueue;
import com.sendbird.uikit.utils.UserUtils;
import com.sendbird.uikit.vm.BaseViewModel;
import com.sendbird.uikit.widgets.PagerRecyclerView;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class SelectableUserInfoListViewModel
extends BaseViewModel
implements PagerRecyclerView.Pageable<List<? extends UserInfo>>,
UserListResultHandler {
    private static final int USER_LIST_LIMIT = 15;
    private final ApplicationUserListQuery userListQuery;
    private final MutableLiveData<List<UserInfo>> userList = new MutableLiveData();
    private final MutableLiveData<StatusFrameView.Status> statusFrame = new MutableLiveData();
    private final CustomUserListQueryHandler customUserListQueryHandler;

    @Override
    public void onResult(List<? extends UserInfo> userList, Exception e) {
        if (e != null) {
            Logger.e(e);
            this.changeAlertStatus(StatusFrameView.Status.ERROR);
            this.notifyDataSetChanged((List)this.userList.getValue());
        } else {
            ArrayList<UserInfo> newUsers = new ArrayList<UserInfo>(userList);
            List origin = (List)this.userList.getValue();
            if (origin != null) {
                newUsers.addAll(0, origin);
            }
            this.removeCurrentUser(newUsers);
            this.applyUserList(newUsers);
        }
    }

    SelectableUserInfoListViewModel(CustomUserListQueryHandler customUserListQueryHandler) {
        this.userListQuery = SendBird.createApplicationUserListQuery();
        this.userListQuery.setLimit(15);
        this.customUserListQueryHandler = customUserListQueryHandler == null ? SendBirdUIKit.getCustomUserListQueryHandler() : customUserListQueryHandler;
    }

    public LiveData<List<UserInfo>> getUserList() {
        this.loadInitial();
        return this.userList;
    }

    public LiveData<StatusFrameView.Status> getStatusFrame() {
        return this.statusFrame;
    }

    private void changeAlertStatus(StatusFrameView.Status status) {
        boolean hasData;
        List origin = (List)this.userList.getValue();
        boolean bl = hasData = origin != null && origin.size() > 0;
        if (!hasData || status == StatusFrameView.Status.NONE) {
            this.statusFrame.postValue((Object)status);
        }
    }

    private void removeCurrentUser(@NonNull List<UserInfo> newUserList) {
        Iterator<UserInfo> iterator = newUserList.iterator();
        while (iterator.hasNext()) {
            UserInfo userInfo = iterator.next();
            if (userInfo == null || userInfo.getUserId() == null || SendBird.getCurrentUser() == null || !userInfo.getUserId().equals(SendBird.getCurrentUser().getUserId())) continue;
            iterator.remove();
            break;
        }
    }

    private void applyUserList(List<UserInfo> newUserList) {
        this.changeAlertStatus(newUserList.size() == 0 ? StatusFrameView.Status.EMPTY : StatusFrameView.Status.NONE);
        this.notifyDataSetChanged(newUserList);
    }

    private void notifyDataSetChanged(List<UserInfo> newList) {
        this.userList.postValue((Object)(newList == null ? new ArrayList() : newList));
    }

    private void loadInitial() {
        if (this.customUserListQueryHandler != null) {
            this.customUserListQueryHandler.loadInitial(this);
        } else {
            TaskQueue.addTask(new JobResultTask<List<? extends UserInfo>>(){

                @Override
                public List<? extends UserInfo> call() throws Exception {
                    return SelectableUserInfoListViewModel.this.loadFromSendBird();
                }

                @Override
                public void onResultForUiThread(List<? extends UserInfo> result, SendBirdException e) {
                    SelectableUserInfoListViewModel.this.onResult(result, (Exception)((Object)e));
                }
            });
        }
    }

    private boolean hasMore() {
        if (this.customUserListQueryHandler != null) {
            return this.customUserListQueryHandler.hasMore();
        }
        return this.userListQuery.hasNext();
    }

    @Override
    public List<? extends UserInfo> loadPrevious() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends UserInfo> loadNext() {
        if (this.hasMore()) {
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<List<? extends UserInfo>> result = new AtomicReference<List<? extends UserInfo>>();
            AtomicReference<Exception> error = new AtomicReference<Exception>();
            try {
                if (this.customUserListQueryHandler != null) {
                    this.customUserListQueryHandler.loadNext((userList, e) -> {
                        try {
                            if (e != null) {
                                error.set(e);
                                return;
                            }
                            result.set(userList);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                    latch.await();
                } else {
                    result.set(this.loadFromSendBird());
                }
            }
            catch (Exception e2) {
                error.set(e2);
            }
            finally {
                this.onResult((List)result.get(), (Exception)error.get());
            }
            return (List)result.get();
        }
        return Collections.emptyList();
    }

    private List<? extends UserInfo> loadFromSendBird() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        this.userListQuery.next((list, e) -> {
            try {
                if (e != null) {
                    error.set(e);
                    return;
                }
                Logger.dev("++ list : %s", list);
                ArrayList<UserInfo> newUsers = new ArrayList<UserInfo>();
                for (User user : list) {
                    newUsers.add(UserUtils.toUserInfo(user));
                }
                result.set(newUsers);
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
        if (error.get() != null) {
            throw (Exception)error.get();
        }
        return (List)result.get();
    }
}

