/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.TextAppearanceSpan;
import android.util.Pair;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.appcompat.content.res.AppCompatResources;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.signature.ObjectKey;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.OGMetaData;
import com.sendbird.android.Sender;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.FileInfo;
import com.sendbird.uikit.model.HighlightMessageInfo;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.utils.ImageUtils;
import com.sendbird.uikit.utils.IntentUtils;
import com.sendbird.uikit.utils.MessageUtils;
import com.sendbird.uikit.utils.ReactionUtils;
import com.sendbird.uikit.utils.SpannableStringBuilder;
import com.sendbird.uikit.vm.PendingMessageRepository;
import com.sendbird.uikit.widgets.EmojiReactionListView;
import com.sendbird.uikit.widgets.OgtagView;
import com.sendbird.uikit.widgets.RoundCornerView;
import java.util.List;

public class ViewUtils {
    private static final int MINIMUN_THUBNAIL_WIDTH = 100;
    private static final int MINIMUN_THUBNAIL_HEIGHT = 100;

    private static void drawUnknownMessage(TextView view, boolean isMine) {
        int unknownHintAppearance = isMine ? (SendBirdUIKit.isDarkMode() ? R.style.SendbirdBody3OnLight02 : R.style.SendbirdBody3OnDark02) : (SendBirdUIKit.isDarkMode() ? R.style.SendbirdBody3OnDark03 : R.style.SendbirdBody3OnLight02);
        int sizeOfFirstLine = 23;
        String unknownHintText = view.getContext().getResources().getString(R.string.sb_text_channel_unknown_type_text);
        SpannableString spannable = new SpannableString((CharSequence)unknownHintText);
        spannable.setSpan((Object)new TextAppearanceSpan(view.getContext(), unknownHintAppearance), 23, spannable.length(), 33);
        view.setText((CharSequence)spannable);
    }

    public static void drawTextMessage(@NonNull TextView textView, BaseMessage message, @StyleRes int editedTextAppearance) {
        ViewUtils.drawTextMessage(textView, message, editedTextAppearance, null, 0, 0);
    }

    public static void drawTextMessage(@NonNull TextView textView, BaseMessage message, @StyleRes int editedTextAppearance, HighlightMessageInfo highlightMessageInfo, @ColorRes int backgroundColor, @ColorRes int foregroundColor) {
        if (message == null) {
            return;
        }
        if (MessageUtils.isUnknownType(message)) {
            ViewUtils.drawUnknownMessage(textView, MessageUtils.isMine(message));
            return;
        }
        CharSequence text = message.getMessage();
        if (highlightMessageInfo != null && highlightMessageInfo.getMessageId() == message.getMessageId() && highlightMessageInfo.getUpdatedAt() == message.getUpdatedAt()) {
            SpannableStringBuilder builder = new SpannableStringBuilder(textView.getContext(), text);
            builder.addHighlightTextSpan(text.toString(), text.toString(), backgroundColor, foregroundColor);
            text = builder.build();
        }
        textView.setText(text);
        if (message.getUpdatedAt() <= 0L) {
            return;
        }
        String edited = textView.getResources().getString(R.string.sb_text_channel_message_badge_edited);
        SpannableString spannable = new SpannableString((CharSequence)edited);
        spannable.setSpan((Object)new TextAppearanceSpan(textView.getContext(), editedTextAppearance), 0, edited.length(), 33);
        textView.append((CharSequence)spannable);
    }

    public static void drawOgtag(@NonNull ViewGroup parent, OGMetaData ogMetaData) {
        if (ogMetaData == null) {
            return;
        }
        parent.removeAllViews();
        OgtagView ogtagView = OgtagView.inflate(parent.getContext(), parent);
        ogtagView.drawOgtag(ogMetaData);
        parent.setOnClickListener(v -> {
            if (ogMetaData.getUrl() == null) {
                return;
            }
            Intent intent = IntentUtils.getWebViewerIntent(ogMetaData.getUrl());
            try {
                ogtagView.getContext().startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                Logger.e(e);
            }
        });
    }

    public static void drawReactionEnabled(EmojiReactionListView view, BaseChannel channel) {
        boolean canSendReaction = ReactionUtils.canSendReaction(channel);
        view.setClickable(canSendReaction);
        if (view.useMoreButton() != canSendReaction) {
            view.setUseMoreButton(canSendReaction);
            view.refresh();
        }
    }

    public static void drawNickname(TextView tvNickname, BaseMessage message) {
        if (message == null) {
            return;
        }
        Sender sender = message.getSender();
        String nickname = sender == null || TextUtils.isEmpty((CharSequence)sender.getNickname()) ? tvNickname.getContext().getString(R.string.sb_text_channel_list_title_unknown) : sender.getNickname();
        tvNickname.setText((CharSequence)nickname);
    }

    public static void drawProfile(ImageView ivProfile, BaseMessage message) {
        if (message == null) {
            return;
        }
        Sender sender = message.getSender();
        String url = "";
        if (sender != null && !TextUtils.isEmpty((CharSequence)sender.getProfileUrl())) {
            url = sender.getProfileUrl();
        }
        ViewUtils.drawProfile(ivProfile, url);
    }

    public static void drawProfile(ImageView ivProfile, String url) {
        int iconTint = SendBirdUIKit.isDarkMode() ? R.color.onlight_01 : R.color.ondark_01;
        int backgroundTint = R.color.background_300;
        Drawable errorDrawable = DrawableUtils.createOvalIcon(ivProfile.getContext(), backgroundTint, R.drawable.icon_user, iconTint);
        ((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)ivProfile.getContext()).load(url).diskCacheStrategy(DiskCacheStrategy.ALL)).signature((Key)new ObjectKey((Object)url))).error(errorDrawable)).apply((BaseRequestOptions)RequestOptions.circleCropTransform()).into(ivProfile);
    }

    public static void drawThumbnail(final @NonNull RoundCornerView view, @NonNull FileMessage message) {
        String url = message.getUrl();
        Context context = view.getContext();
        RequestOptions options = (RequestOptions)new RequestOptions().diskCacheStrategy(DiskCacheStrategy.ALL);
        RequestBuilder builder = Glide.with((Context)context).asDrawable().apply((BaseRequestOptions)options);
        Pair<Integer, Integer> defaultResizingSize = SendBirdUIKit.getResizingSize();
        int width = (Integer)defaultResizingSize.first / 2;
        int height = (Integer)defaultResizingSize.second / 2;
        FileInfo fileInfo = PendingMessageRepository.getInstance().getFileInfo((BaseMessage)message);
        if (fileInfo != null) {
            width = fileInfo.getThumbnailWidth();
            height = fileInfo.getThumbnailHeight();
            builder = (RequestBuilder)builder.override(width, height);
            if (!TextUtils.isEmpty((CharSequence)fileInfo.getThumbnailPath())) {
                url = fileInfo.getThumbnailPath();
            }
        } else {
            List thumbnails = message.getThumbnails();
            FileMessage.Thumbnail thumbnail = null;
            if (thumbnails.size() > 0) {
                thumbnail = (FileMessage.Thumbnail)thumbnails.get(0);
            }
            if (thumbnail != null) {
                Logger.dev("++ thumbnail width : %s, thumbnail height : %s", thumbnail.getRealWidth(), thumbnail.getRealHeight());
                width = thumbnail.getRealWidth();
                height = thumbnail.getRealHeight();
                url = thumbnail.getUrl();
            }
            builder = (RequestBuilder)builder.override(Math.max(100, width), Math.max(100, height));
        }
        if (message.getType().toLowerCase().contains("image") && !message.getType().toLowerCase().contains("gif")) {
            view.getContent().setScaleType(ImageView.ScaleType.CENTER);
            int thumbnailIconTint = SendBirdUIKit.isDarkMode() ? R.color.ondark_02 : R.color.onlight_02;
            builder = (RequestBuilder)((RequestBuilder)builder.placeholder(DrawableUtils.setTintList(ImageUtils.resize(context.getResources(), AppCompatResources.getDrawable((Context)context, (int)R.drawable.icon_photo), R.dimen.sb_size_48, R.dimen.sb_size_48), AppCompatResources.getColorStateList((Context)context, (int)thumbnailIconTint)))).error(DrawableUtils.setTintList(ImageUtils.resize(context.getResources(), AppCompatResources.getDrawable((Context)context, (int)R.drawable.icon_thumbnail_none), R.dimen.sb_size_48, R.dimen.sb_size_48), AppCompatResources.getColorStateList((Context)context, (int)thumbnailIconTint)));
        }
        Logger.d("-- will load thumbnail url : %s", url);
        ((RequestBuilder)builder.load(url).centerCrop()).thumbnail(0.3f).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                view.getContent().setScaleType(ImageView.ScaleType.CENTER_CROP);
                return false;
            }
        }).into(view.getContent());
    }

    public static void drawThumbnailIcon(ImageView imageView, FileMessage fileMessage) {
        String type = fileMessage.getType();
        Context context = imageView.getContext();
        int backgroundTint = R.color.ondark_01;
        int iconTint = R.color.onlight_02;
        if (type.toLowerCase().contains("gif")) {
            imageView.setImageDrawable(DrawableUtils.createOvalIcon(context, backgroundTint, R.drawable.icon_gif, iconTint));
        } else if (type.toLowerCase().contains("video")) {
            imageView.setImageDrawable(DrawableUtils.createOvalIcon(context, backgroundTint, R.drawable.icon_play, iconTint));
        } else {
            imageView.setImageResource(17170445);
        }
    }

    public static void drawFileIcon(ImageView imageView, FileMessage fileMessage) {
        Context context = imageView.getContext();
        int backgroundTint = SendBirdUIKit.isDarkMode() ? R.color.background_600 : R.color.background_50;
        int iconTint = SendBirdUIKit.getDefaultThemeMode().getPrimaryTintResId();
        int inset = (int)context.getResources().getDimension(R.dimen.sb_size_4);
        Drawable background = DrawableUtils.setTintList(context, R.drawable.sb_rounded_rectangle_light_corner_10, backgroundTint);
        if (fileMessage.getType().toLowerCase().startsWith("audio")) {
            Drawable icon = DrawableUtils.setTintList(imageView.getContext(), R.drawable.icon_file_audio, iconTint);
            imageView.setImageDrawable(DrawableUtils.createLayerIcon(background, icon, inset));
        } else {
            Drawable icon = DrawableUtils.setTintList(imageView.getContext(), R.drawable.icon_file_document, iconTint);
            imageView.setImageDrawable(DrawableUtils.createLayerIcon(background, icon, inset));
        }
    }
}

