/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.graphics.drawable.DrawableCompat;
import com.sendbird.uikit.R;

public class DrawableUtils {
    public static Drawable createDividerDrawable(int height, int color2) {
        GradientDrawable divider = new GradientDrawable();
        divider.setShape(0);
        divider.setSize(0, height);
        divider.setColor(color2);
        return divider;
    }

    public static Drawable createRoundedRectrangle(float radius, int color2) {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setShape(0);
        drawable2.setCornerRadius(radius);
        drawable2.setColor(color2);
        return drawable2;
    }

    public static Drawable setTintList(Context context, int resId, int colorRes) {
        if (colorRes == 0) {
            return AppCompatResources.getDrawable((Context)context, (int)resId);
        }
        return DrawableUtils.setTintList(AppCompatResources.getDrawable((Context)context, (int)resId), AppCompatResources.getColorStateList((Context)context, (int)colorRes));
    }

    public static Drawable setTintList(Context context, Drawable drawable2, int colorRes) {
        if (colorRes == 0) {
            return drawable2;
        }
        return DrawableUtils.setTintList(drawable2, AppCompatResources.getColorStateList((Context)context, (int)colorRes));
    }

    public static Drawable setTintList(Context context, int resId, ColorStateList colorStateList) {
        return DrawableUtils.setTintList(AppCompatResources.getDrawable((Context)context, (int)resId), colorStateList);
    }

    public static Drawable setTintList(Drawable drawable2, ColorStateList colorStateList) {
        if (drawable2 == null || colorStateList == null) {
            return drawable2;
        }
        drawable2 = DrawableCompat.wrap((Drawable)drawable2);
        DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)colorStateList);
        return drawable2.mutate();
    }

    public static Drawable createOvalIcon(@NonNull Context context, @ColorRes int backgroundColor, @DrawableRes int iconRes, @ColorRes int iconTint) {
        return DrawableUtils.createOvalIcon(context, backgroundColor, 255, iconRes, iconTint);
    }

    public static Drawable createOvalIcon(@NonNull Context context, @ColorRes int backgroundColor, int backgroundAlpha, @DrawableRes int iconRes, @ColorRes int iconTint) {
        ShapeDrawable ovalBackground = new ShapeDrawable((Shape)new OvalShape());
        ovalBackground.getPaint().setColor(context.getResources().getColor(backgroundColor));
        ovalBackground.getPaint().setAlpha(backgroundAlpha);
        Drawable icon = DrawableUtils.setTintList(context, iconRes, iconTint);
        int inset = (int)context.getResources().getDimension(R.dimen.sb_size_24);
        return DrawableUtils.createLayerIcon((Drawable)ovalBackground, icon, inset);
    }

    public static Drawable createLayerIcon(Drawable background, Drawable icon, int inset) {
        Drawable[] layer = new Drawable[]{background, icon};
        LayerDrawable layerDrawable = new LayerDrawable(layer);
        layerDrawable.setLayerInset(1, inset, inset, inset, inset);
        return layerDrawable;
    }
}

