/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.res.ColorStateList;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.fragment.app.Fragment;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelMemberListQuery;
import com.sendbird.android.Member;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.adapter.UserListAdapter;
import com.sendbird.uikit.fragments.SelectUserFragment;
import com.sendbird.uikit.interfaces.CustomUserListQueryHandler;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.interfaces.UserListResultHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.utils.UserUtils;
import java.util.ArrayList;
import java.util.List;

public class PromoteOperatorsFragment
extends SelectUserFragment {
    @Override
    protected void onConfigure() {
        MemberListQuery query = new MemberListQuery(this.channel);
        if (this.customUserListQueryHandler == null) {
            this.setCustomUserListQueryHandler(query);
        }
        if (this.adapter == null) {
            this.setUserListAdapter(new PromoteOperatorListAdapter(query));
        }
    }

    @Override
    protected List<String> getDisabledUserIds() {
        return super.getDisabledUserIds();
    }

    @Override
    protected void onUserSelectComplete(List<String> selectedUsers) {
        Logger.d(">> PromoteOperatorsFragment::onUserSelectComplete()");
        if (this.channel != null) {
            this.channel.addOperators(selectedUsers, e -> {
                if (e != null) {
                    this.toastError(R.string.sb_text_error_promote_operator);
                    Logger.e((Throwable)e);
                    return;
                }
                this.finish();
            });
        }
    }

    public static class Builder {
        protected Bundle bundle = new Bundle();
        protected PromoteOperatorsFragment customFragment;
        protected CustomUserListQueryHandler customUserListQueryHandler = null;
        protected UserListAdapter adapter;
        protected View.OnClickListener headerLeftButtonListener;

        public Builder() {
            this(SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
        }

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, @NonNull SendBirdUIKit.ThemeMode themeMode) {
            this(channelUrl, themeMode.getResId());
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends PromoteOperatorsFragment> Builder setCustomPromoteOperatorFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderRightButton(boolean useHeaderRightButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_RIGHT_BUTTON", useHeaderRightButton);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            return this.setHeaderLeftButtonIcon(resId, null);
        }

        public Builder setHeaderLeftButtonIcon(@DrawableRes int resId, @Nullable ColorStateList tint) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            this.bundle.putParcelable("KEY_HEADER_LEFT_BUTTON_ICON_TINT", (Parcelable)tint);
            return this;
        }

        public Builder setRightButtonText(String rightButtonText) {
            this.bundle.putString("KEY_HEADER_LEFT_BUTTON_TEXT", rightButtonText);
            return this;
        }

        public Builder setCustomUserListQueryHandler(CustomUserListQueryHandler handler) {
            this.customUserListQueryHandler = handler;
            return this;
        }

        public Builder setUserListAdapter(UserListAdapter adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public Fragment build() {
            PromoteOperatorsFragment fragment = this.customFragment != null ? this.customFragment : new PromoteOperatorsFragment();
            fragment.setArguments(this.bundle);
            fragment.setCustomUserListQueryHandler(this.customUserListQueryHandler);
            fragment.setUserListAdapter(this.adapter);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            return fragment;
        }
    }

    private static class PromoteOperatorListAdapter
    extends UserListAdapter {
        private final MemberListQuery query;

        PromoteOperatorListAdapter(MemberListQuery query) {
            this.query = query;
        }

        @Override
        protected boolean isDisabled(UserInfo userInfo) {
            Member member = this.query.getMember(userInfo);
            return member.getRole() == Member.Role.OPERATOR;
        }
    }

    private static class MemberListQuery
    implements CustomUserListQueryHandler {
        private GroupChannelMemberListQuery query;
        private GroupChannel channel;
        private final List<Member> members = new ArrayList<Member>();

        MemberListQuery(@NonNull GroupChannel channel) {
            this.channel = channel;
            this.query = channel.createMemberListQuery();
        }

        @Override
        public void loadInitial(UserListResultHandler handler) {
            this.loadNext(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loadNext(UserListResultHandler handler) {
            if (this.channel.isSuper() || this.channel.isBroadcast()) {
                this.query.next((list, ex) -> {
                    if (ex != null) {
                        handler.onResult(null, (Exception)ex);
                        return;
                    }
                    Logger.dev("++ list : %s", list);
                    ArrayList<UserInfo> newUsers = new ArrayList<UserInfo>();
                    for (User user : list) {
                        newUsers.add(UserUtils.toUserInfo(user));
                    }
                    this.members.addAll(list);
                    handler.onResult(newUsers, null);
                });
            } else {
                List members = this.channel.getMembers();
                ArrayList<UserInfo> newUsers = new ArrayList<UserInfo>();
                for (User member : members) {
                    newUsers.add(UserUtils.toUserInfo(member));
                }
                List<Member> list2 = this.members;
                synchronized (list2) {
                    this.members.addAll(members);
                }
                handler.onResult(newUsers, null);
            }
        }

        @Override
        public boolean hasMore() {
            return (this.channel.isSuper() || this.channel.isBroadcast()) && this.query.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Member getMember(UserInfo userInfo) {
            List<Member> list = this.members;
            synchronized (list) {
                for (Member member : this.members) {
                    if (!member.getUserId().equals(userInfo.getUserId())) continue;
                    return member;
                }
            }
            return null;
        }
    }
}

