/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.Intent;
import android.content.res.ColorStateList;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.OpenChannelParams;
import com.sendbird.android.SendBird;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.ParticipantsListActivity;
import com.sendbird.uikit.consts.DialogEditTextParams;
import com.sendbird.uikit.databinding.SbFragmentOpenChannelSettingsBinding;
import com.sendbird.uikit.fragments.BaseOpenChannelFragment;
import com.sendbird.uikit.fragments.PermissionFragment;
import com.sendbird.uikit.interfaces.CustomParamsHandler;
import com.sendbird.uikit.interfaces.LoadingDialogHandler;
import com.sendbird.uikit.interfaces.OnEditTextResultListener;
import com.sendbird.uikit.interfaces.OnMenuItemClickListener;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.DialogListItem;
import com.sendbird.uikit.utils.DialogUtils;
import com.sendbird.uikit.utils.FileUtils;
import com.sendbird.uikit.utils.IntentUtils;
import com.sendbird.uikit.utils.TextUtils;
import com.sendbird.uikit.widgets.OpenChannelSettingsView;
import java.io.File;

public class OpenChannelSettingsFragment
extends BaseOpenChannelFragment
implements PermissionFragment.IPermissionHandler,
LoadingDialogHandler {
    private static final int CAPTURE_IMAGE_PERMISSIONS_REQUEST_CODE = 2001;
    private static final int PICK_IMAGE_PERMISSIONS_REQUEST_CODE = 2002;
    private final String[] REQUIRED_PERMISSIONS = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"};
    private SbFragmentOpenChannelSettingsBinding binding;
    private Uri mediaUri;
    protected View.OnClickListener headerLeftButtonListener;
    protected OnMenuItemClickListener<OpenChannelSettingsView.OpenChannelSettingMenu, OpenChannel> menuItemClickListener;
    private LoadingDialogHandler loadingDialogHandler;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> OpenChannelSettingsFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentOpenChannelSettingsBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_open_channel_settings, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initHeaderOnCreated();
    }

    @Override
    protected void onReadyFailure() {
        Logger.i(">> OpenChannelSettingsFragment::onReadyFailure()", new Object[0]);
        this.toastError(R.string.sb_text_error_get_channel);
    }

    @Override
    protected void onConfigure() {
        Logger.i(">> OpenChannelSettingsFragment::doConfigure()", new Object[0]);
    }

    @Override
    protected void onDrawPage() {
        Logger.i(">> OpenChannelSettingsFragment::onDrawPage()", new Object[0]);
        String channelUrl = this.getStringExtra("KEY_CHANNEL_URL");
        if (TextUtils.isEmpty(channelUrl)) {
            this.toastError(R.string.sb_text_error_get_channel);
            this.finish();
            return;
        }
        this.initHeaderOnReady(this.channel);
        this.initChannelSetting();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        SendBird.setAutoBackgroundDetection((boolean)true);
    }

    @Override
    public String[] getPermissions(int requestCode) {
        return this.REQUIRED_PERMISSIONS;
    }

    @Override
    public void onPermissionGranted(int requestCode) {
        this.showMediaSelectDialog();
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_header_channel_settings);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        boolean useHeaderRightButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        ColorStateList headerLeftButtonIconTint = null;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", this.getString(R.string.sb_text_header_channel_settings));
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            useHeaderRightButton = args.getBoolean("KEY_USE_HEADER_RIGHT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
            headerLeftButtonIconTint = (ColorStateList)args.getParcelable("KEY_HEADER_LEFT_BUTTON_ICON_TINT");
        }
        this.binding.abSettingsHeader.setVisibility(useHeader ? 0 : 8);
        this.binding.abSettingsHeader.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abSettingsHeader.setUseLeftImageButton(useHeaderLeftButton);
        this.binding.abSettingsHeader.setUseRightButton(useHeaderRightButton);
        this.binding.abSettingsHeader.setLeftImageButtonResource(headerLeftButtonIconResId);
        if (args != null && args.containsKey("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID")) {
            this.binding.abSettingsHeader.setLeftImageButtonTint(headerLeftButtonIconTint);
        }
        this.binding.abSettingsHeader.setLeftImageButtonClickListener(v -> this.finish());
    }

    private void initHeaderOnReady(OpenChannel channel) {
        if (this.loadingDialogHandler == null) {
            this.loadingDialogHandler = this;
        }
        if (this.headerLeftButtonListener != null) {
            this.binding.abSettingsHeader.setLeftImageButtonClickListener(this.headerLeftButtonListener);
        }
        this.binding.abSettingsHeader.setRightTextButtonString(this.getString(R.string.sb_text_button_edit));
        this.binding.abSettingsHeader.setRightTextButtonClickListener(v -> {
            DialogListItem[] items = new DialogListItem[]{new DialogListItem(R.string.sb_text_channel_settings_change_channel_name), new DialogListItem(R.string.sb_text_channel_settings_change_channel_image)};
            if (this.getContext() == null || this.getFragmentManager() == null) {
                return;
            }
            DialogUtils.buildItemsBottom(items, (view, p, key) -> {
                if (key == R.string.sb_text_channel_settings_change_channel_name) {
                    if (this.getContext() == null || this.getFragmentManager() == null) {
                        return;
                    }
                    Logger.dev("change channel name");
                    OnEditTextResultListener listener = res -> {
                        OpenChannelParams params = new OpenChannelParams().setName(res);
                        this.updateOpenChannel(params);
                    };
                    DialogEditTextParams params = new DialogEditTextParams(this.getString(R.string.sb_text_channel_settings_change_channel_name_hint));
                    params.setEnableSingleLine(true);
                    DialogUtils.buildEditText(this.getString(R.string.sb_text_channel_settings_change_channel_name), (int)this.getResources().getDimension(R.dimen.sb_dialog_width_280), params, listener, this.getString(R.string.sb_text_button_save), null, this.getString(R.string.sb_text_button_cancel), null).showSingle(this.getFragmentManager());
                } else if (key == R.string.sb_text_channel_settings_change_channel_image) {
                    Logger.dev("change channel image");
                    this.checkPermission(2002, this);
                }
            }).showSingle(this.getFragmentManager());
        });
    }

    private void initChannelSetting() {
        this.binding.csvSettings.setOnItemClickListener((v, position, menu) -> {
            Logger.d("OnSettingsItem clicked menu : " + (Object)menu);
            if (this.menuItemClickListener != null && this.menuItemClickListener.onMenuItemClicked(v, (OpenChannelSettingsView.OpenChannelSettingMenu)((Object)menu), this.channel)) {
                return;
            }
            switch (menu) {
                case PARTICIPANTS: {
                    Logger.dev("show participants");
                    Logger.i("++ show participants", new Object[0]);
                    this.startActivity(ParticipantsListActivity.newIntent(this.getContext(), this.channel.getUrl()));
                    break;
                }
                case DELETE_CHANNEL: {
                    this.deleteChannel();
                }
            }
        });
        this.binding.csvSettings.drawSettingsView(this.channel);
    }

    private void showMediaSelectDialog() {
        if (this.getContext() == null || this.getFragmentManager() == null) {
            return;
        }
        DialogListItem[] items = new DialogListItem[]{new DialogListItem(R.string.sb_text_channel_settings_change_channel_image_camera), new DialogListItem(R.string.sb_text_channel_settings_change_channel_image_gallery)};
        DialogUtils.buildItems(this.getString(R.string.sb_text_channel_settings_change_channel_image), (int)this.getResources().getDimension(R.dimen.sb_dialog_width_280), items, (v, p, key) -> {
            try {
                SendBird.setAutoBackgroundDetection((boolean)false);
                if (key == R.string.sb_text_channel_settings_change_channel_image_camera) {
                    this.takeCamera();
                } else if (key == R.string.sb_text_channel_settings_change_channel_image_gallery) {
                    this.pickImage();
                }
            }
            catch (Exception e) {
                Logger.e(e);
                this.toastError(R.string.sb_text_error_open_camera);
            }
        }).showSingle(this.getFragmentManager());
    }

    private void takeCamera() {
        this.mediaUri = FileUtils.createPictureImageUri(this.getContext());
        Intent intent = IntentUtils.getCameraIntent(this.getContext(), this.mediaUri);
        if (IntentUtils.hasIntent(this.getContext(), intent)) {
            this.startActivityForResult(intent, 2001);
        }
    }

    private void pickImage() {
        Intent intent = IntentUtils.getGalleryIntent();
        this.startActivityForResult(intent, 2002);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        SendBird.setAutoBackgroundDetection((boolean)true);
        if (resultCode == -1) {
            switch (requestCode) {
                case 2001: {
                    break;
                }
                case 2002: {
                    this.mediaUri = data.getData();
                }
            }
            if (this.mediaUri != null && this.channel != null) {
                File file = FileUtils.uriToFile(this.getContext().getApplicationContext(), this.mediaUri);
                OpenChannelParams params = new OpenChannelParams().setCoverImage(file);
                this.toastSuccess(R.string.sb_text_toast_success_start_upload_file);
                this.updateOpenChannel(params);
            }
        }
    }

    protected void onBeforeUpdateOpenChannel(@NonNull OpenChannelParams params) {
    }

    protected void updateOpenChannel(@NonNull OpenChannelParams params) {
        if (this.channel != null) {
            CustomParamsHandler cutsomHandler = SendBirdUIKit.getCustomParamsHandler();
            if (cutsomHandler != null) {
                cutsomHandler.onBeforeUpdateOpenChannel(params);
            }
            this.onBeforeUpdateOpenChannel(params);
            this.channel.updateChannel(params, (updatedChannel, e) -> {
                if (e != null) {
                    Logger.e((Throwable)e);
                    this.toastError(R.string.sb_text_error_update_channel);
                    return;
                }
                Logger.i("++ updated channel name : %s", updatedChannel.getName());
                if (this.isActive()) {
                    this.binding.csvSettings.drawSettingsView(updatedChannel);
                }
            });
        }
    }

    protected void deleteChannel() {
        if (this.channel != null) {
            this.loadingDialogHandler.shouldShowLoadingDialog();
            this.channel.delete(e -> {
                this.loadingDialogHandler.shouldDismissLoadingDialog();
                if (e != null) {
                    Logger.e((Throwable)e);
                    this.toastError(R.string.sb_text_error_delete_channel);
                    return;
                }
                Logger.i("++ leave channel", new Object[0]);
                this.finish();
            });
        }
    }

    protected void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    protected void setOnMenuItemClickListener(OnMenuItemClickListener<OpenChannelSettingsView.OpenChannelSettingMenu, OpenChannel> listener) {
        this.menuItemClickListener = listener;
    }

    private void setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
        this.loadingDialogHandler = loadingDialogHandler;
    }

    @Override
    public boolean shouldShowLoadingDialog() {
        this.showWaitingDialog();
        return true;
    }

    @Override
    public void shouldDismissLoadingDialog() {
        this.dismissWaitingDialog();
    }

    public static class Builder {
        private final Bundle bundle = new Bundle();
        private OpenChannelSettingsFragment customFragment;
        private View.OnClickListener headerLeftButtonListener;
        private OnMenuItemClickListener<OpenChannelSettingsView.OpenChannelSettingMenu, OpenChannel> menuItemClickListener;
        private LoadingDialogHandler loadingDialogHandler;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends OpenChannelSettingsFragment> Builder setCustomOpenChannelSettingsFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderRightButton(boolean useHeaderRightButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_RIGHT_BUTTON", useHeaderRightButton);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            return this.setHeaderLeftButtonIcon(resId, null);
        }

        public Builder setHeaderLeftButtonIcon(@DrawableRes int resId, @Nullable ColorStateList tint) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            this.bundle.putParcelable("KEY_HEADER_LEFT_BUTTON_ICON_TINT", (Parcelable)tint);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public Builder setOnSettingMenuClickListener(OnMenuItemClickListener<OpenChannelSettingsView.OpenChannelSettingMenu, OpenChannel> listener) {
            this.menuItemClickListener = listener;
            return this;
        }

        public Builder setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
            this.loadingDialogHandler = loadingDialogHandler;
            return this;
        }

        public OpenChannelSettingsFragment build() {
            OpenChannelSettingsFragment fragment = this.customFragment != null ? this.customFragment : new OpenChannelSettingsFragment();
            fragment.setArguments(this.bundle);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            fragment.setOnMenuItemClickListener(this.menuItemClickListener);
            fragment.setLoadingDialogHandler(this.loadingDialogHandler);
            return fragment;
        }
    }
}

