/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.res.ColorStateList;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.GroupChannel;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.BannedListActivity;
import com.sendbird.uikit.activities.MutedMemberListActivity;
import com.sendbird.uikit.activities.OperatorListActivity;
import com.sendbird.uikit.databinding.SbFragmentModerationsBinding;
import com.sendbird.uikit.fragments.BaseGroupChannelFragment;
import com.sendbird.uikit.interfaces.LoadingDialogHandler;
import com.sendbird.uikit.interfaces.OnMenuItemClickListener;
import com.sendbird.uikit.log.Logger;

public class ModerationFragment
extends BaseGroupChannelFragment
implements LoadingDialogHandler {
    private LoadingDialogHandler loadingDialogHandler;
    private SbFragmentModerationsBinding binding;
    protected View.OnClickListener headerLeftButtonListener;
    protected OnMenuItemClickListener<ModerationMenu, BaseChannel> menuItemClickListener;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> ModerationFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentModerationsBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_moderations, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initHeaderOnCreated();
    }

    @Override
    protected void onReadyFailure() {
    }

    @Override
    protected void onConfigure() {
    }

    @Override
    protected void onDrawPage() {
        this.initHeaderOnReady();
        this.initModerations(this.channel);
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_channel_settings_moderations);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        ColorStateList headerLeftButtonIconTint = null;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", this.getString(R.string.sb_text_channel_settings_moderations));
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
            headerLeftButtonIconTint = (ColorStateList)args.getParcelable("KEY_HEADER_LEFT_BUTTON_ICON_TINT");
        }
        this.binding.abSettingsHeader.setVisibility(useHeader ? 0 : 8);
        this.binding.abSettingsHeader.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abSettingsHeader.setUseRightButton(false);
        this.binding.abSettingsHeader.setUseLeftImageButton(useHeaderLeftButton);
        this.binding.abSettingsHeader.setLeftImageButtonResource(headerLeftButtonIconResId);
        if (args != null && args.containsKey("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID")) {
            this.binding.abSettingsHeader.setLeftImageButtonTint(headerLeftButtonIconTint);
        }
        this.binding.abSettingsHeader.setLeftImageButtonClickListener(v -> this.finish());
    }

    private void initHeaderOnReady() {
        if (this.headerLeftButtonListener != null) {
            this.binding.abSettingsHeader.setLeftImageButtonClickListener(this.headerLeftButtonListener);
        }
    }

    private void initModerations(@NonNull GroupChannel channel) {
        if (this.loadingDialogHandler == null) {
            this.loadingDialogHandler = this;
        }
        this.binding.vgContent.setBackgroundResource(SendBirdUIKit.isDarkMode() ? R.color.background_600 : R.color.background_50);
        this.binding.operatorsItem.setOnClickListener(v -> {
            Logger.dev("++ operation item clicked");
            if (this.menuItemClickListener != null && this.menuItemClickListener.onMenuItemClicked(v, ModerationMenu.OPERATORS, (BaseChannel)channel)) {
                return;
            }
            this.startActivity(OperatorListActivity.newIntent(this.getContext(), channel.getUrl()));
        });
        this.binding.freezeChannelItem.setChecked(channel.isFrozen());
        this.binding.mutedMembersItem.setOnClickListener(v -> {
            Logger.dev("++ muted item clicked");
            if (this.menuItemClickListener != null && this.menuItemClickListener.onMenuItemClicked(v, ModerationMenu.MUTED_MEMBERS, (BaseChannel)channel)) {
                return;
            }
            this.startActivity(MutedMemberListActivity.newIntent(this.getContext(), channel.getUrl()));
        });
        this.binding.bannedMembersItem.setOnClickListener(v -> {
            Logger.dev("++ banned item clicked");
            if (this.menuItemClickListener != null && this.menuItemClickListener.onMenuItemClicked(v, ModerationMenu.BANNED_MEMBERS, (BaseChannel)channel)) {
                return;
            }
            this.startActivity(BannedListActivity.newIntent(this.getContext(), channel.getUrl()));
        });
        if (channel instanceof GroupChannel) {
            boolean isBroadcast = channel.isBroadcast();
            this.binding.mutedMembersItem.setVisibility(isBroadcast ? 8 : 0);
            this.binding.freezeChannelItem.setVisibility(isBroadcast ? 8 : 0);
            this.binding.freezeChannelItem.setOnClickListener(v -> {
                Logger.dev("++ freeze item clicked");
                if (this.menuItemClickListener != null && this.menuItemClickListener.onMenuItemClicked(v, ModerationMenu.FREEZE_CHANNEL, (BaseChannel)channel)) {
                    return;
                }
                this.freezeOrUnFreezeChannel(channel);
            });
            this.binding.freezeChannelItem.setOnActionMenuClickListener(v -> {
                Logger.dev("++ menu action clicked");
                if (this.menuItemClickListener != null && this.menuItemClickListener.onMenuItemClicked(v, ModerationMenu.FREEZE_CHANNEL, (BaseChannel)channel)) {
                    return;
                }
                this.freezeOrUnFreezeChannel(channel);
            });
        } else {
            this.binding.freezeChannelItem.setVisibility(8);
        }
    }

    private void freezeOrUnFreezeChannel(@NonNull GroupChannel channel) {
        boolean isFrozen = channel.isFrozen();
        this.loadingDialogHandler.shouldShowLoadingDialog();
        if (isFrozen) {
            channel.unfreeze(e -> {
                this.loadingDialogHandler.shouldDismissLoadingDialog();
                this.binding.freezeChannelItem.setChecked(e != null);
            });
        } else {
            channel.freeze(e -> {
                this.loadingDialogHandler.shouldDismissLoadingDialog();
                this.binding.freezeChannelItem.setChecked(e == null);
            });
        }
    }

    private void setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
        this.loadingDialogHandler = loadingDialogHandler;
    }

    protected void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    protected void setOnMenuItemClickListener(OnMenuItemClickListener<ModerationMenu, BaseChannel> listener) {
        this.menuItemClickListener = listener;
    }

    @Override
    public boolean shouldShowLoadingDialog() {
        this.showWaitingDialog();
        return true;
    }

    @Override
    public void shouldDismissLoadingDialog() {
        this.dismissWaitingDialog();
    }

    public static class Builder {
        private final Bundle bundle = new Bundle();
        private ModerationFragment customFragment;
        private View.OnClickListener headerLeftButtonListener;
        private OnMenuItemClickListener<ModerationMenu, BaseChannel> menuItemClickListener;
        private LoadingDialogHandler loadingDialogHandler;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends ModerationFragment> Builder setCustomModerationFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            return this.setHeaderLeftButtonIcon(resId, null);
        }

        public Builder setHeaderLeftButtonIcon(@DrawableRes int resId, @Nullable ColorStateList tint) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            this.bundle.putParcelable("KEY_HEADER_LEFT_BUTTON_ICON_TINT", (Parcelable)tint);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public Builder setOnMenuItemClickListener(OnMenuItemClickListener<ModerationMenu, BaseChannel> listener) {
            this.menuItemClickListener = listener;
            return this;
        }

        public Builder setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
            this.loadingDialogHandler = loadingDialogHandler;
            return this;
        }

        public ModerationFragment build() {
            ModerationFragment fragment = this.customFragment != null ? this.customFragment : new ModerationFragment();
            fragment.setArguments(this.bundle);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            fragment.setOnMenuItemClickListener(this.menuItemClickListener);
            fragment.setLoadingDialogHandler(this.loadingDialogHandler);
            return fragment;
        }
    }

    public static enum ModerationMenu {
        OPERATORS,
        MUTED_MEMBERS,
        BANNED_MEMBERS,
        FREEZE_CHANNEL;

    }
}

