/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewDialogListItemBinding;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.model.DialogListItem;
import com.sendbird.uikit.utils.DrawableUtils;

class DialogListAdapter
extends RecyclerView.Adapter<ListViewHolder> {
    private DialogListItem[] items;
    private OnItemClickListener<Integer> listener;
    private int nameMarginLeft = R.dimen.sb_size_24;
    private boolean isIconLeft;

    DialogListAdapter(DialogListItem[] items, OnItemClickListener<Integer> listener, boolean isIconLeft) {
        this.items = items;
        this.listener = listener;
        this.isIconLeft = isIconLeft;
    }

    void setNameMarginLeft(int resId) {
        this.nameMarginLeft = resId;
    }

    @NonNull
    public ListViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ListViewHolder(SbViewDialogListItemBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false), this.listener, this.nameMarginLeft, this.isIconLeft);
    }

    public void onBindViewHolder(@NonNull ListViewHolder holder, int position) {
        if (this.items != null && position >= 0 && position < this.items.length) {
            holder.bind(this.items[position]);
        }
    }

    public int getItemCount() {
        return this.items == null ? 0 : this.items.length;
    }

    static class ListViewHolder
    extends RecyclerView.ViewHolder {
        private SbViewDialogListItemBinding binding;
        private Context context;
        private int listItemAppearance;
        private ColorStateList buttonTint;
        private OnItemClickListener<Integer> listener;
        private boolean isIconLeft;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ListViewHolder(SbViewDialogListItemBinding binding, OnItemClickListener<Integer> listener, int nameMarginLeft, boolean isIconLeft) {
            super(binding.getRoot());
            this.binding = binding;
            this.listener = listener;
            this.isIconLeft = isIconLeft;
            this.context = binding.getRoot().getContext();
            TypedArray a = this.context.getTheme().obtainStyledAttributes(null, R.styleable.DialogView, R.attr.sb_dialog_view_style, 0);
            try {
                this.listItemAppearance = a.getResourceId(R.styleable.DialogView_sb_dialog_view_list_item_appearance, R.style.SendbirdSubtitle2OnLight01);
                int listItemBackground = a.getResourceId(R.styleable.DialogView_sb_dialog_view_list_item_background, R.drawable.selector_rectangle_light);
                this.buttonTint = a.getColorStateList(R.styleable.DialogView_sb_dialog_view_icon_tint);
                this.binding.clItem.setBackgroundResource(listItemBackground);
                ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)binding.name.getLayoutParams();
                params.setMargins((int)this.context.getResources().getDimension(nameMarginLeft), 0, 0, 0);
            }
            finally {
                a.recycle();
            }
        }

        private void bind(DialogListItem item) {
            if (item != null && item.getKey() != 0) {
                this.binding.name.setText(item.getKey());
                this.binding.name.setTextAppearance(this.context, this.listItemAppearance);
            }
            if (item != null && item.getIcon() != 0) {
                Drawable icon = DrawableUtils.setTintList(this.itemView.getContext(), item.getIcon(), this.buttonTint);
                if (this.isIconLeft) {
                    this.binding.iconLeft.setVisibility(0);
                    this.binding.iconLeft.setImageDrawable(icon);
                } else {
                    this.binding.iconRight.setVisibility(0);
                    this.binding.iconRight.setImageDrawable(icon);
                }
            }
            this.binding.getRoot().setOnClickListener(v -> {
                if (this.listener != null && item != null && item.getKey() != 0) {
                    this.listener.onItemClick(this.binding.getRoot(), this.getAdapterPosition(), item.getKey());
                }
            });
            if (item != null && item.isAlert()) {
                int alertColor = SendBirdUIKit.isDarkMode() ? R.color.error_200 : R.color.error_300;
                this.binding.name.setTextColor(this.context.getResources().getColor(alertColor));
            }
        }
    }
}

