/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.sendbird.android.BaseMessage;
import com.sendbird.uikit.activities.adapter.BaseAdapter;
import com.sendbird.uikit.activities.viewholder.BaseViewHolder;
import com.sendbird.uikit.databinding.SbViewSearchResultPreviewBinding;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MessageSearchAdapter
extends BaseAdapter<BaseMessage, BaseViewHolder<BaseMessage>> {
    private List<BaseMessage> items = new ArrayList<BaseMessage>();
    private OnItemClickListener<BaseMessage> listener;

    @NonNull
    public BaseViewHolder<BaseMessage> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new SearchResultViewHolder(SbViewSearchResultPreviewBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false));
    }

    public void onBindViewHolder(@NonNull BaseViewHolder<BaseMessage> holder, int position) {
        holder.bind(this.getItem(position));
    }

    @Override
    public BaseMessage getItem(int position) {
        return this.items.get(position);
    }

    @Override
    public List<BaseMessage> getItems() {
        return this.items != null ? Collections.unmodifiableList(this.items) : null;
    }

    public long getItemId(int position) {
        return this.getItem(position).getMessageId();
    }

    public int getItemCount() {
        return this.items != null ? this.items.size() : 0;
    }

    public void setItems(List<BaseMessage> items) {
        this.items = items;
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(@Nullable OnItemClickListener<BaseMessage> listener) {
        this.listener = listener;
    }

    private class SearchResultViewHolder
    extends BaseViewHolder<BaseMessage> {
        private final SbViewSearchResultPreviewBinding binding;

        public SearchResultViewHolder(SbViewSearchResultPreviewBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
            this.binding.getRoot().setOnClickListener(v -> {
                int position = this.getAdapterPosition();
                if (position != -1 && MessageSearchAdapter.this.listener != null) {
                    BaseMessage message = MessageSearchAdapter.this.getItem(position);
                    MessageSearchAdapter.this.listener.onItemClick(v, position, message);
                }
            });
        }

        @Override
        public void bind(BaseMessage message) {
            this.binding.setMessage(message);
            this.binding.executePendingBindings();
        }
    }
}

