/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.model;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.sendbird.android.FileMessage;
import com.sendbird.android.FileMessageParams;
import com.sendbird.android.SendBirdException;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.interfaces.OnResultHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.tasks.JobResultTask;
import com.sendbird.uikit.tasks.TaskQueue;
import com.sendbird.uikit.utils.FileUtils;
import com.sendbird.uikit.utils.ImageUtils;
import com.sendbird.uikit.utils.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.Future;

public final class FileInfo {
    private static final int MAX_COMPRESS_QUALITY = 100;
    private final Uri uri;
    private final String path;
    private final int size;
    private final String mimeType;
    private final String fileName;
    private final int thumbnailWidth;
    private final int thumbnailHeight;
    private final String thumbnailPath;

    public FileInfo(String path, int size, String mimeType, String fileName, Uri uri, int thumbnailWidth, int thumbnailHeight, String thumbnailPath) {
        this.path = path;
        this.size = size;
        this.mimeType = mimeType;
        this.fileName = fileName;
        this.uri = uri;
        this.thumbnailWidth = thumbnailWidth;
        this.thumbnailHeight = thumbnailHeight;
        this.thumbnailPath = thumbnailPath;
    }

    public String getPath() {
        return this.path;
    }

    public int getSize() {
        return this.size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Uri getUri() {
        return this.uri;
    }

    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public int getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public String getThumbnailPath() {
        return this.thumbnailPath;
    }

    public File getThumbnailFile() {
        File file = null;
        if (!TextUtils.isEmpty(this.thumbnailPath) && (file = new File(this.thumbnailPath)).exists()) {
            return file;
        }
        return file;
    }

    public File getFile() {
        File file = null;
        if (!TextUtils.isEmpty(this.path) && (file = new File(this.path)).exists() && file.length() > 0L) {
            return file;
        }
        return file;
    }

    public FileMessageParams toFileParams() {
        FileMessageParams params = new FileMessageParams();
        params.setMimeType(this.getMimeType());
        params.setFileName(this.getFileName());
        params.setFileSize(this.getSize());
        File file = this.getFile();
        if (file != null) {
            params.setFile(file);
        }
        int thumbWidth = this.getThumbnailWidth();
        int thumbHeight = this.getThumbnailHeight();
        if (thumbWidth > 0 && thumbHeight > 0) {
            Logger.dev("++ image width : %s, image height : %s", thumbWidth, thumbHeight);
            ArrayList<FileMessage.ThumbnailSize> thumbnailSizes = new ArrayList<FileMessage.ThumbnailSize>();
            thumbnailSizes.add(new FileMessage.ThumbnailSize(thumbWidth, thumbHeight));
            thumbnailSizes.add(new FileMessage.ThumbnailSize(thumbWidth / 2, thumbHeight / 2));
            params.setThumbnailSizes(thumbnailSizes);
        }
        return params;
    }

    private static boolean isCompressible(@NonNull String mimeType) {
        return mimeType.startsWith("image") && (mimeType.endsWith("jpeg") || mimeType.endsWith("jpg") || mimeType.endsWith("png"));
    }

    public static Future<FileInfo> fromUri(final @NonNull Context context, final @NonNull Uri uri, final boolean useImageCompression, final @Nullable OnResultHandler<FileInfo> handler) {
        return TaskQueue.addTask(new JobResultTask<FileInfo>(){

            @Override
            public FileInfo call() throws IOException {
                FileInfo fileInfo = null;
                try (Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);){
                    String path;
                    String mimeType = context.getContentResolver().getType(uri);
                    String originPath = path = FileUtils.uriToPath(context, uri);
                    Pair<Integer, Integer> resizingSize = SendBirdUIKit.getResizingSize();
                    if (cursor != null) {
                        int nameIndex = cursor.getColumnIndex("_display_name");
                        int sizeIndex = cursor.getColumnIndex("_size");
                        String thumbnailPath = path;
                        int thumbnailWidth = (Integer)resizingSize.first / 2;
                        int thumbnailHeight = (Integer)resizingSize.second / 2;
                        if (cursor.moveToFirst()) {
                            String name = cursor.getString(nameIndex);
                            int size = (int)cursor.getLong(sizeIndex);
                            Bitmap bitmap = null;
                            if (mimeType != null) {
                                bitmap = ImageUtils.getThumbnailBitmap(originPath, mimeType);
                            }
                            if (bitmap != null) {
                                File file = FileUtils.bitmapToFile(bitmap, FileUtils.createDeletableFile(context, "thumb_" + name), FileUtils.extractBitmapFormat(mimeType));
                                thumbnailWidth = bitmap.getWidth();
                                thumbnailHeight = bitmap.getHeight();
                                if (file.length() > 0L) {
                                    thumbnailPath = file.getAbsolutePath();
                                }
                            }
                            if (useImageCompression && mimeType != null && FileInfo.isCompressible(mimeType)) {
                                int quality = SendBirdUIKit.getCompressQuality();
                                if (quality < 0 || quality > 100) {
                                    throw new IllegalArgumentException("quality must be 0..100");
                                }
                                Logger.d("++ file size=%s, size from db=%s", new File(path).length(), size);
                                int originSize = size;
                                path = FileInfo.resizeImage(context, originPath, mimeType, quality, (Integer)resizingSize.first, (Integer)resizingSize.second);
                                size = (int)new File(path).length();
                                Logger.d("++ originFile size=%s, resized file size=%s", originSize, size);
                                Logger.d("\n++ originFile path=%s, \n resized file path=%s\n", originPath, path);
                                if (!originPath.equals(path) && size != originSize) {
                                    Logger.d("++ file has been resized. the original file will remove.");
                                    new File(originPath).delete();
                                }
                            }
                            Logger.d("==============================================================================");
                            Logger.d("++ FILE PATH : %s", path);
                            Logger.d("++ SIZE : %s", size);
                            Logger.d("++ MIMETYPE : %s", mimeType);
                            Logger.d("++ NAME : %s", name);
                            Logger.d("++ THUMBNAIL PATH : %s", thumbnailPath);
                            Logger.d("++ THUMBNAIL HEIGHT : %s", thumbnailWidth);
                            Logger.d("++ THUMBNAIL HEIGHT : %s", thumbnailHeight);
                            Logger.d("==============================================================================");
                            fileInfo = new FileInfo(path, size, mimeType, name, uri, thumbnailWidth, thumbnailHeight, thumbnailPath);
                        }
                    }
                }
                return fileInfo;
            }

            @Override
            public void onResultForUiThread(FileInfo info, SendBirdException e) {
                if (handler == null) {
                    return;
                }
                if (e != null || info == null) {
                    Logger.w((Throwable)e);
                    handler.onError(e);
                    return;
                }
                handler.onResult(info);
            }
        });
    }

    private static String resizeImage(@NonNull Context context, @NonNull String path, @NonNull String mimeType, int quality, int width, int height) throws IOException {
        int inSampleSize = ImageUtils.calculateInSampleSize(path, width, height);
        if (inSampleSize > 1 || !mimeType.endsWith("png") && quality < 100) {
            File originFile = new File(path);
            String tempFileName = String.format(Locale.US, "Resized_%s_%s", quality, originFile.getName());
            File destFile = FileUtils.createCachedDirFile(context, tempFileName);
            if (destFile != null && destFile.exists() && destFile.length() > 0L) {
                Logger.d("++ resized file exists");
                return destFile.getAbsolutePath();
            }
            Bitmap bitmap = ImageUtils.getBitmap(path, width, height);
            if (bitmap != null) {
                Logger.d("++ resized image with=%s, height=%s", bitmap.getWidth(), bitmap.getHeight());
                return FileUtils.bitmapToFile(bitmap, destFile, quality, FileUtils.extractBitmapFormat(mimeType)).getAbsolutePath();
            }
        }
        return path;
    }

    public void clear() {
        File file;
        Logger.d(">> FileInfo::clear()");
        if (!TextUtils.isEmpty(this.path) && (file = new File(this.path)) != null && file.exists()) {
            boolean deleted = file.delete();
            Logger.d("-- file delete=%s, path=%s", deleted, this.path);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)o;
        return this.uri.equals((Object)fileInfo.getUri());
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return "FileInfo{path='" + this.path + '\'' + ", size=" + this.size + ", mimeType='" + this.mimeType + '\'' + ", fileName='" + this.fileName + '\'' + ", uri=" + this.uri + ", thumbnailWidth=" + this.thumbnailWidth + ", thumbnailHeight=" + this.thumbnailHeight + '}';
    }
}

