/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.fragments.PermissionFragment;
import com.sendbird.uikit.interfaces.DialogProvider;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.utils.ContextUtils;
import com.sendbird.uikit.utils.EventProvider;
import com.sendbird.uikit.widgets.WaitingDialog;

abstract class BaseFragment
extends PermissionFragment
implements DialogProvider {
    private final String CONNECTION_HANDLER_ID = this.getClass().getName() + System.currentTimeMillis();

    BaseFragment() {
    }

    public abstract void onReady(User var1, ReadyStatus var2);

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.connect();
    }

    protected boolean isActive() {
        boolean isDeactivated = this.isRemoving() || this.isDetached() || this.getContext() == null;
        return !isDeactivated;
    }

    protected void connect() {
        Logger.dev(">> BaseFragment::connect()");
        SendBirdUIKit.connect((user, e) -> {
            ReadyStatus status;
            Logger.dev("++ BaseFragment::connect e : " + e);
            if (e != null) {
                if (SendBird.getCurrentUser() != null) {
                    SendBird.addConnectionHandler((String)this.CONNECTION_HANDLER_ID, (SendBird.ConnectionHandler)new SendBird.ConnectionHandler(){

                        public void onReconnectStarted() {
                        }

                        public void onReconnectSucceeded() {
                            if (!BaseFragment.this.isActive()) {
                                return;
                            }
                            SendBird.removeConnectionHandler((String)BaseFragment.this.CONNECTION_HANDLER_ID);
                            BaseFragment.this.onReady(SendBird.getCurrentUser(), ReadyStatus.READY);
                        }

                        public void onReconnectFailed() {
                            if (!BaseFragment.this.isActive()) {
                                return;
                            }
                            SendBird.removeConnectionHandler((String)BaseFragment.this.CONNECTION_HANDLER_ID);
                            BaseFragment.this.onReady(null, ReadyStatus.ERROR);
                        }
                    });
                    return;
                }
                status = ReadyStatus.ERROR;
            } else {
                status = ReadyStatus.READY;
            }
            if (!this.isActive()) {
                return;
            }
            this.onReady(SendBird.getCurrentUser(), status);
        });
    }

    public void onDestroy() {
        super.onDestroy();
        SendBird.removeConnectionHandler((String)this.CONNECTION_HANDLER_ID);
        EventProvider.getInstance().unRegister(this.getClass());
    }

    @Override
    public void showWaitingDialog() {
        WaitingDialog.show(this.getContext());
    }

    @Override
    public void dismissWaitingDialog() {
        WaitingDialog.dismiss();
    }

    @Override
    public void toastError(int messageRes) {
        ContextUtils.toastError(this.getContext(), messageRes);
    }

    @Override
    public void toastError(@NonNull String message) {
        ContextUtils.toastError(this.getContext(), message);
    }

    @Override
    public void toastSuccess(int messageRes) {
        ContextUtils.toastSuccess(this.getContext(), messageRes);
    }

    protected void finish() {
        if (this.getActivity() != null) {
            this.getActivity().finish();
        }
    }

    protected boolean containsExtra(String key) {
        Bundle args = this.getArguments();
        return args != null && args.containsKey(key);
    }

    @Nullable
    protected String getStringExtra(String key) {
        Bundle args = this.getArguments();
        if (args != null) {
            return args.getString(key);
        }
        return null;
    }
}

