/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;

class WrapHeightImageView
extends AppCompatImageView {
    private int targetWidth = 0;
    private int targetHeight = 0;

    public WrapHeightImageView(Context context) {
        this(context, null);
    }

    public WrapHeightImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WrapHeightImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setSize(int width, int height) {
        this.targetWidth = width;
        this.targetHeight = height;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.targetWidth > 0 && this.targetHeight > 0) {
            this.applyMeasuredDimension(this.targetWidth, this.targetHeight);
        } else {
            Drawable d = this.getDrawable();
            if (d != null) {
                int dWidth = d.getIntrinsicWidth();
                int dHeight = d.getIntrinsicHeight();
                this.applyMeasuredDimension(dWidth, dHeight);
            } else if (this.targetWidth > 0 && this.targetHeight > 0) {
                this.applyMeasuredDimension(this.targetWidth, this.targetHeight);
            } else {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
    }

    private void applyMeasuredDimension(int width, int height) {
        float newWidth;
        float newHeight;
        float minWidth = this.getMinimumWidth();
        float minHeight = this.getMinimumHeight();
        float maxWidth = this.getMaxWidth();
        float maxHeight = this.getMaxHeight();
        if ((float)width < minWidth) {
            newHeight = minWidth / (float)width * (float)height;
            if (newHeight > minHeight) {
                newWidth = minWidth;
                newHeight = Math.min(newHeight, maxHeight);
            } else {
                newWidth = Math.min(minHeight / (float)height * (float)width, maxWidth);
                newHeight = minHeight;
            }
        } else if ((float)width > maxWidth) {
            newHeight = maxWidth * (float)height / (float)width;
            if (newHeight > minHeight) {
                newWidth = maxWidth;
                newHeight = Math.min(newHeight, maxHeight);
            } else {
                newWidth = Math.min(minHeight / (float)height * (float)width, maxWidth);
                newHeight = minHeight;
            }
        } else if ((float)height > minHeight) {
            newWidth = width;
            newHeight = Math.min((float)height, maxHeight);
        } else {
            newWidth = Math.min(minHeight / (float)height * (float)width, maxWidth);
            newHeight = minHeight;
        }
        this.setMeasuredDimension((int)Math.ceil(newWidth), (int)Math.ceil(newHeight));
    }
}

