/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.databinding.DataBindingUtil;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewToastBinding;

public class ToastView
extends FrameLayout {
    private SbViewToastBinding binding;

    public ToastView(@NonNull Context context) {
        this(context, null);
    }

    public ToastView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_toast_view_style);
    }

    public ToastView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ToastView, defStyleAttr, 0);
        try {
            this.binding = (SbViewToastBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_toast, (ViewGroup)this, (boolean)true);
            int background = a.getResourceId(R.styleable.ToastView_sb_toast_background, R.drawable.sb_rounded_rectangle_dark);
            int textAppearance = a.getResourceId(R.styleable.ToastView_sb_toast_text_appearance, R.style.SendbirdBody1OnDark01);
            this.binding.toastPanel.setBackgroundResource(background);
            this.binding.toastPanel.getBackground().setAlpha(163);
            this.binding.tvToastText.setTextAppearance(context, textAppearance);
        }
        finally {
            a.recycle();
        }
    }

    public void setText(@StringRes int text) {
        this.binding.tvToastText.setText(text);
    }

    public void setText(CharSequence text) {
        this.binding.tvToastText.setText(text);
    }

    public void setStauts(ToastStatus status) {
        if (status == ToastStatus.SUCCESS) {
            this.binding.ivError.setVisibility(8);
            this.binding.ivSuccess.setVisibility(0);
        } else if (status == ToastStatus.ERROR) {
            this.binding.ivError.setVisibility(0);
            this.binding.ivSuccess.setVisibility(8);
        }
    }

    public static enum ToastStatus {
        SUCCESS,
        ERROR;

    }
}

