/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.databinding.DataBindingUtil;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewStatusFrameBinding;
import com.sendbird.uikit.utils.DrawableUtils;

public class StatusFrameView
extends FrameLayout {
    private SbViewStatusFrameBinding binding;
    private ColorStateList iconTint;
    private int errorIcon;
    private int errorText;
    private int emptyIcon;
    private int emptyText;
    private boolean showAction;
    private int actionText;

    public StatusFrameView(@NonNull Context context) {
        this(context, null);
    }

    public StatusFrameView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_status_frame_style);
    }

    public StatusFrameView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.StatusFrameView, defStyle, 0);
        try {
            this.binding = (SbViewStatusFrameBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_status_frame, (ViewGroup)this, (boolean)true);
            int background = a.getResourceId(R.styleable.StatusFrameView_sb_status_frame_background, R.color.primary_100);
            int alertTextAppearance = a.getResourceId(R.styleable.StatusFrameView_sb_status_frame_text_appearance, R.style.SendbirdBody2OnLight03);
            this.iconTint = a.getColorStateList(R.styleable.StatusFrameView_sb_status_frame_icon_tint);
            this.errorIcon = a.getResourceId(R.styleable.StatusFrameView_sb_status_frame_error_icon, R.drawable.icon_error);
            this.errorText = a.getResourceId(R.styleable.StatusFrameView_sb_status_frame_error_text, R.string.sb_text_error_unknown);
            this.emptyIcon = a.getResourceId(R.styleable.StatusFrameView_sb_status_frame_empty_icon, R.drawable.icon_chat);
            this.emptyText = a.getResourceId(R.styleable.StatusFrameView_sb_status_frame_empty_text, R.string.sb_text_error_unknown);
            this.actionText = a.getResourceId(R.styleable.StatusFrameView_sb_status_frame_action_text, R.string.sb_text_button_retry);
            int actionBackground = a.getResourceId(R.styleable.StatusFrameView_sb_status_frame_action_background, R.drawable.selector_button_retry_light);
            int actionIcon = a.getResourceId(R.styleable.StatusFrameView_sb_status_frame_action_icon, R.drawable.icon_refresh);
            int actionTextAppearance = a.getResourceId(R.styleable.StatusFrameView_sb_status_frame_action_text_appearance, R.style.SendbirdButtonPrimary300);
            int actionIconTint = SendBirdUIKit.getDefaultThemeMode().getTintResId();
            this.showAction = a.getBoolean(R.styleable.StatusFrameView_sb_status_frame_show_action, false);
            this.binding.ivAlertText.setTextAppearance(this.getContext(), alertTextAppearance);
            this.binding.tvAction.setVisibility(this.showAction ? 0 : 8);
            this.binding.tvAction.setBackgroundResource(actionBackground);
            this.binding.tvAction.setCompoundDrawablesWithIntrinsicBounds(DrawableUtils.setTintList(this.getContext(), actionIcon, actionIconTint), null, null, null);
            this.binding.tvAction.setText(this.actionText);
            this.binding.tvAction.setTextAppearance(context, actionTextAppearance);
            this.binding.frameParentPanel.setBackgroundResource(background);
            this.binding.progressPanel.setBackgroundResource(background);
            this.setStatus(Status.NONE);
        }
        finally {
            a.recycle();
        }
    }

    public void setErrorText(@StringRes int text) {
        this.errorText = text;
    }

    public void setErrorIcon(@DrawableRes int errorIcon) {
        this.errorIcon = errorIcon;
    }

    public void setEmptyText(@StringRes int emptyText) {
        this.emptyText = emptyText;
    }

    public void setEmptyIcon(@DrawableRes int emptyIcon) {
        this.emptyIcon = emptyIcon;
    }

    public void setIconTint(@Nullable ColorStateList iconTint) {
        this.iconTint = iconTint;
    }

    public void setShowAction(boolean showAction) {
        this.showAction = showAction;
    }

    public void setActionText(@StringRes int actionText) {
        this.actionText = actionText;
    }

    public void setStatus(Status status) {
        this.setVisibility(0);
        this.binding.progressPanel.setVisibility(8);
        switch (status) {
            case LOADING: {
                this.binding.progressPanel.setVisibility(0);
                break;
            }
            case CONNECTION_ERROR: {
                this.setActionText(R.string.sb_text_button_retry);
                this.setErrorText(R.string.sb_text_error_retry_request);
                this.setShowAction(true);
                this.setAlert(this.errorText, this.errorIcon);
                break;
            }
            case ERROR: {
                this.setShowAction(false);
                this.setAlert(this.errorText, this.errorIcon);
                break;
            }
            case EMPTY: {
                this.setShowAction(false);
                this.setAlert(this.emptyText, this.emptyIcon);
                break;
            }
            default: {
                this.setVisibility(8);
            }
        }
    }

    public void setOnActionEventListener(@NonNull View.OnClickListener listener) {
        this.binding.tvAction.setOnClickListener(listener);
    }

    private void setAlert(@StringRes int text, @DrawableRes int iconResId) {
        this.setVisibility(0);
        this.binding.ivAlertIcon.setImageDrawable(DrawableUtils.setTintList(this.getContext(), iconResId, this.iconTint));
        this.binding.ivAlertText.setText(text);
        this.binding.tvAction.setText(this.actionText);
        this.binding.tvAction.setVisibility(this.showAction ? 0 : 8);
    }

    public static enum Status {
        LOADING,
        CONNECTION_ERROR,
        ERROR,
        EMPTY,
        NONE;

    }
}

