/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewSingleMenuItemBinding;
import com.sendbird.uikit.utils.DrawableUtils;

public class SingleMenuItemView
extends FrameLayout {
    private SbViewSingleMenuItemBinding binding;

    public SingleMenuItemView(Context context) {
        this(context, null);
    }

    public SingleMenuItemView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_single_menu_item_style);
    }

    public SingleMenuItemView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SingleMenuItemView, defStyle, 0);
        try {
            this.binding = SbViewSingleMenuItemBinding.inflate(LayoutInflater.from((Context)this.getContext()));
            this.addView(this.binding.getRoot(), -1, -1);
            String name = a.getString(R.styleable.SingleMenuItemView_sb_menu_item_name);
            int itemBackground = a.getResourceId(R.styleable.SingleMenuItemView_sb_menu_item_background, R.drawable.selector_rectangle_light);
            int nicknameAppearance = a.getResourceId(R.styleable.SingleMenuItemView_sb_menu_item_name_appearance, R.style.SendbirdSubtitle2OnLight01);
            int iconResId = a.getResourceId(R.styleable.SingleMenuItemView_sb_menu_item_icon, 0);
            int iconTintResId = a.getResourceId(R.styleable.SingleMenuItemView_sb_menu_item_icon_tint, R.color.primary_300);
            int type = a.getInteger(R.styleable.SingleMenuItemView_sb_menu_item_type, 0);
            this.binding.tvName.setTextAppearance(context, nicknameAppearance);
            this.binding.tvName.setEllipsize(TextUtils.TruncateAt.END);
            this.binding.tvName.setMaxLines(1);
            this.binding.vgMenuItem.setBackgroundResource(itemBackground);
            boolean useDarkTheme = SendBirdUIKit.isDarkMode();
            int nextTint = useDarkTheme ? R.color.ondark_01 : R.color.onlight_01;
            int divider = useDarkTheme ? R.drawable.sb_line_divider_dark : R.drawable.sb_line_divider_light;
            int switchTrackTint = useDarkTheme ? R.color.sb_switch_track_dark : R.color.sb_switch_track_light;
            int switchThumbTint = useDarkTheme ? R.color.sb_switch_thumb_dark : R.color.sb_switch_thumb_light;
            this.binding.divider.setBackgroundResource(divider);
            if (!TextUtils.isEmpty((CharSequence)name)) {
                this.setName(name);
            }
            if (iconResId > 0) {
                this.setIcon(iconResId);
            }
            this.setIconTint(iconTintResId);
            switch (type) {
                case 0: {
                    int nextResId = a.getResourceId(R.styleable.SingleMenuItemView_sb_menu_item_action_drawable, R.drawable.icon_chevron_right);
                    this.binding.ivNext.setImageResource(nextResId);
                    this.binding.scSwitch.setVisibility(8);
                    this.binding.ivNext.setVisibility(0);
                    this.binding.ivNext.setImageDrawable(DrawableUtils.setTintList(this.binding.ivNext.getDrawable(), AppCompatResources.getColorStateList((Context)context, (int)nextTint)));
                    return;
                }
                case 1: {
                    this.binding.scSwitch.setVisibility(0);
                    this.binding.ivNext.setVisibility(8);
                    this.binding.scSwitch.setTrackTintList(AppCompatResources.getColorStateList((Context)context, (int)switchTrackTint));
                    this.binding.scSwitch.setThumbTintList(AppCompatResources.getColorStateList((Context)context, (int)switchThumbTint));
                    return;
                }
            }
            return;
        }
        finally {
            a.recycle();
        }
    }

    public View getLayout() {
        return this;
    }

    public SbViewSingleMenuItemBinding getBinding() {
        return this.binding;
    }

    public void setOnClickListener(@Nullable View.OnClickListener listener) {
        this.binding.vgMenuItem.setOnClickListener(listener);
    }

    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.binding.vgMenuItem.setOnLongClickListener(listener);
    }

    public void useActionMenu(boolean use) {
        this.binding.vgAction.setVisibility(use ? 0 : 8);
    }

    public void setOnActionMenuClickListener(View.OnClickListener listener) {
        this.binding.scSwitch.setOnClickListener(listener);
        this.binding.ivNext.setOnClickListener(listener);
    }

    public void setIcon(@DrawableRes int resId) {
        this.binding.ivIcon.setImageResource(resId);
    }

    public void setIconTint(@ColorRes int tintResId) {
        this.binding.ivIcon.setImageDrawable(DrawableUtils.setTintList(this.binding.ivIcon.getDrawable(), AppCompatResources.getColorStateList((Context)this.binding.ivIcon.getContext(), (int)tintResId)));
    }

    public void setName(@NonNull String name) {
        this.binding.tvName.setText((CharSequence)name);
    }

    public void useDivider(boolean useDivider) {
        this.binding.divider.setVisibility(useDivider ? 0 : 8);
    }

    public void setChecked(boolean checked) {
        this.binding.scSwitch.setChecked(checked);
    }
}

