/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.FileMessageParams;
import com.sendbird.android.MessageListParams;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.android.UserMessageParams;
import com.sendbird.uikit.R;
import com.sendbird.uikit.consts.MessageLoadState;
import com.sendbird.uikit.interfaces.DialogProvider;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ChatMessageCollection;
import com.sendbird.uikit.model.FileInfo;
import com.sendbird.uikit.utils.ReactionUtils;
import com.sendbird.uikit.vm.BaseViewModel;
import com.sendbird.uikit.vm.MessageChangeLogsPager;
import com.sendbird.uikit.vm.PendingMessageRepository;
import com.sendbird.uikit.widgets.PagerRecyclerView;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;

public class OpenChannelViewModel
extends BaseViewModel
implements LifecycleObserver,
PagerRecyclerView.Pageable {
    private static final int DEFAULT_MESSAGE_LOAD_SIZE = 40;
    private static final String CONNECTION_HANDLER_ID = "CONNECTION_HANDLER_GROUP_CHAT";
    private static final String CHANNEL_HANDLER_ID = "CHANNEL_HANDLER_GROUP_CHANNEL_CHAT";
    private final ExecutorService worker = Executors.newSingleThreadExecutor();
    private final MutableLiveData<List<BaseMessage>> messageList = new MutableLiveData();
    private final ChatMessageCollection messageCollection = new ChatMessageCollection();
    private final MutableLiveData<OpenChannel> isChannelChanged = new MutableLiveData();
    private final MutableLiveData<Boolean> channelDeleted = new MutableLiveData();
    private final MessageListParams messageListParams;
    private final MutableLiveData<MessageLoadState> messageLoadState = new MutableLiveData();
    private final MutableLiveData<StatusFrameView.Status> statusFrame = new MutableLiveData();
    private OpenChannel channel;
    private boolean hasMore = false;

    OpenChannelViewModel(@NonNull DialogProvider provider, @NonNull OpenChannel openChannel, @Nullable MessageListParams params) {
        super(provider);
        this.channel = openChannel;
        this.messageListParams = params != null ? params : new MessageListParams();
        this.messageListParams.setReverse(true);
        this.messageListParams.setNextResultSize(0);
        this.messageListParams.setIncludeReactions(ReactionUtils.useReaction((BaseChannel)openChannel));
        if (this.messageListParams.getPreviousResultSize() <= 0) {
            this.messageListParams.setPreviousResultSize(40);
        }
    }

    private boolean isCurrentChannel(@NonNull String channelUrl) {
        return channelUrl.equals(this.channel.getUrl());
    }

    public MutableLiveData<OpenChannel> isChannelChanged() {
        return this.isChannelChanged;
    }

    public MutableLiveData<Boolean> getChannelDeleted() {
        return this.channelDeleted;
    }

    public OpenChannel getChannel() {
        return this.channel;
    }

    public LiveData<List<BaseMessage>> getMessageList() {
        return this.messageList;
    }

    public MutableLiveData<StatusFrameView.Status> getStatusFrame() {
        return this.statusFrame;
    }

    public MutableLiveData<MessageLoadState> getMessageLoadState() {
        return this.messageLoadState;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    private void onResume() {
        SendBird.addConnectionHandler((String)CONNECTION_HANDLER_ID, (SendBird.ConnectionHandler)new SendBird.ConnectionHandler(){

            public void onReconnectStarted() {
            }

            public void onReconnectSucceeded() {
                if (OpenChannelViewModel.this.channel != null) {
                    OpenChannelViewModel.this.channel.enter(e1 -> {
                        if (e1 != null) {
                            OpenChannelViewModel.this.channelDeleted.postValue((Object)true);
                            return;
                        }
                        OpenChannelViewModel.this.channel.refresh(e -> {
                            if (e != null) {
                                Logger.dev(e);
                                if (e.getCode() == 400108) {
                                    OpenChannelViewModel.this.channelDeleted.postValue((Object)true);
                                    return;
                                }
                            } else {
                                OpenChannelViewModel.this.isChannelChanged.postValue((Object)OpenChannelViewModel.this.channel);
                            }
                            OpenChannelViewModel.this.requestChangeLogs((BaseChannel)OpenChannelViewModel.this.channel);
                        });
                    });
                }
            }

            public void onReconnectFailed() {
            }
        });
        SendBird.addChannelHandler((String)CHANNEL_HANDLER_ID, (SendBird.ChannelHandler)new SendBird.ChannelHandler(){

            public void onMessageReceived(BaseChannel baseChannel, BaseMessage baseMessage) {
                if (OpenChannelViewModel.this.isCurrentChannel(baseChannel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onMessageReceived(%s)", baseMessage.getMessageId());
                    OpenChannelViewModel.this.channel = (OpenChannel)baseChannel;
                    OpenChannelViewModel.this.messageCollection.add(baseMessage);
                    OpenChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onUserEntered(OpenChannel channel, User user) {
                if (OpenChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onUserEntered()", new Object[0]);
                    Logger.d("++ joind user : " + user);
                    OpenChannelViewModel.this.channel = channel;
                    OpenChannelViewModel.this.isChannelChanged.postValue((Object)channel);
                    OpenChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onUserExited(OpenChannel channel, User user) {
                if (OpenChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onUserLeft()", new Object[0]);
                    Logger.d("++ left user : " + user);
                    OpenChannelViewModel.this.channel = channel;
                    OpenChannelViewModel.this.isChannelChanged.postValue((Object)channel);
                    OpenChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onMessageDeleted(BaseChannel baseChannel, long msgId) {
                if (OpenChannelViewModel.this.isCurrentChannel(baseChannel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onMessageDeleted()", new Object[0]);
                    Logger.d("++ deletedMessage : " + msgId);
                    OpenChannelViewModel.this.channel = (OpenChannel)baseChannel;
                    OpenChannelViewModel.this.messageCollection.removeByMessageId(msgId);
                    OpenChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onMessageUpdated(BaseChannel baseChannel, BaseMessage updatedMessage) {
                if (OpenChannelViewModel.this.isCurrentChannel(baseChannel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onMessageUpdated()", new Object[0]);
                    Logger.d("++ updatedMessage : " + updatedMessage.getMessageId());
                    OpenChannelViewModel.this.channel = (OpenChannel)baseChannel;
                    OpenChannelViewModel.this.messageCollection.update(updatedMessage);
                    OpenChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onChannelChanged(BaseChannel channel) {
                if (OpenChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onChannelChanged()", new Object[0]);
                    OpenChannelViewModel.this.channel = (OpenChannel)channel;
                    OpenChannelViewModel.this.isChannelChanged.postValue((Object)((OpenChannel)channel));
                }
            }

            public void onChannelDeleted(String channelUrl, BaseChannel.ChannelType channelType) {
                if (OpenChannelViewModel.this.isCurrentChannel(channelUrl)) {
                    Logger.i(">> ChannelFragnemt::onChannelDeleted()", new Object[0]);
                    Logger.d("++ deleted channel url : " + channelUrl);
                    OpenChannelViewModel.this.channelDeleted.postValue((Object)true);
                }
            }

            public void onChannelFrozen(BaseChannel channel) {
                if (OpenChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onChannelFrozen(%s)", channel.isFrozen());
                    OpenChannelViewModel.this.channel = (OpenChannel)channel;
                    OpenChannelViewModel.this.isChannelChanged.postValue((Object)((OpenChannel)channel));
                    OpenChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onChannelUnfrozen(BaseChannel channel) {
                if (OpenChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onChannelUnfrozen(%s)", channel.isFrozen());
                    OpenChannelViewModel.this.channel = (OpenChannel)channel;
                    OpenChannelViewModel.this.isChannelChanged.postValue((Object)((OpenChannel)channel));
                    OpenChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onOperatorUpdated(BaseChannel channel) {
                if (OpenChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onOperatorUpdated()", new Object[0]);
                    OpenChannelViewModel.this.channel = (OpenChannel)channel;
                    Logger.i("++ Am I an operator : " + ((OpenChannel)channel).isOperator(SendBird.getCurrentUser()), new Object[0]);
                    OpenChannelViewModel.this.isChannelChanged.postValue((Object)((OpenChannel)channel));
                    OpenChannelViewModel.this.notifyDataSetChanged();
                }
            }

            public void onUserBanned(BaseChannel channel, User user) {
                if (OpenChannelViewModel.this.isCurrentChannel(channel.getUrl()) && user.getUserId().equals(SendBird.getCurrentUser().getUserId())) {
                    Logger.i(">> ChannelFragnemt::onUserBanned()", new Object[0]);
                    OpenChannelViewModel.this.channelDeleted.postValue((Object)true);
                }
            }

            public void onUserMuted(BaseChannel channel, User user) {
                if (OpenChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onUserMuted()", new Object[0]);
                    OpenChannelViewModel.this.channel = (OpenChannel)channel;
                    OpenChannelViewModel.this.isChannelChanged.postValue((Object)((OpenChannel)channel));
                }
            }

            public void onUserUnmuted(BaseChannel channel, User user) {
                if (OpenChannelViewModel.this.isCurrentChannel(channel.getUrl())) {
                    Logger.i(">> ChannelFragnemt::onUserUnmuted()", new Object[0]);
                    OpenChannelViewModel.this.channel = (OpenChannel)channel;
                    OpenChannelViewModel.this.isChannelChanged.postValue((Object)((OpenChannel)channel));
                }
            }
        });
        this.requestChangeLogs((BaseChannel)this.channel);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    private void onDestroy() {
        SendBird.removeConnectionHandler((String)CONNECTION_HANDLER_ID);
        SendBird.removeChannelHandler((String)CHANNEL_HANDLER_ID);
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public void loadMore() {
        this.load();
    }

    public void load() {
        this.worker.execute(() -> {
            try {
                this.messageLoadState.postValue((Object)MessageLoadState.LOAD_STARTED);
                int cacheMessageSize = this.messageCollection.size();
                long ts = cacheMessageSize > 0 ? this.messageCollection.first().getCreatedAt() : Long.MAX_VALUE;
                List<BaseMessage> newMessageList = this.loadPrevious(ts);
                Logger.i("++ load previous message list : " + newMessageList, new Object[0]);
                this.hasMore = newMessageList.size() > 0;
                this.messageCollection.addAll(newMessageList);
            }
            catch (Exception e) {
                Logger.w(e);
            }
            finally {
                this.notifyDataSetChanged();
                this.messageLoadState.postValue((Object)MessageLoadState.LOAD_ENDED);
            }
        });
    }

    private List<BaseMessage> loadPrevious(long ts) throws Exception {
        Logger.dev(">> ChannelViewModel::loadPrevious()");
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        this.channel.getMessagesByTimestamp(ts, this.messageListParams, (messages, e) -> {
            try {
                if (e != null) {
                    error.set(e);
                    return;
                }
                result.set(messages);
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
        if (error.get() != null) {
            throw (Exception)error.get();
        }
        List newMessageList = (List)result.get();
        Logger.i("++ load previous result size : " + newMessageList.size(), new Object[0]);
        return newMessageList;
    }

    @Override
    protected void onCleared() {
        super.onCleared();
        Logger.dev("-- onCleared ChannelViewModel");
        this.worker.shutdownNow();
    }

    private void notifyDataSetChanged() {
        List<BaseMessage> currentList = this.messageCollection.copyToList();
        currentList.addAll(0, PendingMessageRepository.getInstance().getPendingMessageList(this.channel.getUrl()));
        if (currentList.size() == 0) {
            this.statusFrame.postValue((Object)StatusFrameView.Status.EMPTY);
        } else {
            this.statusFrame.postValue((Object)StatusFrameView.Status.NONE);
            this.messageList.postValue(currentList);
        }
    }

    private void requestChangeLogs(@NonNull BaseChannel channel) {
        String channelUrl = channel.getUrl();
        int cacheMessageSize = this.messageCollection.size();
        long lastSyncTs = cacheMessageSize > 0 ? this.messageCollection.last().getCreatedAt() : 0L;
        Logger.dev("++ change logs channel url = %s, lastSyncTs = %s", channelUrl, lastSyncTs);
        if (lastSyncTs > 0L) {
            MessageChangeLogsPager pager = new MessageChangeLogsPager(channel, lastSyncTs, this.messageListParams);
            pager.load(new MessageChangeLogsPager.MessageChangeLogsResultHandler(){

                @Override
                public void onError(SendBirdException e) {
                    Logger.e(e);
                }

                @Override
                public void onResult(List<BaseMessage> added, List<BaseMessage> updated, List<Long> deletedIds) {
                    Logger.i("++ channel message change logs result >> deleted message size : %s, current message size : %s, added message size : %s", deletedIds.size(), OpenChannelViewModel.this.messageCollection.size(), added.size());
                    for (long deletedId : deletedIds) {
                        BaseMessage deletedMessage = OpenChannelViewModel.this.messageCollection.get(deletedId);
                        if (deletedMessage == null) continue;
                        OpenChannelViewModel.this.messageCollection.remove(deletedMessage);
                    }
                    Logger.i("++ updated Message size : %s", updated.size());
                    OpenChannelViewModel.this.messageCollection.updateAll(updated);
                    if (added.size() > 0) {
                        OpenChannelViewModel.this.messageCollection.addAll(added);
                    }
                    Logger.i("++ merged message size : %s", OpenChannelViewModel.this.messageCollection.size());
                    boolean changed = added.size() > 0 || updated.size() > 0 || deletedIds.size() > 0;
                    Logger.dev("++ changeLogs updated : %s", changed);
                    if (changed) {
                        OpenChannelViewModel.this.notifyDataSetChanged();
                    }
                }
            });
        }
    }

    public void sendUserMessage(@NonNull UserMessageParams params) {
        Logger.i("++ request send message : %s", params);
        String channelUrl = this.channel.getUrl();
        UserMessage pendingUserMessage = this.channel.sendUserMessage(params, (message, e) -> {
            if (e != null) {
                Logger.e(e);
                PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)message);
                this.notifyDataSetChanged();
                return;
            }
            Logger.i("++ sent message : %s", message);
            this.messageCollection.add((BaseMessage)message);
            PendingMessageRepository.getInstance().removePendingMessage(channelUrl, (BaseMessage)message);
            this.notifyDataSetChanged();
        });
        PendingMessageRepository.getInstance().addPendingMessage(channelUrl, (BaseMessage)pendingUserMessage);
        this.notifyDataSetChanged();
    }

    public void sendFileMessage(@NonNull FileMessageParams params, @NonNull FileInfo fileInfo) {
        Logger.i("++ request send file message : %s", params);
        String channelUrl = this.channel.getUrl();
        FileMessage pendingFileMessage = this.channel.sendFileMessage(params, (message, ee) -> {
            if (ee != null) {
                Logger.e(ee);
                if (message != null) {
                    PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)message);
                    this.notifyDataSetChanged();
                }
                if (ee.getMessage() != null) {
                    this.provider.toastError(R.string.sb_text_error_send_message);
                }
                return;
            }
            Logger.i("++ sent message : %s", message);
            this.messageCollection.add((BaseMessage)message);
            PendingMessageRepository.getInstance().removePendingMessage(channelUrl, (BaseMessage)message);
            this.notifyDataSetChanged();
        });
        if (pendingFileMessage != null) {
            PendingMessageRepository.getInstance().addPendingMessage(channelUrl, (BaseMessage)pendingFileMessage);
            PendingMessageRepository.getInstance().addFileInfo(pendingFileMessage, fileInfo);
            this.notifyDataSetChanged();
        }
    }

    public void resendMessage(@NonNull BaseMessage message) {
        String channelUrl = this.channel.getUrl();
        if (message instanceof UserMessage) {
            UserMessage pendingMessage = this.channel.resendMessage((UserMessage)message, (message12, e) -> {
                if (e != null) {
                    Logger.e(e);
                    this.provider.toastError(R.string.sb_text_error_resend_message);
                    PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)message12);
                    this.notifyDataSetChanged();
                    return;
                }
                Logger.i("__ resent message : %s", message12);
                this.messageCollection.add((BaseMessage)message12);
                PendingMessageRepository.getInstance().removePendingMessage(channelUrl, (BaseMessage)message12);
                this.notifyDataSetChanged();
            });
            PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)pendingMessage);
            this.notifyDataSetChanged();
        } else if (message instanceof FileMessage) {
            FileInfo info = PendingMessageRepository.getInstance().getFileInfo(message);
            Logger.d("++ file info=%s", info);
            FileMessage pendingMessage = this.channel.resendMessage((FileMessage)message, info.getFile(), (message1, e1) -> {
                if (e1 != null) {
                    Logger.e(e1);
                    this.provider.toastError(R.string.sb_text_error_resend_message);
                    PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)message1);
                    this.notifyDataSetChanged();
                    return;
                }
                Logger.i("__ resent file message : %s", message1);
                this.messageCollection.add((BaseMessage)message1);
                PendingMessageRepository.getInstance().removePendingMessage(channelUrl, (BaseMessage)message1);
                this.notifyDataSetChanged();
            });
            PendingMessageRepository.getInstance().updatePendingMessage(channelUrl, (BaseMessage)pendingMessage);
            this.notifyDataSetChanged();
        }
    }

    public void updateUserMessage(long messageId, @NonNull UserMessageParams params) {
        this.channel.updateUserMessage(messageId, params, (message, e) -> {
            if (e != null) {
                this.provider.toastError(R.string.sb_text_error_update_user_message);
                return;
            }
            Logger.i("++ updated message : %s", message);
            this.messageCollection.update((BaseMessage)message);
            this.notifyDataSetChanged();
        });
    }

    public void deleteMessage(@NonNull BaseMessage message) {
        if (message.getSendingStatus() == BaseMessage.SendingStatus.SUCCEEDED) {
            this.channel.deleteMessage(message, e -> {
                if (e != null) {
                    this.provider.toastError(R.string.sb_text_error_delete_message);
                    return;
                }
                Logger.i("++ deleted message : %s", message);
                this.messageCollection.remove(message);
                this.notifyDataSetChanged();
            });
        } else {
            PendingMessageRepository.getInstance().removePendingMessage(message.getChannelUrl(), message);
            this.notifyDataSetChanged();
        }
    }
}

