/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.sendbird.uikit.activities.adapter.BaseAdapter;
import com.sendbird.uikit.activities.viewholder.BaseViewHolder;
import com.sendbird.uikit.databinding.SbViewUserPreviewBinding;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.interfaces.OnUserSelectChangedListener;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UserListAdapter
extends BaseAdapter<UserInfo, BaseViewHolder<UserInfo>> {
    private List<UserInfo> userList;
    private List<String> disabledUserList;
    private List<String> selectedUserList = new ArrayList<String>();
    private OnItemClickListener<UserInfo> listener;
    private OnItemLongClickListener<UserInfo> longClickListener;
    private OnUserSelectChangedListener userSelectChangedListener;

    public UserListAdapter() {
        this.setHasStableIds(true);
    }

    public UserListAdapter(OnItemClickListener<UserInfo> listener) {
        this.setHasStableIds(true);
        this.listener = listener;
    }

    @NonNull
    public BaseViewHolder<UserInfo> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new UserPreviewHolder(SbViewUserPreviewBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false));
    }

    public void onBindViewHolder(@NonNull BaseViewHolder<UserInfo> holder, int position) {
        UserInfo userInfo = this.getItem(position);
        holder.bind(userInfo);
    }

    @Override
    public UserInfo getItem(int position) {
        return this.userList.get(position);
    }

    @Override
    public List<UserInfo> getItems() {
        return this.userList != null ? Collections.unmodifiableList(this.userList) : null;
    }

    public int getItemCount() {
        return this.userList == null ? 0 : this.userList.size();
    }

    public long getItemId(int position) {
        return this.getItem(position).hashCode();
    }

    public void setItems(List<UserInfo> userList) {
        this.userList = userList;
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(@Nullable OnItemClickListener<UserInfo> listener) {
        this.listener = listener;
    }

    public void setOnItemLongClickListener(@Nullable OnItemLongClickListener<UserInfo> listener) {
        this.longClickListener = listener;
    }

    public void setOnUserSelectChangedListener(OnUserSelectChangedListener userSelectChangedListener) {
        this.userSelectChangedListener = userSelectChangedListener;
    }

    public void setDisabledUserList(List<String> disabledUserList) {
        this.disabledUserList = disabledUserList;
    }

    protected boolean isDisabled(UserInfo userInfo) {
        return this.disabledUserList != null && this.disabledUserList.contains(userInfo.getUserId());
    }

    public List<String> getSelectedUserList() {
        return this.selectedUserList;
    }

    private boolean isSelected(String userId) {
        return this.selectedUserList.contains(userId);
    }

    private class UserPreviewHolder
    extends BaseViewHolder<UserInfo> {
        private SbViewUserPreviewBinding binding;

        UserPreviewHolder(SbViewUserPreviewBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
            binding.userViewHolder.setOnClickListener(v -> {
                int userPosition = this.getAdapterPosition();
                if (userPosition != -1) {
                    UserInfo userInfo = UserListAdapter.this.getItem(userPosition);
                    boolean isSelected = UserListAdapter.this.isSelected(userInfo.getUserId());
                    Logger.d("++ isSelected : %s, userName : %s", isSelected, userInfo.getNickname());
                    if (!isSelected) {
                        UserListAdapter.this.selectedUserList.add(userInfo.getUserId());
                    } else {
                        UserListAdapter.this.selectedUserList.remove(userInfo.getUserId());
                    }
                    if (UserListAdapter.this.listener != null) {
                        UserListAdapter.this.listener.onItemClick(v, userPosition, userInfo);
                    }
                }
            });
            binding.userViewHolder.setOnLongClickListener(v -> {
                int userPosition = this.getAdapterPosition();
                if (userPosition != -1 && UserListAdapter.this.longClickListener != null) {
                    UserListAdapter.this.longClickListener.onItemLongClick(v, userPosition, UserListAdapter.this.getItem(userPosition));
                    return true;
                }
                return false;
            });
            binding.userViewHolder.setOnSelectedStateChangedListener((buttonView, isSelected) -> {
                int userPosition = this.getAdapterPosition();
                if (userPosition != -1 && UserListAdapter.this.userSelectChangedListener != null) {
                    UserListAdapter.this.userSelectChangedListener.onUserSelectChanged(UserListAdapter.this.selectedUserList, !isSelected);
                }
            });
        }

        @Override
        public void bind(UserInfo userInfo) {
            if (userInfo == null) {
                return;
            }
            this.binding.setUserInfo(userInfo);
            this.binding.setEnabled(!UserListAdapter.this.isDisabled(userInfo));
            this.binding.setSelected(UserListAdapter.this.isSelected(userInfo.getUserId()) || UserListAdapter.this.isDisabled(userInfo));
            this.binding.executePendingBindings();
        }
    }
}

