/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.sendbird.uikit.widgets.ThemeableRecyclerView;
import java.util.concurrent.atomic.AtomicBoolean;

public class PagerRecyclerView
extends ThemeableRecyclerView {
    private AtomicBoolean refreshing = new AtomicBoolean(false);
    private SnappableScrollListener snappableScrollListener;
    private LayoutManagerWrapper layoutManagerWrapper;
    private int threshold = 1;

    public PagerRecyclerView(Context context) {
        super(context);
    }

    public PagerRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PagerRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setLayoutManager(@Nullable RecyclerView.LayoutManager layout2) {
        this.layoutManagerWrapper = layout2 == null ? null : new LayoutManagerWrapper(layout2);
        super.setLayoutManager(layout2);
    }

    public boolean performClick() {
        return super.performClick();
    }

    @Nullable
    public RecyclerView.LayoutManager getLayoutManager() {
        return this.layoutManagerWrapper.layoutManager;
    }

    public void setOnScrollEndedEventListener(OnScrollEndedEventListener listener) {
        if (this.snappableScrollListener != null) {
            this.snappableScrollListener.setOnScrollEndedEventListener(listener);
        }
    }

    public int findFirstVisibleItemPosition() {
        return this.layoutManagerWrapper.findFirstVisibleItemPosition();
    }

    public int findLastVisibleItemPosition() {
        return this.layoutManagerWrapper.findLastVisibleItemPosition();
    }

    public void setPager(Pageable pager) {
        if (pager != null) {
            this.snappableScrollListener = new SnappableScrollListener(pager);
            this.snappableScrollListener.setThreshold(this.threshold);
            this.addOnScrollListener(this.snappableScrollListener);
        } else if (this.snappableScrollListener != null) {
            this.removeOnScrollListener(this.snappableScrollListener);
            this.snappableScrollListener = null;
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
        if (this.snappableScrollListener != null) {
            this.snappableScrollListener.setThreshold(threshold);
        }
    }

    public void setRefreshing(boolean refreshing) {
        this.refreshing.set(refreshing);
    }

    public boolean isRefreshing() {
        return this.refreshing.get();
    }

    public static interface OnScrollEndedEventListener {
        public void onScrollEnded();
    }

    public static interface Pageable {
        public boolean hasMore();

        public void loadMore();
    }

    private final class SnappableScrollListener
    extends RecyclerView.OnScrollListener {
        private final Pageable pager;
        private int threshold = 1;
        private OnScrollEndedEventListener scrollEndedListener;

        public SnappableScrollListener(Pageable pager) {
            if (pager == null) {
                throw new NullPointerException("pager is null");
            }
            this.pager = pager;
        }

        void setOnScrollEndedEventListener(OnScrollEndedEventListener listener) {
            this.scrollEndedListener = listener;
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            int lastVisibleItemPosition = PagerRecyclerView.this.layoutManagerWrapper.findLastVisibleItemPosition();
            int firstVisibleItemPosition = PagerRecyclerView.this.layoutManagerWrapper.findFirstVisibleItemPosition();
            int lastItemPosition = PagerRecyclerView.this.getAdapter().getItemCount();
            if (firstVisibleItemPosition == 0 && this.scrollEndedListener != null) {
                this.scrollEndedListener.onScrollEnded();
            }
            if (!PagerRecyclerView.this.isRefreshing() && this.pager.hasMore() && lastItemPosition - lastVisibleItemPosition <= this.threshold) {
                PagerRecyclerView.this.setRefreshing(true);
                this.pager.loadMore();
            }
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        }

        public void setThreshold(int threshold) {
            if (threshold <= 0) {
                throw new IllegalArgumentException("illegal threshold: " + threshold);
            }
            this.threshold = threshold;
        }
    }

    private static final class LayoutManagerWrapper {
        @NonNull
        final RecyclerView.LayoutManager layoutManager;
        @NonNull
        private final LayoutManagerResolver resolver;

        public LayoutManagerWrapper(@NonNull RecyclerView.LayoutManager layoutManager) {
            this.layoutManager = layoutManager;
            this.resolver = LayoutManagerWrapper.getResolver(layoutManager);
        }

        @NonNull
        private static LayoutManagerResolver getResolver(@NonNull RecyclerView.LayoutManager layoutManager) {
            if (layoutManager instanceof LinearLayoutManager) {
                return new LayoutManagerResolver(){

                    @Override
                    public int findLastVisibleItemPosition(@NonNull RecyclerView.LayoutManager layoutManager) {
                        return ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                    }

                    @Override
                    public int findFirstVisibleItemPosition(@NonNull RecyclerView.LayoutManager layoutManager) {
                        return ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
                    }

                    @Override
                    public View findViewByPosition(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull int position) {
                        return ((LinearLayoutManager)layoutManager).findViewByPosition(position);
                    }
                };
            }
            if (layoutManager instanceof StaggeredGridLayoutManager) {
                return new LayoutManagerResolver(){

                    @Override
                    public int findLastVisibleItemPosition(@NonNull RecyclerView.LayoutManager layoutManager) {
                        int[] lastVisibleItemPositions = ((StaggeredGridLayoutManager)layoutManager).findLastVisibleItemPositions(null);
                        int lastVisibleItemPosition = lastVisibleItemPositions[0];
                        for (int i = 1; i < lastVisibleItemPositions.length; ++i) {
                            if (lastVisibleItemPosition >= lastVisibleItemPositions[i]) continue;
                            lastVisibleItemPosition = lastVisibleItemPositions[i];
                        }
                        return lastVisibleItemPosition;
                    }

                    @Override
                    public int findFirstVisibleItemPosition(@NonNull RecyclerView.LayoutManager layoutManager) {
                        int[] firstVisibleItemPositions = ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(null);
                        int firstVisibleItemPosition = firstVisibleItemPositions[0];
                        for (int i = 1; i < firstVisibleItemPositions.length; ++i) {
                            if (firstVisibleItemPosition <= firstVisibleItemPositions[i]) continue;
                            firstVisibleItemPosition = firstVisibleItemPositions[i];
                        }
                        return firstVisibleItemPosition;
                    }

                    @Override
                    public View findViewByPosition(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull int position) {
                        return null;
                    }
                };
            }
            throw new IllegalArgumentException("unsupported layout manager: " + layoutManager);
        }

        public int findLastVisibleItemPosition() {
            return this.resolver.findLastVisibleItemPosition(this.layoutManager);
        }

        public int findFirstVisibleItemPosition() {
            return this.resolver.findFirstVisibleItemPosition(this.layoutManager);
        }

        public View findViewByPosition(int position) {
            return this.resolver.findViewByPosition(this.layoutManager, position);
        }

        private static interface LayoutManagerResolver {
            public int findLastVisibleItemPosition(@NonNull RecyclerView.LayoutManager var1);

            public int findFirstVisibleItemPosition(@NonNull RecyclerView.LayoutManager var1);

            public View findViewByPosition(@NonNull RecyclerView.LayoutManager var1, @NonNull int var2);
        }
    }
}

