/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.consts.MessageGroupType;
import com.sendbird.uikit.databinding.SbViewOpenChannelFileVideoMessageComponentBinding;
import com.sendbird.uikit.utils.DateUtils;
import com.sendbird.uikit.utils.ViewUtils;
import com.sendbird.uikit.widgets.OpenChannelMessageView;

public class OpenChannelVideoFileMessageView
extends OpenChannelMessageView {
    private SbViewOpenChannelFileVideoMessageComponentBinding binding;
    private int nicknameAppearance;
    private int operatorAppearance;
    private int marginLeftEmpty;
    private int marginLeftNor;

    @Override
    public SbViewOpenChannelFileVideoMessageComponentBinding getBinding() {
        return this.binding;
    }

    @Override
    public View getLayout() {
        return this.binding.getRoot();
    }

    public OpenChannelVideoFileMessageView(Context context) {
        this(context, null);
    }

    public OpenChannelVideoFileMessageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_open_channel_message_file_style);
    }

    public OpenChannelVideoFileMessageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageView, defStyle, 0);
        try {
            this.binding = (SbViewOpenChannelFileVideoMessageComponentBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_open_channel_file_video_message_component, (ViewGroup)this, (boolean)true);
            int timeAppearance = a.getResourceId(R.styleable.MessageView_sb_message_time_text_appearance, R.style.SendbirdCaption3OnLight03);
            int contentBackground = a.getResourceId(R.styleable.MessageView_sb_message_background, R.drawable.selector_open_channel_message_bg_light);
            this.nicknameAppearance = a.getResourceId(R.styleable.MessageView_sb_message_sender_name_text_appearance, R.style.SendbirdCaption1OnLight02);
            this.operatorAppearance = a.getResourceId(R.styleable.MessageView_sb_message_operator_name_text_appearance, R.style.SendbirdCaption1Secondary300);
            this.binding.tvSentAt.setTextAppearance(context, timeAppearance);
            this.binding.tvNickname.setTextAppearance(context, this.nicknameAppearance);
            this.binding.contentPanel.setBackgroundResource(contentBackground);
            int bg = SendBirdUIKit.isDarkMode() ? R.drawable.sb_shape_image_message_background_dark : R.drawable.sb_shape_image_message_background;
            this.binding.ivThumbnail.setBackgroundResource(bg);
            this.marginLeftEmpty = this.getResources().getDimensionPixelSize(R.dimen.sb_size_40);
            this.marginLeftNor = this.getResources().getDimensionPixelSize(R.dimen.sb_size_12);
        }
        finally {
            a.recycle();
        }
    }

    @Override
    public void drawMessage(OpenChannel channel, BaseMessage message, MessageGroupType messageGroupType) {
        FileMessage fileMessage = (FileMessage)message;
        this.binding.ivThumbnail.setRadius(this.getResources().getDimensionPixelSize(R.dimen.sb_size_8));
        ViewUtils.drawThumbnail(this.binding.ivThumbnail, fileMessage);
        ViewUtils.drawThumbnailIcon((ImageView)this.binding.ivThumbnailOveray, fileMessage);
        this.binding.ivStatus.drawStatus(message, (BaseChannel)channel);
        if (channel.isOperator((User)message.getSender())) {
            this.binding.tvNickname.setTextAppearance(this.getContext(), this.operatorAppearance);
        } else {
            this.binding.tvNickname.setTextAppearance(this.getContext(), this.nicknameAppearance);
        }
        if (messageGroupType == MessageGroupType.GROUPING_TYPE_SINGLE || messageGroupType == MessageGroupType.GROUPING_TYPE_HEAD) {
            this.binding.ivProfileView.setVisibility(0);
            this.binding.tvNickname.setVisibility(0);
            this.binding.tvSentAt.setVisibility(0);
            this.binding.tvSentAt.setText((CharSequence)DateUtils.formatTime(this.getContext(), message.getCreatedAt()));
            ViewUtils.drawNickname((TextView)this.binding.tvNickname, message);
            ViewUtils.drawProfile((ImageView)this.binding.ivProfileView, message);
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.binding.contentPanel.getLayoutParams();
            params.leftMargin = this.marginLeftNor;
            this.binding.contentPanel.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            this.binding.ivProfileView.setVisibility(8);
            this.binding.tvNickname.setVisibility(8);
            this.binding.tvSentAt.setVisibility(8);
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.binding.contentPanel.getLayoutParams();
            params.leftMargin = this.marginLeftEmpty;
            this.binding.contentPanel.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }
}

