/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.utils.TextUtils;
import com.sendbird.uikit.widgets.ImageWaffleView;
import java.util.List;

public class ChannelCoverView
extends ImageWaffleView {
    private int defaultImageResId;

    public ChannelCoverView(Context context) {
        super(context);
    }

    public ChannelCoverView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ChannelCoverView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setDefaultImageResId(int defaultImageResId) {
        this.defaultImageResId = defaultImageResId;
    }

    public void loadImage(String url) {
        ImageView imageView = this.prepareSingleImageView();
        if (imageView != null) {
            this.drawImageFromUrl(imageView, url);
        }
    }

    public void loadImages(@NonNull List<String> imageUrlList) {
        if (imageUrlList.size() <= 0) {
            this.drawImage(this.prepareSingleImageView(), this.getDefaultResId());
            return;
        }
        List<ImageView> profileIamges = this.prepareImageViews(imageUrlList.size());
        int size = Math.min(4, imageUrlList.size());
        for (int i = 0; i < size; ++i) {
            ImageView imageView = profileIamges.get(i);
            String url = imageUrlList.get(i);
            this.drawImageFromUrl(imageView, url);
        }
    }

    private void drawImageFromUrl(@NonNull ImageView imageView, @NonNull String url) {
        if (TextUtils.isEmpty(url)) {
            this.drawImage(imageView, this.getDefaultResId());
            return;
        }
        int overrideSize = this.getResources().getDimensionPixelSize(R.dimen.sb_size_64);
        ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)imageView.getContext()).load(url).override(overrideSize, overrideSize)).centerCrop()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(this.getDefaultResId())).into(imageView);
    }

    private int getDefaultResId() {
        return this.defaultImageResId > 0 ? this.defaultImageResId : (SendBirdUIKit.isDarkMode() ? R.drawable.icon_avatar_dark : R.drawable.icon_avatar_light);
    }

    private void drawImage(@NonNull ImageView imageView, @DrawableRes int resId) {
        imageView.setImageResource(resId);
    }

    public void drawBroadcastChannelCover() {
        ImageView imageView = this.prepareSingleImageView();
        imageView.setImageResource(SendBirdUIKit.isDarkMode() ? R.drawable.icon_avatar_broadcast_dark : R.drawable.icon_avatar_broadcast_light);
    }
}

