/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import androidx.annotation.NonNull;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.MessageChangeLogsParams;
import com.sendbird.android.MessageListParams;
import com.sendbird.android.SendBirdException;
import com.sendbird.uikit.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

class MessageChangeLogsPager {
    private final BaseChannel channel;
    private final long lastSyncAt;
    private final MessageChangeLogsParams params;
    private final MessageListParams messageListParams;

    MessageChangeLogsPager(@NonNull BaseChannel channel, long lastSyncAt, @NonNull MessageListParams params) {
        this.channel = channel;
        this.lastSyncAt = lastSyncAt;
        this.params = MessageChangeLogsParams.from((MessageListParams)params);
        this.messageListParams = params.clone();
        this.messageListParams.setPreviousResultSize(0);
        this.messageListParams.setNextResultSize(100);
    }

    void load(MessageChangeLogsResultHandler handler) {
        Executors.newSingleThreadExecutor().execute(() -> {
            block7: {
                ArrayList<BaseMessage> updatedMessageList = new ArrayList<BaseMessage>();
                ArrayList<BaseMessage> addedMessageList = new ArrayList<BaseMessage>();
                ArrayList<Long> deletedMessageIdList = new ArrayList<Long>();
                CountDownLatch lock = new CountDownLatch(1);
                AtomicReference tokenRef = new AtomicReference();
                AtomicBoolean hasMoreRef = new AtomicBoolean();
                try {
                    List<BaseMessage> list;
                    boolean hasMore2;
                    if (this.channel instanceof GroupChannel) {
                        this.load(this.lastSyncAt, this.params, (updated, deletedMessageIds, hasMore, token, e) -> {
                            if (e != null) {
                                if (handler != null) {
                                    handler.onError(e);
                                }
                                return;
                            }
                            tokenRef.set(token);
                            hasMoreRef.set(hasMore);
                            updatedMessageList.addAll(updated);
                            deletedMessageIdList.addAll(deletedMessageIds);
                            lock.countDown();
                        });
                        lock.await();
                        while (hasMoreRef.get()) {
                            CountDownLatch moreLock = new CountDownLatch(1);
                            this.more((String)tokenRef.get(), this.params, (updated, deletedMessageIds, hasMore, token, e) -> {
                                if (e != null) {
                                    if (handler != null) {
                                        handler.onError(e);
                                    }
                                    return;
                                }
                                tokenRef.set(token);
                                hasMoreRef.set(hasMore);
                                updatedMessageList.addAll(updated);
                                deletedMessageIdList.addAll(deletedMessageIds);
                                moreLock.countDown();
                            });
                            moreLock.await();
                        }
                    }
                    long timeStamp = this.lastSyncAt;
                    do {
                        int totalSize;
                        if ((totalSize = addedMessageList.size()) > 0) {
                            timeStamp = ((BaseMessage)addedMessageList.get(0)).getCreatedAt();
                        }
                        list = this.loadAddedMessageFromTimestamp(timeStamp);
                        addedMessageList.addAll(0, list);
                    } while (hasMore2 = list.size() > 0);
                    if (handler != null) {
                        handler.onResult(addedMessageList, updatedMessageList, deletedMessageIdList);
                    }
                }
                catch (Exception e2) {
                    Logger.e(e2);
                    if (handler == null) break block7;
                    handler.onError(new SendBirdException(e2.getMessage(), 800220));
                }
            }
        });
    }

    private void load(long ts, MessageChangeLogsParams params, BaseChannel.GetMessageChangeLogsHandler handler) {
        this.channel.getMessageChangeLogsSinceTimestamp(ts, params, handler);
    }

    private void more(String token, MessageChangeLogsParams params, BaseChannel.GetMessageChangeLogsByTokenHandler handler) {
        this.channel.getMessageChangeLogsSinceToken(token, params, (BaseChannel.GetMessageChangeLogsHandler)handler);
    }

    private List<BaseMessage> loadAddedMessageFromTimestamp(long ts) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        this.channel.getMessagesByTimestamp(ts, this.messageListParams, (messages, e) -> {
            try {
                if (e != null) {
                    error.set(e);
                    return;
                }
                result.set(messages);
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
        if (error.get() != null) {
            throw (Exception)error.get();
        }
        return (List)result.get();
    }

    static interface MessageChangeLogsResultHandler {
        public void onError(SendBirdException var1);

        public void onResult(List<BaseMessage> var1, List<BaseMessage> var2, List<Long> var3);
    }
}

