/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import androidx.annotation.NonNull;

public class SoftInputUtils {
    public static void hideSoftKeyboard(View view) {
        if (view == null) {
            return;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public static void showSoftKeyboard(EditText editText) {
        if (editText == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)editText.getContext().getSystemService("input_method");
        editText.postDelayed(() -> {
            editText.requestFocus();
            if (imm != null) {
                imm.showSoftInput((View)editText, 0);
            }
        }, 100L);
    }

    public static void setSoftInputMode(@NonNull Context context, int mode) {
        try {
            ((Activity)context).getWindow().setSoftInputMode(mode);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getSoftInputMode(@NonNull Context context) {
        try {
            return ((Activity)context).getWindow().getAttributes().softInputMode;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }
}

