/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.ContextCompat;
import androidx.databinding.DataBindingUtil;
import androidx.fragment.app.Fragment;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.github.chrisbanes.photoview.PhotoView;
import com.github.chrisbanes.photoview.PhotoViewAttacher;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbFragmentPhotoViewBinding;
import com.sendbird.uikit.fragments.BaseFragment;
import com.sendbird.uikit.fragments.PermissionFragment;
import com.sendbird.uikit.interfaces.LoadingDialogHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.tasks.JobResultTask;
import com.sendbird.uikit.tasks.TaskQueue;
import com.sendbird.uikit.utils.DateUtils;
import com.sendbird.uikit.utils.DialogUtils;
import com.sendbird.uikit.utils.MessageUtils;
import com.sendbird.uikit.vm.FileDownloader;
import com.sendbird.uikit.widgets.ProgressView;
import java.io.File;
import java.io.Serializable;

public class PhotoViewFragment
extends BaseFragment
implements PermissionFragment.IPermissionHandler,
LoadingDialogHandler {
    private final String[] REQUIRED_PERMISSIONS = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    private SbFragmentPhotoViewBinding binding;
    private BaseChannel channel;
    private boolean loadComplete = false;
    private String senderId;
    private String fileName;
    private String channelUrl;
    private String url;
    private String mimeType;
    private String senderNickname;
    private long createdAt;
    private long messageId;
    private BaseChannel.ChannelType channelType = BaseChannel.ChannelType.GROUP;
    private LoadingDialogHandler loadingDialogHandler;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentPhotoViewBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_photo_view, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.binding.ivClose.setOnClickListener(v -> this.finish());
        if (Build.VERSION.SDK_INT >= 21) {
            this.getActivity().getWindow().setNavigationBarColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.background_700));
        }
        if (Build.VERSION.SDK_INT >= 19) {
            this.getActivity().getWindow().getDecorView().setSystemUiVisibility(5381);
        }
    }

    @Override
    public void onReady(User user, ReadyStatus status) {
        this.onConfigure();
        if (this.channelType == BaseChannel.ChannelType.GROUP) {
            GroupChannel.getChannel((String)this.channelUrl, (channel, e) -> {
                this.channel = channel;
                this.onDrawPage();
            });
        } else {
            OpenChannel.getChannel((String)this.channelUrl, (channel, e) -> {
                this.channel = channel;
                this.onDrawPage();
            });
        }
    }

    protected void onConfigure() {
        Bundle args = this.getArguments();
        if (args != null) {
            this.senderId = args.getString("KEY_SENDER_ID");
            this.fileName = args.getString("KEY_MESSAGE_FILENAME");
            this.channelUrl = args.getString("KEY_CHANNEL_URL");
            this.url = args.getString("KEY_IMAGE_URL");
            this.mimeType = args.getString("KEY_MESSAGE_MIMETYPE");
            this.senderNickname = args.getString("KEY_MESSAGE_SENDER_NAME");
            this.createdAt = args.getLong("KEY_MESSAGE_CREATEDAT");
            this.messageId = args.getLong("KEY_MESSAGE_ID");
            if (args.containsKey("KEY_CHANNEL_TYPE")) {
                this.channelType = (BaseChannel.ChannelType)args.getSerializable("KEY_CHANNEL_TYPE");
            }
        }
        if (this.loadingDialogHandler == null) {
            this.loadingDialogHandler = this;
        }
    }

    private <T> RequestBuilder<T> makeRequestBuilder(@NonNull String url, @NonNull Class<T> clazz) {
        ProgressView loading = this.binding.loading;
        RequestManager glide = Glide.with((Fragment)this);
        return ((RequestBuilder)glide.as(clazz).diskCacheStrategy(DiskCacheStrategy.ALL)).load(url).thumbnail(0.5f).listener(new RequestListener<T>((View)loading){
            final /* synthetic */ View val$loading;
            {
                this.val$loading = view;
            }

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<T> target, boolean isFirstResource) {
                if (!PhotoViewFragment.this.isActive()) {
                    return false;
                }
                PhotoViewFragment.this.getActivity().runOnUiThread(() -> this.val$loading.setVisibility(8));
                return false;
            }

            public boolean onResourceReady(T resource, Object model, Target<T> target, DataSource dataSource, boolean isFirstResource) {
                if (!PhotoViewFragment.this.isActive()) {
                    return false;
                }
                PhotoViewFragment.this.getActivity().runOnUiThread(() -> {
                    PhotoViewFragment.this.loadComplete = true;
                    this.val$loading.setVisibility(8);
                });
                return false;
            }
        });
    }

    protected void onDrawPage() {
        PhotoView ivPhoto = this.binding.ivPhoto;
        AppCompatImageView ivDelete = this.binding.ivDelete;
        AppCompatImageView ivDownload = this.binding.ivDownload;
        TextView tvTitle = this.binding.tvTitle;
        TextView tvCreatedAt = this.binding.tvCreatedAt;
        ProgressView loading = this.binding.loading;
        String url = this.url;
        tvTitle.setText((CharSequence)this.senderNickname);
        tvCreatedAt.setText((CharSequence)DateUtils.formatTime(this.getContext(), this.createdAt));
        loading.setVisibility(0);
        if (this.mimeType.toLowerCase().contains("gif")) {
            this.makeRequestBuilder(url, GifDrawable.class).into((ImageView)ivPhoto);
        } else {
            this.makeRequestBuilder(url, Bitmap.class).into((ImageView)ivPhoto);
        }
        if (this.channel != null && MessageUtils.isMine(this.senderId)) {
            ivDelete.setVisibility(0);
            ivDelete.setOnClickListener(v -> {
                if (!this.loadComplete || this.getContext() == null || this.getFragmentManager() == null) {
                    return;
                }
                DialogUtils.buildWarning(this.getString(R.string.sb_text_dialog_delete_file_message), (int)this.getResources().getDimension(R.dimen.sb_dialog_width_280), this.getString(R.string.sb_text_button_delete), v1 -> this.channel.deleteMessage(this.createDummyMessage(), e -> {
                    if (this.isActive()) {
                        this.finish();
                    }
                }), this.getString(R.string.sb_text_button_cancel), cancel -> Logger.dev("cancel")).showSingle(this.getFragmentManager());
            });
        } else {
            ivDelete.setVisibility(8);
            ivDelete.setOnClickListener(null);
        }
        ivDownload.setOnClickListener(v -> {
            if (!this.loadComplete) {
                return;
            }
            this.checkPermission(0, this);
        });
        PhotoViewAttacher attacher = new PhotoViewAttacher((ImageView)ivPhoto);
        attacher.setOnPhotoTapListener((view, x, y) -> this.togglePhotoActionBar());
    }

    private void togglePhotoActionBar() {
        FrameLayout vgHeader = this.binding.vgHeader;
        RelativeLayout vgBottom = this.binding.vgBottom;
        if (vgHeader.getVisibility() == 8) {
            vgHeader.animate().setDuration(300L).alpha(1.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter((View)vgHeader){
                final /* synthetic */ View val$vgHeader;
                {
                    this.val$vgHeader = view;
                }

                public void onAnimationStart(Animator animation) {
                    super.onAnimationStart(animation);
                    this.val$vgHeader.setVisibility(0);
                }
            });
        } else {
            vgHeader.animate().setDuration(300L).alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter((View)vgHeader){
                final /* synthetic */ View val$vgHeader;
                {
                    this.val$vgHeader = view;
                }

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    this.val$vgHeader.setVisibility(8);
                }
            });
        }
        if (vgBottom.getVisibility() == 8) {
            vgBottom.animate().setDuration(300L).alpha(1.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter((View)vgBottom){
                final /* synthetic */ View val$vgBottom;
                {
                    this.val$vgBottom = view;
                }

                public void onAnimationStart(Animator animation) {
                    super.onAnimationStart(animation);
                    this.val$vgBottom.setVisibility(0);
                }
            });
        } else {
            vgBottom.animate().setDuration(300L).alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter((View)vgBottom){
                final /* synthetic */ View val$vgBottom;
                {
                    this.val$vgBottom = view;
                }

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    this.val$vgBottom.setVisibility(8);
                }
            });
        }
    }

    @Override
    public String[] getPermissions(int requestCode) {
        return this.REQUIRED_PERMISSIONS;
    }

    @Override
    public void onPermissionGranted(int requestCode) {
        this.saveFileFromUrl();
    }

    private void saveFileFromUrl() {
        this.loadingDialogHandler.shouldShowLoadingDialog();
        TaskQueue.addTask(new JobResultTask<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                File newFile = FileDownloader.getInstance().saveFile(PhotoViewFragment.this.getContext(), PhotoViewFragment.this.url, PhotoViewFragment.this.fileName);
                Logger.dev("++ file name : %s, size : %s", newFile.getPath(), newFile.length());
                return true;
            }

            @Override
            public void onResultForUiThread(Boolean result, SendBirdException e) {
                PhotoViewFragment.this.loadingDialogHandler.shouldDismissLoadingDialog();
                if (e != null) {
                    Logger.e((Throwable)e);
                }
                if (result != null && result.booleanValue()) {
                    PhotoViewFragment.this.toastSuccess(R.string.sb_text_toast_success_download_file);
                } else {
                    PhotoViewFragment.this.toastError(R.string.sb_text_error_download_file);
                }
            }
        });
    }

    private void setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
        this.loadingDialogHandler = loadingDialogHandler;
    }

    @Override
    public boolean shouldShowLoadingDialog() {
        this.showWaitingDialog();
        return true;
    }

    @Override
    public void shouldDismissLoadingDialog() {
        this.dismissWaitingDialog();
    }

    private BaseMessage createDummyMessage() {
        return new BaseMessage(this.channelUrl, this.messageId, this.createdAt){

            public String getRequestId() {
                return null;
            }

            public String getMessage() {
                return null;
            }

            public Sender getSender() {
                return null;
            }
        };
    }

    public static class Builder {
        private final Bundle bundle = new Bundle();
        private LoadingDialogHandler loadingDialogHandler;

        public Builder(String senderId, String fileName, String channelUrl, String url, String mimeType, String senderNickname, long createdAt, long messageId, BaseChannel.ChannelType channelType, SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putString("KEY_SENDER_ID", senderId);
            this.bundle.putString("KEY_MESSAGE_FILENAME", fileName);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
            this.bundle.putString("KEY_IMAGE_URL", url);
            this.bundle.putString("KEY_MESSAGE_MIMETYPE", mimeType);
            this.bundle.putString("KEY_MESSAGE_SENDER_NAME", senderNickname);
            this.bundle.putLong("KEY_MESSAGE_CREATEDAT", createdAt);
            this.bundle.putLong("KEY_MESSAGE_ID", messageId);
            this.bundle.putSerializable("KEY_CHANNEL_TYPE", (Serializable)channelType);
        }

        public Builder setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
            this.loadingDialogHandler = loadingDialogHandler;
            return this;
        }

        public PhotoViewFragment build() {
            PhotoViewFragment fragment = new PhotoViewFragment();
            fragment.setArguments(this.bundle);
            fragment.setLoadingDialogHandler(this.loadingDialogHandler);
            return fragment;
        }
    }
}

