/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.sendbird.uikit.R;
import com.sendbird.uikit.utils.ContextUtils;
import com.sendbird.uikit.utils.PermissionUtils;
import java.util.List;
import java.util.Locale;

public abstract class PermissionFragment
extends Fragment {
    private int requestCode;
    private IPermissionHandler handler;
    private final int PERMISSION_SETTINGS_REQUEST_ID = 100;

    void checkPermission(int requestCode, @NonNull IPermissionHandler handler) {
        this.requestCode = requestCode;
        this.handler = handler;
        String[] permissions = handler.getPermissions(requestCode);
        boolean hasPermission = PermissionUtils.hasPermissions(this.getContext(), permissions);
        if (hasPermission) {
            handler.onPermissionGranted(requestCode);
            return;
        }
        this.requestPermissions(permissions, requestCode);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        String[] requested = this.handler.getPermissions(requestCode);
        if (requestCode == this.requestCode && grantResults.length == requested.length) {
            boolean isAllGranted = true;
            for (int result : grantResults) {
                if (result == 0) continue;
                isAllGranted = false;
                break;
            }
            if (isAllGranted) {
                this.handler.onPermissionGranted(requestCode);
            } else {
                String[] notGranted = PermissionUtils.getNotGrantedPermissions(this.getContext(), permissions);
                List<String> deniedList = PermissionUtils.getShowRequestPermissionRationale((Activity)this.getActivity(), permissions);
                if (deniedList != null && deniedList.size() == 0) {
                    Drawable icon = PermissionFragment.getPermissionDrawable((Activity)this.getActivity(), notGranted[0]);
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
                    builder.setTitle((CharSequence)this.getActivity().getString(R.string.sb_text_dialog_permission_title));
                    builder.setMessage((CharSequence)PermissionFragment.getPermissionGuildeMessage((Context)this.getActivity(), notGranted[0]));
                    if (icon != null) {
                        builder.setIcon(icon);
                    }
                    builder.setPositiveButton(R.string.sb_text_go_to_settings, (dialogInterface, i) -> {
                        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                        intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                        intent.addCategory("android.intent.category.DEFAULT");
                        intent.setData(Uri.parse((String)("package:" + this.getActivity().getPackageName())));
                        intent.addFlags(0x40000000);
                        intent.addFlags(0x800000);
                        this.startActivityForResult(intent, 100);
                    });
                    AlertDialog dialog = builder.create();
                    dialog.show();
                    dialog.getButton(-1).setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.secondary_300));
                }
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (resultCode != -1) {
            return;
        }
        if (requestCode == 100 && this.handler != null) {
            String[] permissions = this.handler.getPermissions(this.requestCode);
            boolean hasPermission = PermissionUtils.hasPermissions(this.getContext(), permissions);
            if (hasPermission) {
                this.handler.onPermissionGranted(requestCode);
            }
        }
    }

    private static Drawable getPermissionDrawable(Activity activity, String permission2) {
        Drawable drawable2 = null;
        try {
            PackageManager pm = activity.getPackageManager();
            PermissionInfo permissionInfo = pm.getPermissionInfo(permission2, 0);
            PermissionGroupInfo groupInfo = pm.getPermissionGroupInfo(permissionInfo.group, 0);
            drawable2 = Build.VERSION.SDK_INT >= 21 ? pm.getResourcesForApplication("android").getDrawable(groupInfo.icon, activity.getTheme()) : pm.getResourcesForApplication("android").getDrawable(groupInfo.icon);
        }
        catch (PackageManager.NameNotFoundException | Resources.NotFoundException throwable) {
            // empty catch block
        }
        return drawable2;
    }

    private static String getPermissionGuildeMessage(@NonNull Context context, @NonNull String permission2) {
        int textResId;
        switch (permission2) {
            case "android.permission.CAMERA": {
                textResId = R.string.sb_text_need_to_allow_permission_camera;
                break;
            }
            default: {
                textResId = R.string.sb_text_need_to_allow_permission_storage;
            }
        }
        return String.format(Locale.US, context.getString(textResId), ContextUtils.getApplicationName(context));
    }

    static interface IPermissionHandler {
        public String[] getPermissions(int var1);

        public void onPermissionGranted(int var1);
    }
}

