/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import com.sendbird.android.OpenChannel;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.fragments.BaseFragment;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.utils.TextUtils;

abstract class BaseOpenChannelFragment
extends BaseFragment {
    protected OpenChannel channel;

    BaseOpenChannelFragment() {
    }

    protected abstract void onReadyFailure();

    protected abstract void onConfigure();

    protected abstract void onDrawPage();

    @Override
    public void onReady(User user, ReadyStatus status) {
        Logger.i(">> BaseOpenChannelFragment::onReady(%s)", new Object[]{status});
        Logger.i("++ user : %s", user);
        if (status == ReadyStatus.ERROR) {
            this.onReadyFailure();
            return;
        }
        String channelUrl = this.getStringExtra("KEY_CHANNEL_URL");
        if (!TextUtils.isEmpty(channelUrl)) {
            OpenChannel.getChannel((String)channelUrl, (channel, e) -> {
                if (!this.isActive()) {
                    return;
                }
                if (e != null) {
                    this.toastError(R.string.sb_text_error_get_channel);
                    this.finish();
                    return;
                }
                this.channel = channel;
                this.onConfigure();
                this.onDrawPage();
            });
            return;
        }
        this.onConfigure();
        this.onDrawPage();
    }
}

