/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.consts.CreateableChannelType;
import com.sendbird.uikit.fragments.CreateChannelFragment;
import java.io.Serializable;

public class CreateChannelActivity
extends AppCompatActivity {
    private CreateableChannelType channelType = CreateableChannelType.Normal;

    public static Intent newIntent(@NonNull Context context) {
        return new Intent(context, CreateChannelActivity.class);
    }

    public static Intent newIntent(@NonNull Context context, @NonNull CreateableChannelType type) {
        return CreateChannelActivity.newIntentFromCustomActivity(context, CreateChannelActivity.class, type);
    }

    public static Intent newIntentFromCustomActivity(@NonNull Context context, @NonNull Class<? extends CreateChannelActivity> cls, @NonNull CreateableChannelType type) {
        Intent intent = new Intent(context, cls);
        intent.putExtra("KEY_SELECTED_CHANNEL_TYPE", (Serializable)((Object)type));
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(SendBirdUIKit.isDarkMode() ? R.style.SendBird_Dark : R.style.SendBird);
        this.setContentView(R.layout.sb_activity);
        if (this.getIntent().hasExtra("KEY_SELECTED_CHANNEL_TYPE")) {
            this.channelType = (CreateableChannelType)((Object)this.getIntent().getSerializableExtra("KEY_SELECTED_CHANNEL_TYPE"));
        }
        CreateChannelFragment fragment = this.createCreateChannelFragment();
        FragmentManager manager = this.getSupportFragmentManager();
        manager.popBackStack();
        manager.beginTransaction().replace(R.id.sb_fragment_container, (Fragment)fragment).commit();
    }

    protected CreateChannelFragment createCreateChannelFragment() {
        return this.createCreateChannelFragment(this.channelType);
    }

    protected CreateChannelFragment createCreateChannelFragment(CreateableChannelType type) {
        return new CreateChannelFragment.Builder(type).setUseHeader(true).setHeaderTitle(this.getString(R.string.sb_text_header_create_channel)).setCreateButtonText(this.getString(R.string.sb_text_button_create)).build();
    }
}

