/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.sendbird.uikit.R;
import com.sendbird.uikit.consts.DialogEditTextParams;
import com.sendbird.uikit.fragments.DialogView;
import com.sendbird.uikit.interfaces.OnEditTextResultListener;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.model.DialogListItem;

public class SendBirdDialogFragment
extends DialogFragment {
    private Params params;

    @NonNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        DialogView dialogView = new DialogView((Context)this.getActivity());
        int style2 = R.style.SendBird_Dialog;
        if (this.params != null) {
            dialogView.setContentView(this.params.contentView);
            dialogView.setTitle(this.params.title);
            dialogView.setPositiveButton(this.params.positiveButtonText, v -> {
                this.dismiss();
                if (this.params.positiveButtonClickListener != null) {
                    this.params.positiveButtonClickListener.onClick(v);
                }
            });
            dialogView.setNegativeButton(this.params.negativeButtonText, v -> {
                this.dismiss();
                if (this.params.negativeButtonClickListener != null) {
                    this.params.negativeButtonClickListener.onClick(v);
                }
            });
            dialogView.setNeutralButton(this.params.neutralButtonText, v -> {
                this.dismiss();
                if (this.params.neutralButtonClickListener != null) {
                    this.params.neutralButtonClickListener.onClick(v);
                }
            });
            dialogView.setEditText(this.params.editTextParams, this.params.editTextResultListener);
            dialogView.setItems(this.params.items, (view, position, data) -> {
                this.dismiss();
                if (this.params.itemClickListener != null) {
                    this.params.itemClickListener.onItemClick(view, position, data);
                }
            }, this.params.itemIconGravity == ItemIconGravity.START);
            if (this.params.dialogGravity == DialogGravity.BOTTOM) {
                dialogView.setBackgroundBottom();
            }
            if (this.params.useLegacyWarningButtonsStyle) {
                dialogView.setLegacyWarningButtons((Context)this.getActivity());
            }
            if (this.params.useLegacyButtonsStyle) {
                dialogView.setLegacyButtons((Context)this.getActivity());
            }
            style2 = this.params.dialogGravity == DialogGravity.BOTTOM ? R.style.SendBird_Dialog_Bottom : R.style.SendBird_Dialog;
        } else {
            this.setShowsDialog(false);
            this.dismiss();
        }
        AlertDialog.Builder builder = SendBirdDialogFragment.createDialogBuilder((Context)this.getActivity(), style2);
        builder.setView((View)dialogView);
        return builder.create();
    }

    public int show(@NonNull FragmentTransaction transaction, @Nullable String tag) {
        int res = super.show(transaction, tag);
        if (this.getFragmentManager() != null) {
            this.getFragmentManager().executePendingTransactions();
        }
        this.applyDialogParams();
        return res;
    }

    public void show(@NonNull FragmentManager manager, @Nullable String tag) {
        super.show(manager, tag);
        manager.executePendingTransactions();
        this.applyDialogParams();
    }

    public void showNow(@NonNull FragmentManager manager, @Nullable String tag) {
        super.showNow(manager, tag);
        this.applyDialogParams();
    }

    public void showSingle(@NonNull FragmentManager fragmentManager) {
        FragmentTransaction ft = fragmentManager.beginTransaction();
        Fragment prev = fragmentManager.findFragmentByTag("TAG_SENDBIRD_DIALOG_FRAGMENT");
        if (prev instanceof DialogFragment) {
            ((DialogFragment)prev).dismiss();
            ft.remove(prev);
            ft.commitNow();
        }
        this.showNow(fragmentManager, "TAG_SENDBIRD_DIALOG_FRAGMENT");
    }

    private void applyDialogParams() {
        Dialog dialog = this.getDialog();
        if (dialog != null && dialog.getWindow() != null) {
            if (this.params.dialogGravity == DialogGravity.BOTTOM) {
                dialog.getWindow().setGravity(80);
            } else if (this.params.dialogGravity == DialogGravity.TOP) {
                dialog.getWindow().setGravity(48);
            }
            dialog.getWindow().setLayout(this.params.dialogWidth, this.params.dialogHeight);
        }
    }

    private static AlertDialog.Builder createDialogBuilder(Context context, int defStyleRes) {
        return new AlertDialog.Builder(context, defStyleRes);
    }

    private void setParams(Params params) {
        this.params = params;
    }

    private static class Params {
        private int dialogHeight = -2;
        private int dialogWidth = -1;
        private String title;
        private DialogGravity dialogGravity = DialogGravity.CENTER;
        private DialogListItem[] items;
        private OnItemClickListener<Integer> itemClickListener;
        private ItemIconGravity itemIconGravity;
        private DialogEditTextParams editTextParams;
        private OnEditTextResultListener editTextResultListener;
        private String positiveButtonText;
        private View.OnClickListener positiveButtonClickListener;
        private String negativeButtonText;
        private View.OnClickListener negativeButtonClickListener;
        private String neutralButtonText;
        private View.OnClickListener neutralButtonClickListener;
        private View contentView;
        private boolean useLegacyButtonsStyle;
        private boolean useLegacyWarningButtonsStyle;

        private Params() {
        }

        static /* synthetic */ DialogListItem[] access$702(Params x0, DialogListItem[] x1) {
            x0.items = x1;
            return x1;
        }
    }

    public static class Builder {
        private final Params params = new Params();

        public Builder setDialogWidth(int width) {
            this.params.dialogWidth = width;
            return this;
        }

        public Builder setDialogHeight(int height) {
            this.params.dialogHeight = height;
            return this;
        }

        public Builder setTitle(String title) {
            this.params.title = title;
            return this;
        }

        public Builder setDialogGravity(DialogGravity dialogGravity) {
            this.params.dialogGravity = dialogGravity;
            return this;
        }

        public Builder setItems(DialogListItem[] items, OnItemClickListener<Integer> itemClickListener, ItemIconGravity iconGravity) {
            Params.access$702(this.params, items);
            this.params.itemClickListener = itemClickListener;
            this.params.itemIconGravity = iconGravity;
            return this;
        }

        public Builder setEditText(DialogEditTextParams editTextParams, OnEditTextResultListener editTextResultListener) {
            this.params.editTextParams = editTextParams;
            this.params.editTextResultListener = editTextResultListener;
            return this;
        }

        public Builder setPositiveButton(String text, View.OnClickListener clickListener) {
            this.params.positiveButtonText = text;
            this.params.positiveButtonClickListener = clickListener;
            return this;
        }

        public Builder setNegativeButton(String text, View.OnClickListener clickListener) {
            this.params.negativeButtonText = text;
            this.params.negativeButtonClickListener = clickListener;
            return this;
        }

        public Builder setNeutralButton(String text, View.OnClickListener clickListener) {
            this.params.neutralButtonText = text;
            this.params.neutralButtonClickListener = clickListener;
            return this;
        }

        public Builder setContentView(View view) {
            this.params.contentView = view;
            return this;
        }

        public Builder setUseLegacyButtonsStyle(boolean useLegacyButtonsStyle) {
            this.params.useLegacyButtonsStyle = useLegacyButtonsStyle;
            return this;
        }

        public Builder setUseLegacyWarningButtonsStyle(boolean useLegacyWarningButtonsStyle) {
            this.params.useLegacyWarningButtonsStyle = useLegacyWarningButtonsStyle;
            return this;
        }

        public SendBirdDialogFragment create() {
            SendBirdDialogFragment sendBirdDialogFragment = new SendBirdDialogFragment();
            sendBirdDialogFragment.setParams(this.params);
            return sendBirdDialogFragment;
        }
    }

    public static enum ItemIconGravity {
        START,
        END;

    }

    public static enum DialogGravity {
        CENTER,
        BOTTOM,
        TOP;

    }
}

