/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewMyMessageStatusBinding;
import com.sendbird.uikit.utils.DrawableUtils;

public class MyMessageStatusView
extends FrameLayout {
    private SbViewMyMessageStatusBinding binding;

    public MyMessageStatusView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public MyMessageStatusView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public MyMessageStatusView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.binding = (SbViewMyMessageStatusBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.sb_view_my_message_status, (ViewGroup)this, (boolean)true);
    }

    public void drawError() {
        this.setProgress(false);
        this.binding.ivStatus.setImageDrawable(DrawableUtils.setTintList(this.getContext(), R.drawable.icon_error, R.color.error));
    }

    public void drawRead() {
        this.setProgress(false);
        this.binding.ivStatus.setImageDrawable(DrawableUtils.setTintList(this.getContext(), R.drawable.icon_read, R.color.secondary_300));
    }

    public void drawSent() {
        this.setProgress(false);
        boolean isDark = SendBirdUIKit.isDarkMode();
        this.binding.ivStatus.setImageDrawable(DrawableUtils.setTintList(this.getContext(), R.drawable.icon_sent, isDark ? R.color.ondark_03 : R.color.onlight_03));
    }

    public void drawDelivered() {
        this.setProgress(false);
        boolean isDark = SendBirdUIKit.isDarkMode();
        this.binding.ivStatus.setImageDrawable(DrawableUtils.setTintList(this.getContext(), R.drawable.icon_delivered, isDark ? R.color.ondark_03 : R.color.onlight_03));
    }

    public void drawProgress() {
        this.setProgress(true);
    }

    private void setProgress(boolean isProgress) {
        if (isProgress) {
            this.binding.ivStatus.setVisibility(8);
            this.binding.mpvProgressStatus.setVisibility(0);
        } else {
            this.binding.mpvProgressStatus.setVisibility(8);
            this.binding.ivStatus.setVisibility(0);
        }
    }
}

