/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Member;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.adapter.MemberListAdapter;
import com.sendbird.uikit.databinding.SbFragmentUserTypeListBinding;
import com.sendbird.uikit.fragments.BaseFragment;
import com.sendbird.uikit.fragments.UserProfileDialog;
import com.sendbird.uikit.interfaces.CustomMemberListQueryHandler;
import com.sendbird.uikit.interfaces.LoadingDialogHandler;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.vm.UserTypeListViewModel;
import com.sendbird.uikit.vm.ViewModelFactory;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.List;

public abstract class MemberTypeListFragment
extends BaseFragment
implements LoadingDialogHandler {
    private SbFragmentUserTypeListBinding binding;
    protected View.OnClickListener headerLeftButtonListener;
    protected View.OnClickListener headerRightButtonListener;
    protected MemberListAdapter adapter;
    protected OnItemClickListener<Member> itemClickListener;
    protected OnItemLongClickListener<Member> itemLongClickListener;
    protected OnItemClickListener<Member> actionItemClickListener;
    protected CustomMemberListQueryHandler<Member> customQueryHandler;
    protected OnItemClickListener<Member> profileClickListener;
    protected LoadingDialogHandler loadingDialogHandler;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> MemberTypeListFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID");
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentUserTypeListBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_user_type_list, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
        this.initHeaderOnCreated();
    }

    @Override
    public void onReady(User user, ReadyStatus status) {
        Logger.i(">> MemberTypeListFragment::onReady()", new Object[0]);
        if (status == ReadyStatus.ERROR || !this.hasChannelUrl()) {
            this.setErrorFrame();
            return;
        }
        this.onConfigure();
        this.onDrawPage();
    }

    protected void onConfigure() {
        if (this.loadingDialogHandler == null) {
            this.loadingDialogHandler = this;
        }
    }

    protected void onDrawPage() {
        this.initHeaderOnReady();
        this.initMemberList(this.channel);
    }

    protected void setErrorFrame() {
        this.binding.statusFrame.setStatus(StatusFrameView.Status.CONNECTION_ERROR);
        this.binding.statusFrame.setOnActionEventListener(v -> {
            this.binding.statusFrame.setStatus(StatusFrameView.Status.LOADING);
            this.connect();
        });
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        String headerTitle = this.getString(R.string.sb_text_header_member_list);
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        boolean useHeaderRightButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        int headerRightButtonIconResId = R.drawable.icon_plus;
        int emptyIconId = R.drawable.icon_chat;
        int emptyTextId = R.string.sb_text_user_list_empty;
        if (args != null) {
            headerTitle = args.getString("KEY_HEADER_TITLE", headerTitle);
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            useHeaderRightButton = args.getBoolean("KEY_USE_HEADER_RIGHT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
            headerRightButtonIconResId = args.getInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", R.drawable.icon_plus);
            emptyIconId = args.getInt("KEY_EMPTY_ICON_RES_ID", R.drawable.icon_chat);
            emptyTextId = args.getInt("KEY_EMPTY_TEXT_RES_ID", R.string.sb_text_user_list_empty);
        }
        this.binding.abvMemberList.setVisibility(useHeader ? 0 : 8);
        this.binding.abvMemberList.getTitleTextView().setText((CharSequence)headerTitle);
        this.binding.abvMemberList.setUseLeftImageButton(useHeaderLeftButton);
        this.binding.abvMemberList.getRightImageButton().setVisibility(useHeaderRightButton ? 0 : 8);
        this.binding.abvMemberList.getLeftImageButton().setImageResource(headerLeftButtonIconResId);
        this.binding.abvMemberList.getRightImageButton().setImageResource(headerRightButtonIconResId);
        this.binding.abvMemberList.getLeftImageButton().setOnClickListener(v -> this.finish());
        this.binding.statusFrame.setEmptyIcon(emptyIconId);
        this.binding.statusFrame.setEmptyText(emptyTextId);
    }

    private void initHeaderOnReady() {
        if (this.headerLeftButtonListener != null) {
            this.binding.abvMemberList.getLeftImageButton().setOnClickListener(this.headerLeftButtonListener);
        }
        if (this.headerRightButtonListener != null) {
            this.binding.abvMemberList.getRightImageButton().setOnClickListener(this.headerRightButtonListener);
        }
    }

    private void initMemberList(@NonNull GroupChannel channel) {
        Bundle args;
        UserTypeListViewModel viewModel = (UserTypeListViewModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new ViewModelFactory(this, channel, this.customQueryHandler)).get(UserTypeListViewModel.class);
        this.getLifecycle().addObserver((LifecycleObserver)viewModel);
        if (this.adapter == null) {
            this.adapter = new MemberListAdapter();
        }
        boolean useUserProfile = (args = this.getArguments()) == null || args.getBoolean("KEY_USE_USER_PROFILE", SendBirdUIKit.shouldUseDefaultUserProfile());
        this.adapter.setOnItemClickListener(this.itemClickListener != null ? this.itemClickListener : this::onItemClicked);
        this.adapter.setOnItemLongClickListener(this.itemLongClickListener != null ? this.itemLongClickListener : this::onItemLongClicked);
        this.adapter.setOnActionItemClickListener(this.actionItemClickListener != null ? this.actionItemClickListener : this::onActionItemClicked);
        this.adapter.setOnProfileClickListener(this.profileClickListener != null ? this.profileClickListener : (useUserProfile ? this::onProfileClicked : null));
        this.binding.rvMemberList.setAdapter(this.adapter);
        this.binding.rvMemberList.setHasFixedSize(true);
        this.binding.rvMemberList.setPager(viewModel);
        this.binding.rvMemberList.setThreshold(5);
        viewModel.getStatusFrame().observe((LifecycleOwner)this, this.binding.statusFrame::setStatus);
        viewModel.getMemberList().observe((LifecycleOwner)this, members -> {
            Logger.dev("++ observing result members size : %s", members.size());
            this.binding.rvMemberList.setRefreshing(false);
            this.adapter.setItems((List)members, channel.getMyRole());
        });
        viewModel.loadInitial();
    }

    protected void onItemClicked(View view, int position, Member member) {
    }

    protected void onItemLongClicked(View view, int position, Member member) {
    }

    protected void onActionItemClicked(View view, int position, Member member) {
    }

    protected void onProfileClicked(View view, int position, Member member) {
        if (this.getContext() != null) {
            new UserProfileDialog.Builder(this.getContext(), (User)member).setLoadingDialogHandler(this.loadingDialogHandler).build().show();
        }
    }

    protected void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    protected void setHeaderRightButtonListener(View.OnClickListener listener) {
        this.headerRightButtonListener = listener;
    }

    protected <T extends MemberListAdapter> void setMemberListAdapter(T adapter) {
        this.adapter = adapter;
    }

    protected void setItemClickListener(OnItemClickListener<Member> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    protected void setItemLongClickListener(OnItemLongClickListener<Member> itemLongClickListener) {
        this.itemLongClickListener = itemLongClickListener;
    }

    protected void setActionItemClickListener(OnItemClickListener<Member> actionItemClickListener) {
        this.actionItemClickListener = actionItemClickListener;
    }

    void setCustomQueryHandler(CustomMemberListQueryHandler<Member> handler) {
        this.customQueryHandler = handler;
    }

    void setOnProfileClickListener(OnItemClickListener<Member> profileClickListener) {
        this.profileClickListener = profileClickListener;
    }

    void setLoadingDialogHandler(LoadingDialogHandler loadingDialogHandler) {
        this.loadingDialogHandler = loadingDialogHandler;
    }
}

