/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.viewholder;

import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.databinding.DataBindingUtil;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.FileMessage;
import com.sendbird.android.UserMessage;
import com.sendbird.uikit.R;
import com.sendbird.uikit.activities.viewholder.AdminMessageViewHolder;
import com.sendbird.uikit.activities.viewholder.MessageType;
import com.sendbird.uikit.activities.viewholder.MessageViewHolder;
import com.sendbird.uikit.activities.viewholder.MyFileMessageViewHolder;
import com.sendbird.uikit.activities.viewholder.MyImageFileMessageViewHolder;
import com.sendbird.uikit.activities.viewholder.MyUserMessageViewHolder;
import com.sendbird.uikit.activities.viewholder.MyVideoFileMessageViewHolder;
import com.sendbird.uikit.activities.viewholder.OtherFileMessageViewHolder;
import com.sendbird.uikit.activities.viewholder.OtherImageFileMessageViewHolder;
import com.sendbird.uikit.activities.viewholder.OtherUserMessageViewHolder;
import com.sendbird.uikit.activities.viewholder.OtherVideoFileMessageViewHolder;
import com.sendbird.uikit.activities.viewholder.TimelineViewHolder;
import com.sendbird.uikit.model.TimelineMessage;
import com.sendbird.uikit.utils.MessageUtils;

public class MessageViewHolderFactory {
    public static MessageViewHolder createViewHolder(@NonNull LayoutInflater inflater, @NonNull ViewGroup parent, MessageType viewType, boolean useMessageGroupUI) {
        MessageViewHolder holder;
        switch (viewType) {
            case VIEW_TYPE_USER_MESSAGE_ME: {
                holder = new MyUserMessageViewHolder(DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_my_user_message, (ViewGroup)parent, (boolean)false), useMessageGroupUI);
                break;
            }
            case VIEW_TYPE_USER_MESSAGE_OTHER: {
                holder = new OtherUserMessageViewHolder(DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_other_user_message, (ViewGroup)parent, (boolean)false), useMessageGroupUI);
                break;
            }
            case VIEW_TYPE_FILE_MESSAGE_ME: {
                holder = new MyFileMessageViewHolder(DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_my_file_message, (ViewGroup)parent, (boolean)false), useMessageGroupUI);
                break;
            }
            case VIEW_TYPE_FILE_MESSAGE_OTHER: {
                holder = new OtherFileMessageViewHolder(DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_other_file_message, (ViewGroup)parent, (boolean)false), useMessageGroupUI);
                break;
            }
            case VIEW_TYPE_FILE_MESSAGE_IMAGE_ME: {
                holder = new MyImageFileMessageViewHolder(DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_my_file_image_message, (ViewGroup)parent, (boolean)false), useMessageGroupUI);
                break;
            }
            case VIEW_TYPE_FILE_MESSAGE_IMAGE_OTHER: {
                holder = new OtherImageFileMessageViewHolder(DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_other_file_image_message, (ViewGroup)parent, (boolean)false), useMessageGroupUI);
                break;
            }
            case VIEW_TYPE_FILE_MESSAGE_VIDEO_ME: {
                holder = new MyVideoFileMessageViewHolder(DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_my_file_video_message, (ViewGroup)parent, (boolean)false), useMessageGroupUI);
                break;
            }
            case VIEW_TYPE_FILE_MESSAGE_VIDEO_OTHER: {
                holder = new OtherVideoFileMessageViewHolder(DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_other_file_video_message, (ViewGroup)parent, (boolean)false), useMessageGroupUI);
                break;
            }
            case VIEW_TYPE_TIME_LINE: {
                holder = new TimelineViewHolder(DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_time_line_message, (ViewGroup)parent, (boolean)false), false);
                break;
            }
            case VIEW_TYPE_ADMIN_MESSAGE: {
                holder = new AdminMessageViewHolder(DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_admin_message, (ViewGroup)parent, (boolean)false), false);
                break;
            }
            default: {
                holder = viewType == MessageType.VIEW_TYPE_UNKNOWN_MESSAGE_ME ? new MyUserMessageViewHolder(DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_my_user_message, (ViewGroup)parent, (boolean)false), useMessageGroupUI) : new OtherUserMessageViewHolder(DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_view_other_user_message, (ViewGroup)parent, (boolean)false), useMessageGroupUI);
            }
        }
        return holder;
    }

    public static int getViewType(@NonNull BaseMessage message) {
        return MessageViewHolderFactory.getMessageType(message).getValue();
    }

    public static MessageType getMessageType(@NonNull BaseMessage message) {
        FileMessage fileMessage;
        MessageType type = message instanceof UserMessage ? (MessageUtils.isMine(message) ? MessageType.VIEW_TYPE_USER_MESSAGE_ME : MessageType.VIEW_TYPE_USER_MESSAGE_OTHER) : (message instanceof FileMessage ? ((fileMessage = (FileMessage)message).getType().toLowerCase().startsWith("image") ? (MessageUtils.isMine(message) ? MessageType.VIEW_TYPE_FILE_MESSAGE_IMAGE_ME : MessageType.VIEW_TYPE_FILE_MESSAGE_IMAGE_OTHER) : (fileMessage.getType().toLowerCase().startsWith("video") ? (MessageUtils.isMine(message) ? MessageType.VIEW_TYPE_FILE_MESSAGE_VIDEO_ME : MessageType.VIEW_TYPE_FILE_MESSAGE_VIDEO_OTHER) : (MessageUtils.isMine(message) ? MessageType.VIEW_TYPE_FILE_MESSAGE_ME : MessageType.VIEW_TYPE_FILE_MESSAGE_OTHER))) : (message instanceof TimelineMessage ? MessageType.VIEW_TYPE_TIME_LINE : (message instanceof AdminMessage ? MessageType.VIEW_TYPE_ADMIN_MESSAGE : (MessageUtils.isMine(message) ? MessageType.VIEW_TYPE_UNKNOWN_MESSAGE_ME : MessageType.VIEW_TYPE_UNKNOWN_MESSAGE_OTHER))));
        return type;
    }
}

