/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.databinding.DataBindingUtil;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewMyUserMessageComponentBinding;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.widgets.BaseMyMessageView;

public class MyUserMessageView
extends BaseMyMessageView {
    private SbViewMyUserMessageComponentBinding binding;

    @Override
    public SbViewMyUserMessageComponentBinding getBinding() {
        return this.binding;
    }

    public MyUserMessageView(Context context) {
        this(context, null);
    }

    public MyUserMessageView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_message_user_style);
    }

    public MyUserMessageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageView_User, defStyle, 0);
        try {
            this.binding = (SbViewMyUserMessageComponentBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_my_user_message_component, (ViewGroup)this, (boolean)true);
            int timeAppearance = a.getResourceId(R.styleable.MessageView_User_sb_message_time_text_appearance, R.style.SendbirdCaption3OnLight03);
            int messageAppearance = a.getResourceId(R.styleable.MessageView_User_sb_message_me_text_appearance, R.style.SendbirdBody1OnDark01);
            int messageBackground = a.getResourceId(R.styleable.MessageView_User_sb_message_me_background, R.drawable.selector_my_user_message_bubble_light);
            int messageBackgroundTint = a.getResourceId(R.styleable.MessageView_User_sb_message_me_background_tint, R.color.sb_message_me_tint_light);
            int emojiReactionListBackground = a.getResourceId(R.styleable.MessageView_User_sb_message_emoji_reaction_list_background, R.drawable.chatbubble_reactions_light);
            int ogtagBackground = a.getResourceId(R.styleable.MessageView_User_sb_message_me_ogtag_background, R.drawable.sb_message_og_background);
            int ogtagBackgroundTint = a.getResourceId(R.styleable.MessageView_User_sb_message_me_ogtag_background_tint, R.color.sb_message_other_tint_light);
            int linkTextColor = a.getResourceId(R.styleable.MessageView_User_sb_message_me_link_text_color, R.color.ondark_01);
            int clickedLinkBackgroundColor = a.getResourceId(R.styleable.MessageView_User_sb_message_me_clicked_link_background_color, R.color.primary_400);
            this.binding.tvMessage.setTextAppearance(context, messageAppearance);
            this.binding.tvMessage.setLinkTextColor(context.getResources().getColor(linkTextColor));
            this.binding.tvSentAt.setTextAppearance(context, timeAppearance);
            this.binding.contentPanel.setBackground(DrawableUtils.setTintList(this.getContext(), messageBackground, messageBackgroundTint));
            this.binding.emojiReactionListBackground.setBackgroundResource(emojiReactionListBackground);
            this.binding.ogtagBackground.setBackground(DrawableUtils.setTintList(this.getContext(), ogtagBackground, ogtagBackgroundTint));
            this.binding.ovOgtag.setBackground(DrawableUtils.setTintList(this.getContext(), ogtagBackground, ogtagBackgroundTint));
            this.binding.tvMessage.setOnClickListener(v -> this.binding.contentPanel.performClick());
            this.binding.tvMessage.setOnLongClickListener(v -> this.binding.contentPanel.performLongClick());
            this.binding.tvMessage.setOnLinkLongClickListener((v, link) -> this.binding.contentPanel.performLongClick());
            this.binding.tvMessage.setClickedLinkBackgroundColor(context.getResources().getColor(clickedLinkBackgroundColor));
            this.binding.ovOgtag.setOnLongClickListener(v -> this.binding.contentPanel.performLongClick());
        }
        finally {
            a.recycle();
        }
    }

    @Override
    public View getLayout() {
        return this.binding.getRoot();
    }
}

