/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.ActivityCompat;
import androidx.databinding.DataBindingUtil;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.Emoji;
import com.sendbird.android.FileMessage;
import com.sendbird.android.FileMessageParams;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Member;
import com.sendbird.android.MessageListParams;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.UserMessageParams;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.ChannelSettingsActivity;
import com.sendbird.uikit.activities.PhotoViewActivity;
import com.sendbird.uikit.activities.adapter.MessageListAdapter;
import com.sendbird.uikit.activities.viewholder.MessageType;
import com.sendbird.uikit.activities.viewholder.MessageViewHolderFactory;
import com.sendbird.uikit.databinding.SbFragmentChannelBinding;
import com.sendbird.uikit.dialogs.DialogHelper;
import com.sendbird.uikit.fragments.ItemAnimator;
import com.sendbird.uikit.fragments.PermissionFragment;
import com.sendbird.uikit.fragments.UserProfileDialog;
import com.sendbird.uikit.interfaces.CustomParamsHandler;
import com.sendbird.uikit.interfaces.OnEmojiReactionClickListener;
import com.sendbird.uikit.interfaces.OnEmojiReactionLongClickListener;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.interfaces.OnResultHandler;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.EmojiManager;
import com.sendbird.uikit.model.FileInfo;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.tasks.JobResultTask;
import com.sendbird.uikit.tasks.TaskQueue;
import com.sendbird.uikit.utils.ChannelUtils;
import com.sendbird.uikit.utils.DateUtils;
import com.sendbird.uikit.utils.FileUtils;
import com.sendbird.uikit.utils.IntentUtils;
import com.sendbird.uikit.utils.MessageUtils;
import com.sendbird.uikit.utils.ReactionUtils;
import com.sendbird.uikit.utils.SoftInputUtils;
import com.sendbird.uikit.utils.TextUtils;
import com.sendbird.uikit.vm.ChannelViewModel;
import com.sendbird.uikit.vm.FileDownloader;
import com.sendbird.uikit.vm.SuperChannelViewModel;
import com.sendbird.uikit.vm.ViewModelFactory;
import com.sendbird.uikit.widgets.EmojiListView;
import com.sendbird.uikit.widgets.EmojiReactionUserListView;
import com.sendbird.uikit.widgets.PagerRecyclerView;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class ChannelFragment
extends PermissionFragment
implements ActivityCompat.OnRequestPermissionsResultCallback,
OnItemClickListener<BaseMessage>,
OnItemLongClickListener<BaseMessage> {
    private static final int CAPTURE_IMAGE_PERMISSIONS_REQUEST_CODE = 2001;
    private static final int PICK_IMAGE_PERMISSIONS_REQUEST_CODE = 2002;
    private static final int PICK_FILE_PERMISSIONS_REQUEST_CODE = 2003;
    private static final int GROUP_CHANNEL_SETTINGS_REQUEST_CODE = 2004;
    private static final int PERMISSION_REQUEST_ALL = 2005;
    private static final int PERMISSION_REQUEST_STORAGE = 2006;
    private SbFragmentChannelBinding binding;
    private ChannelViewModel viewModel;
    private MessageListAdapter adapter;
    private String inputHint;
    private AtomicInteger tooltipMessageCount = new AtomicInteger();
    private Uri mediaUri;
    private long editMessageId;
    private View.OnClickListener headerLeftButtonListener;
    private View.OnClickListener headerRightButtonListener;
    private OnItemClickListener<BaseMessage> profileClickListener;
    private OnItemClickListener<BaseMessage> itemClickListener;
    private OnItemLongClickListener<BaseMessage> itemLongClickListener;
    private View.OnClickListener inputLeftButtonListener;
    private MessageListParams params;
    private OnEmojiReactionClickListener emojiReactionClickListener;
    private OnEmojiReactionLongClickListener emojiReactionLongClickListener;
    private OnItemClickListener<BaseMessage> emojiReactionMoreButtonClickListener;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(">> ChannelFragment::onCreate()", new Object[0]);
        Bundle args = this.getArguments();
        int themeResId = SendBirdUIKit.getDefaultThemeMode().getResId();
        if (args != null) {
            themeResId = args.getInt("KEY_THEME_RES_ID", SendBirdUIKit.getDefaultThemeMode().getResId());
        }
        if (this.getActivity() != null) {
            this.getActivity().setTheme(themeResId);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binding = (SbFragmentChannelBinding)DataBindingUtil.inflate((LayoutInflater)inflater, (int)R.layout.sb_fragment_channel, (ViewGroup)container, (boolean)false);
        return this.binding.getRoot();
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.initHeaderOnCreated();
    }

    @Override
    public void onReady(User user, ReadyStatus status) {
        Logger.i(">> ChannelFragment::onReady(%s)", new Object[]{status});
        Logger.i("++ user : %s", user);
        if (status == ReadyStatus.ERROR) {
            this.toastError(R.string.sb_text_error_connect_server);
            return;
        }
        if (this.channel == null) {
            this.toastError(R.string.sb_text_error_get_channel);
            this.finish();
            return;
        }
        this.onConfigure();
        this.onDrawPage();
    }

    protected void onConfigure() {
    }

    protected void onDrawPage() {
        Logger.i(">> ChannelFragment::onDrawPage() - %s", Logger.getCallerTraceInfo(ChannelFragment.class));
        this.viewModel = this.createViewModel(this.channel);
        this.getLifecycle().addObserver((LifecycleObserver)this.viewModel);
        this.initHeaderOnReady(this.channel);
        this.initMessageList(this.channel);
        this.initMessageInput();
        this.drawChannel(this.channel);
    }

    private ChannelViewModel createViewModel(GroupChannel channel) {
        if (channel.isSuper()) {
            return (ChannelViewModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new ViewModelFactory(this, channel, this.params)).get(SuperChannelViewModel.class);
        }
        return (ChannelViewModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new ViewModelFactory(this, channel, this.params)).get(ChannelViewModel.class);
    }

    private void drawChannel(GroupChannel channel) {
        Logger.dev("++ drawChannel()");
        if (this.isActive()) {
            this.binding.chvChannelHeader.getTitleTextView().setText((CharSequence)ChannelUtils.makeTitleText(this.getContext(), channel));
            ChannelUtils.loadChannelCover(this.binding.chvChannelHeader.getProfileView(), channel);
            this.drawMessageInput(channel);
        }
    }

    private void drawMessageInput(GroupChannel channel) {
        boolean isOperator = channel.getMyRole() == Member.Role.OPERATOR;
        boolean isBroadcastChannel = channel.isBroadcast();
        if (isBroadcastChannel) {
            this.binding.vgInputBox.setVisibility(isOperator ? 0 : 8);
        } else {
            boolean isEnabled;
            boolean isFrozen;
            boolean isMuted = channel.getMyMutedState() == Member.MutedState.MUTED;
            boolean bl = isFrozen = channel.isFrozen() && !isOperator;
            if (isMuted || isFrozen) {
                this.enableMessageInput(false, this.getResources().getString(isFrozen ? R.string.sb_text_channel_input_text_hint_frozen : R.string.sb_text_channel_input_text_hint_muted));
            } else {
                this.enableMessageInput(true, this.inputHint);
            }
            this.binding.tvInformation.setVisibility(channel.isFrozen() ? 0 : 8);
            this.binding.tvInformation.setText(R.string.sb_text_information_channel_frozen);
            boolean bl2 = isEnabled = !isMuted && !isFrozen;
            String hintText = isEnabled ? this.inputHint : this.getResources().getString(isMuted ? R.string.sb_text_channel_input_text_hint_muted : R.string.sb_text_channel_input_text_hint_frozen);
            Logger.dev("++ hint text : " + hintText);
            this.enableMessageInput(isEnabled, hintText);
        }
    }

    private void enableMessageInput(boolean isEnable, String hintText) {
        this.binding.vgInputBox.setEnabled(isEnable);
        this.binding.vgInputBox.getBinding().etInputText.setHint((CharSequence)hintText);
        if (!isEnable) {
            this.finishEditMode();
        }
    }

    private void initHeaderOnCreated() {
        Bundle args = this.getArguments();
        boolean useHeader = false;
        boolean useHeaderLeftButton = true;
        boolean useHeaderRightButton = true;
        int headerLeftButtonIconResId = R.drawable.icon_arrow_left;
        int headerRightButtonIconResId = R.drawable.icon_info;
        if (args != null) {
            useHeader = args.getBoolean("KEY_USE_HEADER", false);
            useHeaderLeftButton = args.getBoolean("KEY_USE_HEADER_LEFT_BUTTON", true);
            useHeaderRightButton = args.getBoolean("KEY_USE_HEADER_RIGHT_BUTTON", true);
            headerLeftButtonIconResId = args.getInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", R.drawable.icon_arrow_left);
            headerRightButtonIconResId = args.getInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", R.drawable.icon_info);
        }
        this.binding.chvChannelHeader.setVisibility(useHeader ? 0 : 8);
        this.binding.chvChannelHeader.setUseLeftImageButton(useHeaderLeftButton);
        this.binding.chvChannelHeader.getRightImageButton().setVisibility(useHeaderRightButton ? 0 : 8);
        this.binding.chvChannelHeader.getLeftImageButton().setImageResource(headerLeftButtonIconResId);
        this.binding.chvChannelHeader.getRightImageButton().setImageResource(headerRightButtonIconResId);
        this.binding.chvChannelHeader.getLeftImageButton().setOnClickListener(v -> this.finish());
    }

    private void initHeaderOnReady(GroupChannel channel) {
        Bundle args = this.getArguments();
        boolean useLastSeenAt = true;
        boolean useTypingIndicator = true;
        if (args != null) {
            useLastSeenAt = args.getBoolean("KEY_LAST_SEEN_AT", true);
            useTypingIndicator = args.getBoolean("KEY_TYPING_INDICATOR", true);
        }
        if (this.headerLeftButtonListener != null) {
            this.binding.chvChannelHeader.getLeftImageButton().setOnClickListener(this.headerLeftButtonListener);
        }
        if (this.headerRightButtonListener != null) {
            this.binding.chvChannelHeader.getRightImageButton().setOnClickListener(this.headerRightButtonListener);
        } else {
            this.binding.chvChannelHeader.getRightImageButton().setOnClickListener(v -> {
                Intent intent = ChannelSettingsActivity.newIntent(this.getContext(), channel.getUrl());
                this.startActivityForResult(intent, 2004);
            });
        }
        this.binding.chvChannelHeader.getProfileView().setVisibility(0);
        this.viewModel.isChannelChanged().observe((LifecycleOwner)this, this::drawChannel);
        this.viewModel.getChannelDeleted().observe((LifecycleOwner)this, deleted -> this.finish());
        if (useTypingIndicator) {
            this.viewModel.getTypingMembers().observe((LifecycleOwner)this, typingMembers -> {
                if (typingMembers == null) {
                    this.binding.chvChannelHeader.getDescriptionTextView().setVisibility(8);
                } else {
                    this.binding.chvChannelHeader.getDescriptionTextView().setVisibility(0);
                    this.binding.chvChannelHeader.getDescriptionTextView().setText((CharSequence)ChannelUtils.makeTypingText(this.getContext(), typingMembers));
                }
            });
        }
        if (useLastSeenAt) {
            this.viewModel.getLastSeenAt().observe((LifecycleOwner)this, lastSeenAt -> {
                if (lastSeenAt == 0L) {
                    this.binding.chvChannelHeader.getDescriptionTextView().setVisibility(8);
                } else {
                    String diff = DateUtils.getTimeDiff(lastSeenAt);
                    if (diff != null) {
                        this.binding.chvChannelHeader.getDescriptionTextView().setVisibility(0);
                        this.binding.chvChannelHeader.getDescriptionTextView().setText((CharSequence)String.format(this.getString(R.string.sb_text_channel_last_seen_at), diff));
                    }
                }
            });
        }
    }

    private void initMessageList(GroupChannel channel) {
        boolean useUserProfile;
        Bundle args = this.getArguments();
        boolean useMessageGroupUI = args == null || args.getBoolean("KEY_USE_MESSAGE_GROUP_UI", true);
        boolean bl = useUserProfile = args == null || args.getBoolean("KEY_USE_USER_PROFILE", SendBirdUIKit.shouldUseDefaultUserProfile());
        if (this.adapter == null) {
            this.adapter = new MessageListAdapter(channel, null, null, useMessageGroupUI);
        }
        this.adapter.setChannel(channel);
        if (this.itemClickListener == null) {
            this.itemClickListener = this;
        }
        if (this.itemLongClickListener == null) {
            this.itemLongClickListener = this;
        }
        if (this.profileClickListener == null && useUserProfile) {
            this.profileClickListener = (view, position, message) -> {
                this.hideKeyboard();
                new UserProfileDialog.Builder(this.getContext(), (User)message.getSender()).build().show();
            };
        }
        this.adapter.setOnItemClickListener(this.itemClickListener);
        this.adapter.setOnItemLongClickListener(this.itemLongClickListener);
        this.adapter.setOnProfileClickListener(this.profileClickListener);
        if (ReactionUtils.useReaction((BaseChannel)channel)) {
            if (this.emojiReactionClickListener == null) {
                this.emojiReactionClickListener = (view, position, message, reactionKey) -> this.viewModel.toggleReaction(view, message, reactionKey);
            }
            this.adapter.setEmojiReactionClickListener(this.emojiReactionClickListener);
            if (this.emojiReactionLongClickListener == null) {
                this.emojiReactionLongClickListener = (view, position, message, reactionKey) -> {
                    if (this.getContext() == null) {
                        return;
                    }
                    if (message != null) {
                        EmojiReactionUserListView emojiReactionUserListView = new EmojiReactionUserListView(this.getContext());
                        emojiReactionUserListView.setEmojiReactionUserData(this, position, message.getReactions(), this.viewModel.getReactionUserInfo(message.getReactions()));
                        this.hideKeyboard();
                        DialogHelper.showBottomView(this.getContext(), (View)emojiReactionUserListView);
                    }
                };
            }
            this.adapter.setEmojiReactionLongClickListener(this.emojiReactionLongClickListener);
            if (this.emojiReactionMoreButtonClickListener == null) {
                this.emojiReactionMoreButtonClickListener = (view, position, message) -> this.showEmojiListDialog((BaseMessage)message);
            }
            this.adapter.setEmojiReactionMoreButtonClickListener(this.emojiReactionMoreButtonClickListener);
        }
        final PagerRecyclerView recyclerView = this.binding.mrvMessageList.getRecyclerView();
        recyclerView.setAdapter(this.adapter);
        recyclerView.setHasFixedSize(true);
        recyclerView.setPager(this.viewModel);
        recyclerView.setThreshold(5);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new ItemAnimator());
        recyclerView.setOnScrollEndedEventListener(this::hideTooltipView);
        this.binding.mrvMessageList.getTooltipView().setOnClickListener(v -> this.scrollToBottom());
        this.adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeInserted(int positionStart, int itemCount) {
                if (positionStart == 0 && ChannelFragment.this.adapter != null) {
                    BaseMessage message = ChannelFragment.this.adapter.getItem(positionStart);
                    if ((BaseMessage.belongsTo((BaseMessage)message, (String)SendBird.getCurrentUser().getUserId()) || ((ChannelFragment)ChannelFragment.this).binding.mrvMessageList.getRecyclerView().findFirstVisibleItemPosition() == 0) && !DialogHelper.isAnchorShowing()) {
                        recyclerView.scrollToPosition(0);
                    } else if (((ChannelFragment)ChannelFragment.this).binding.mrvMessageList.getRecyclerView().findFirstVisibleItemPosition() > 0 || DialogHelper.isAnchorShowing()) {
                        ((ChannelFragment)ChannelFragment.this).binding.mrvMessageList.showNewMessageTooltip(ChannelFragment.this.getTooltipMessage(ChannelFragment.this.tooltipMessageCount.addAndGet(itemCount)));
                    }
                }
            }
        });
        this.viewModel.getMessageList().observe((LifecycleOwner)this, messageList -> {
            Logger.dev("++ result messageList size : %s", messageList.size());
            this.binding.mrvMessageList.getRecyclerView().setRefreshing(false);
            this.adapter.setItems(channel, (List<BaseMessage>)messageList);
        });
        this.viewModel.load();
    }

    private void initMessageInput() {
        Bundle args = this.getArguments();
        this.inputHint = this.getResources().getString(R.string.sb_text_channel_input_text_hint);
        if (args != null) {
            if (args.containsKey("KEY_INPUT_LEFT_BUTTON_ICON_RES_ID")) {
                int inputLeftButtonIconResId = args.getInt("KEY_INPUT_LEFT_BUTTON_ICON_RES_ID", SendBirdUIKit.isDarkMode() ? R.drawable.selector_message_input_chooser_icon_dark : R.drawable.selector_message_input_chooser_icon);
                this.binding.vgInputBox.getBinding().ibtnAdd.setImageResource(inputLeftButtonIconResId);
            }
            if (args.containsKey("KEY_INPUT_RIGHT_BUTTON_ICON_RES_ID")) {
                int inputRightButtonIconResId = args.getInt("KEY_INPUT_RIGHT_BUTTON_ICON_RES_ID", R.drawable.icon_send);
                this.binding.vgInputBox.getBinding().ibtnSend.setImageResource(inputRightButtonIconResId);
            }
            if (args.containsKey("KEY_INPUT_HINT")) {
                this.inputHint = args.getString("KEY_INPUT_HINT", this.getString(R.string.sb_text_channel_input_text_hint));
                this.binding.vgInputBox.getBinding().etInputText.setHint((CharSequence)this.inputHint);
            }
        }
        this.binding.vgInputBox.getBinding().ibtnSend.setOnClickListener(this::sendMessage);
        this.binding.vgInputBox.getBinding().etInputText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (!TextUtils.isEmpty(s) && ChannelFragment.this.editMessageId == 0L) {
                    ((ChannelFragment)ChannelFragment.this).binding.vgInputBox.getBinding().ibtnSend.setVisibility(0);
                } else {
                    ((ChannelFragment)ChannelFragment.this).binding.vgInputBox.getBinding().ibtnSend.setVisibility(8);
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                ChannelFragment.this.viewModel.setTyping(s.length() > 0);
            }

            public void afterTextChanged(Editable s) {
                if (!TextUtils.isEmpty((CharSequence)s) && ChannelFragment.this.editMessageId == 0L) {
                    ((ChannelFragment)ChannelFragment.this).binding.vgInputBox.getBinding().ibtnSend.setVisibility(0);
                } else {
                    ((ChannelFragment)ChannelFragment.this).binding.vgInputBox.getBinding().ibtnSend.setVisibility(8);
                }
            }
        });
        this.binding.vgInputBox.getBinding().ibtnAdd.setOnClickListener(this.inputLeftButtonListener == null ? v -> this.showMediaSelectDialog() : this.inputLeftButtonListener);
        this.binding.vgInputBox.getBinding().btnCancel.setOnClickListener(v -> this.finishEditMode());
        this.binding.vgInputBox.getBinding().btnSave.setOnClickListener(v -> {
            String text = this.getEditTextString();
            if (!TextUtils.isEmpty(text)) {
                UserMessageParams params = new UserMessageParams(text);
                this.updateUserMessage(this.editMessageId, params);
            }
            this.finishEditMode();
        });
    }

    private void hideTooltipView() {
        this.binding.mrvMessageList.hideNewMessageTooltip();
        this.tooltipMessageCount.set(0);
    }

    private void scrollToBottom() {
        if (this.binding == null) {
            return;
        }
        RecyclerView.LayoutManager layoutMgr = this.binding.mrvMessageList.getRecyclerView().getLayoutManager();
        if (layoutMgr == null) {
            return;
        }
        layoutMgr.scrollToPosition(0);
    }

    private void showMediaSelectDialog() {
        DialogHelper.DialogListItem[] items = new DialogHelper.DialogListItem[]{new DialogHelper.DialogListItem(R.string.sb_text_channel_input_camera, R.drawable.icon_camera), new DialogHelper.DialogListItem(R.string.sb_text_channel_input_gallery, R.drawable.icon_photo), new DialogHelper.DialogListItem(R.string.sb_text_channel_input_document, R.drawable.icon_document)};
        DialogHelper.showBottomList(this.getContext(), items, key -> {
            try {
                SendBird.setAutoBackgroundDetection((boolean)false);
                if (key == R.string.sb_text_channel_input_camera) {
                    this.checkPermission(2005, new PermissionFragment.IPermissionHandler(){

                        @Override
                        public String[] getPermissions(int requestCode) {
                            return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
                        }

                        @Override
                        public void onPermissionGranted(int requestCode) {
                            ChannelFragment.this.takeCamera();
                        }
                    });
                } else {
                    this.checkPermission(2006, new PermissionFragment.IPermissionHandler(){

                        @Override
                        public String[] getPermissions(int requestCode) {
                            return new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
                        }

                        @Override
                        public void onPermissionGranted(int requestCode) {
                            if (key == R.string.sb_text_channel_input_gallery) {
                                ChannelFragment.this.pickImage();
                            } else {
                                ChannelFragment.this.pickFile();
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                Logger.e(e);
                if (key == R.string.sb_text_channel_input_camera) {
                    this.toastError(R.string.sb_text_error_open_camera);
                }
                if (key == R.string.sb_text_channel_input_gallery) {
                    this.toastError(R.string.sb_text_error_open_gallery);
                }
                this.toastError(R.string.sb_text_error_open_file);
            }
        });
    }

    private void takeCamera() {
        this.mediaUri = FileUtils.createPictureImageUri(this.getContext());
        Intent intent = IntentUtils.getCameraIntent(this.getContext(), this.mediaUri);
        if (IntentUtils.hasIntent(this.getContext(), intent)) {
            this.startActivityForResult(intent, 2001);
        }
    }

    private void pickImage() {
        Intent intent = IntentUtils.getGalleryIntent();
        this.startActivityForResult(intent, 2002);
    }

    private void pickFile() {
        Intent intent = IntentUtils.getFileChooserIntent();
        this.startActivityForResult(intent, 2003);
    }

    private void finishEditMode() {
        this.binding.vgInputBox.hideEditMode();
        this.editMessageId = 0L;
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        SendBird.setAutoBackgroundDetection((boolean)true);
        if (requestCode == 2004) {
            this.drawChannel(this.viewModel.getChannel());
            return;
        }
        if (resultCode == -1) {
            switch (requestCode) {
                case 2001: {
                    break;
                }
                case 2002: 
                case 2003: {
                    this.mediaUri = data.getData();
                }
            }
            if (this.mediaUri != null && this.isActive()) {
                this.sendFileMessage(this.mediaUri);
            }
        }
    }

    private String getTooltipMessage(int count) {
        String result = "";
        if (count > 1) {
            result = String.format(Locale.US, this.getString(R.string.sb_text_channel_tooltip_with_count), count);
        } else if (count == 1) {
            result = String.format(Locale.US, this.getString(R.string.sb_text_channel_tooltip), count);
        }
        return result;
    }

    private void sendMessage(View view) {
        String text;
        Logger.dev("++ onClick()");
        if (view.getId() == this.binding.vgInputBox.getBinding().ibtnSend.getId() && !TextUtils.isEmpty(text = this.getEditTextString())) {
            UserMessageParams params = new UserMessageParams(text);
            this.sendUserMessage(params);
            this.binding.vgInputBox.getBinding().etInputText.setText((CharSequence)"");
        }
    }

    protected void onBeforeSendUserMessage(@NonNull UserMessageParams params) {
    }

    protected void onBeforeSendFileMessage(@NonNull FileMessageParams params) {
    }

    protected void onBeforeUpdateUserMessage(@NonNull UserMessageParams params) {
    }

    protected void sendUserMessage(@NonNull UserMessageParams params) {
        if (this.viewModel != null) {
            CustomParamsHandler cutsomHandler = SendBirdUIKit.getCustomParamsHandler();
            if (cutsomHandler != null) {
                cutsomHandler.onBeforeSendUserMessage(params);
            }
            this.onBeforeSendUserMessage(params);
            this.viewModel.sendUserMessage(params);
        }
    }

    protected void sendFileMessage(@NonNull Uri uri) {
        if (this.viewModel != null && this.getContext() != null) {
            FileInfo.fromUri(this.getContext(), uri, new OnResultHandler<FileInfo>(){

                @Override
                public void onResult(FileInfo info) {
                    FileMessageParams params = info.toFileParams();
                    CustomParamsHandler cutsomHandler = SendBirdUIKit.getCustomParamsHandler();
                    if (cutsomHandler != null) {
                        cutsomHandler.onBeforeSendFileMessage(params);
                    }
                    ChannelFragment.this.onBeforeSendFileMessage(params);
                    ChannelFragment.this.viewModel.sendFileMessage(params, info);
                }

                @Override
                public void onError(SendBirdException e) {
                    Logger.w((Throwable)e);
                    ChannelFragment.this.toastError(R.string.sb_text_error_send_message);
                }
            });
        }
    }

    protected void updateUserMessage(long messageId, @NonNull UserMessageParams params) {
        if (this.viewModel != null) {
            CustomParamsHandler cutsomHandler = SendBirdUIKit.getCustomParamsHandler();
            if (cutsomHandler != null) {
                cutsomHandler.onBeforeUpdateUserMessage(params);
            }
            this.onBeforeUpdateUserMessage(params);
            this.viewModel.updateUserMessage(messageId, params);
        }
    }

    protected void deleteMessage(@NonNull BaseMessage message) {
        if (this.viewModel != null) {
            this.viewModel.deleteMessage(message);
        }
    }

    protected void resendMessage(@NonNull BaseMessage message) {
        if (this.viewModel != null && message.isResendable()) {
            this.viewModel.resendMessage(message);
        }
    }

    private String getEditTextString() {
        if (this.binding.vgInputBox.getBinding().etInputText.getText() != null) {
            return this.binding.vgInputBox.getBinding().etInputText.getText().toString().trim();
        }
        return null;
    }

    private void showFile(final @NonNull File file, final @NonNull String mimeType) {
        TaskQueue.addTask(new JobResultTask<Intent>(){

            @Override
            public Intent call() {
                Uri uri = FileUtils.fileToUri(ChannelFragment.this.getContext(), file);
                return IntentUtils.getFileViewerIntent(uri, mimeType);
            }

            @Override
            public void onResultForUiThread(Intent intent, SendBirdException e) {
                if (e != null) {
                    Logger.e((Throwable)e);
                    ChannelFragment.this.toastError(R.string.sb_text_error_open_file);
                    return;
                }
                if (intent != null) {
                    ChannelFragment.this.startActivity(intent);
                }
            }
        });
    }

    @Override
    public void onItemClick(View view, int position, BaseMessage message) {
        Logger.d("++ ChannelFragment::onItemClicked()");
        BaseMessage.SendingStatus status = message.getSendingStatus();
        if (status == BaseMessage.SendingStatus.SUCCEEDED) {
            MessageType type = MessageViewHolderFactory.getMessageType(message);
            switch (type) {
                case VIEW_TYPE_FILE_MESSAGE_IMAGE_ME: 
                case VIEW_TYPE_FILE_MESSAGE_IMAGE_OTHER: {
                    this.startActivity(PhotoViewActivity.newIntent(this.getContext(), (FileMessage)message));
                    break;
                }
                case VIEW_TYPE_FILE_MESSAGE_VIDEO_ME: 
                case VIEW_TYPE_FILE_MESSAGE_VIDEO_OTHER: 
                case VIEW_TYPE_FILE_MESSAGE_ME: 
                case VIEW_TYPE_FILE_MESSAGE_OTHER: {
                    final FileMessage fileMessage = (FileMessage)message;
                    this.viewModel.downloadFile(this.getContext(), fileMessage, new OnResultHandler<File>(){

                        @Override
                        public void onResult(File file) {
                            ChannelFragment.this.showFile(file, fileMessage.getType());
                        }

                        @Override
                        public void onError(SendBirdException e) {
                            ChannelFragment.this.toastError(R.string.sb_text_error_download_file);
                        }
                    });
                    break;
                }
            }
        } else {
            this.resendMessage(message);
        }
    }

    private boolean isLongClickable(BaseMessage message) {
        BaseMessage.SendingStatus status = message.getSendingStatus();
        switch (status) {
            case FAILED: 
            case SUCCEEDED: 
            case CANCELED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void onItemLongClick(View itemView, int position, BaseMessage message) {
        if (!this.isLongClickable(message)) {
            return;
        }
        Logger.d("++ ChannelFragment::onItemLongClick()");
        boolean isMine = MessageUtils.isMine(message);
        MessageType type = MessageViewHolderFactory.getMessageType(message);
        DialogHelper.DialogListItem copy = new DialogHelper.DialogListItem(R.string.sb_text_channel_anchor_copy, R.drawable.icon_copy);
        DialogHelper.DialogListItem edit = new DialogHelper.DialogListItem(R.string.sb_text_channel_anchor_edit, R.drawable.icon_edit);
        DialogHelper.DialogListItem save = new DialogHelper.DialogListItem(R.string.sb_text_channel_anchor_save, R.drawable.icon_download);
        DialogHelper.DialogListItem delete = new DialogHelper.DialogListItem(R.string.sb_text_channel_anchor_delete, R.drawable.icon_delete);
        DialogHelper.DialogListItem[] actions = null;
        BaseMessage.SendingStatus status = message.getSendingStatus();
        switch (type) {
            case VIEW_TYPE_USER_MESSAGE_ME: {
                if (status == BaseMessage.SendingStatus.SUCCEEDED) {
                    actions = new DialogHelper.DialogListItem[]{copy, edit, delete};
                    break;
                }
                if (status != BaseMessage.SendingStatus.FAILED && status != BaseMessage.SendingStatus.CANCELED) break;
                actions = new DialogHelper.DialogListItem[]{delete};
                break;
            }
            case VIEW_TYPE_USER_MESSAGE_OTHER: {
                actions = new DialogHelper.DialogListItem[]{copy};
                break;
            }
            case VIEW_TYPE_FILE_MESSAGE_IMAGE_ME: 
            case VIEW_TYPE_FILE_MESSAGE_VIDEO_ME: 
            case VIEW_TYPE_FILE_MESSAGE_ME: {
                if (status == BaseMessage.SendingStatus.FAILED || status == BaseMessage.SendingStatus.CANCELED) {
                    actions = new DialogHelper.DialogListItem[]{delete};
                    break;
                }
                actions = new DialogHelper.DialogListItem[]{delete, save};
                break;
            }
            case VIEW_TYPE_FILE_MESSAGE_IMAGE_OTHER: 
            case VIEW_TYPE_FILE_MESSAGE_VIDEO_OTHER: 
            case VIEW_TYPE_FILE_MESSAGE_OTHER: {
                actions = new DialogHelper.DialogListItem[]{save};
                break;
            }
            case VIEW_TYPE_UNKNOWN_MESSAGE_ME: {
                actions = new DialogHelper.DialogListItem[]{delete};
            }
        }
        if (actions != null) {
            if (!ReactionUtils.canSendReaction((BaseChannel)this.viewModel.getChannel())) {
                DialogHelper.showAnchorList(itemView, (View)this.binding.mrvMessageList, actions, this.createMessageActionListener(message), isMine);
            } else if (MessageUtils.isUnknownType(message)) {
                DialogHelper.showBottomList(this.getContext(), actions, this.createMessageActionListener(message));
            } else {
                this.showEmojiActionsDialog(message, actions);
            }
        }
    }

    private void showEmojiActionsDialog(BaseMessage message, DialogHelper.DialogListItem[] actions) {
        if (message == null || actions == null || this.getContext() == null) {
            return;
        }
        List<Emoji> emojiList = EmojiManager.getInstance().getAllEmojis();
        int shownEmojiSize = emojiList.size();
        boolean showMoreButton = false;
        if (emojiList.size() > 6) {
            showMoreButton = true;
            shownEmojiSize = 5;
        }
        emojiList = emojiList.subList(0, shownEmojiSize);
        EmojiListView emojiListView = new EmojiListView.Builder(this.getContext()).setEmojiList(emojiList).setReactionList(message.getReactions()).setShowMoreButton(showMoreButton).create();
        this.hideKeyboard();
        AlertDialog dialog = DialogHelper.showBottomListWithTopView(this.getContext(), (View)emojiListView, actions, this.createMessageActionListener(message));
        emojiListView.setEmojiClickListener((view, position, emojiKey) -> {
            if (dialog != null) {
                dialog.dismiss();
            }
            this.viewModel.toggleReaction(view, message, (String)emojiKey);
        });
        emojiListView.setMoreButtonClickListener(v -> this.showEmojiListDialog(message));
    }

    private void showEmojiListDialog(BaseMessage message) {
        if (this.getContext() == null) {
            return;
        }
        EmojiListView emojiListView = new EmojiListView.Builder(this.getContext()).setEmojiList(EmojiManager.getInstance().getAllEmojis()).setReactionList(message.getReactions()).setShowMoreButton(false).create();
        this.hideKeyboard();
        AlertDialog bottomDialog = DialogHelper.showBottomView(this.getContext(), (View)emojiListView);
        emojiListView.setEmojiClickListener((view, position, emojiKey) -> {
            if (bottomDialog != null) {
                bottomDialog.dismiss();
            }
            this.viewModel.toggleReaction(view, message, (String)emojiKey);
        });
        emojiListView.setMoreButtonClickListener(v -> this.showEmojiListDialog(message));
    }

    private void hideKeyboard() {
        if (this.getView() != null) {
            SoftInputUtils.hideSoftKeyboard(this.getView());
        }
    }

    private DialogHelper.DialogResultListener createMessageActionListener(final BaseMessage message) {
        return key -> {
            if (key == R.string.sb_text_channel_anchor_copy) {
                this.copyTextToClipboard(message.getMessage());
            } else if (key == R.string.sb_text_channel_anchor_edit) {
                this.editMessage(message);
            } else if (key == R.string.sb_text_channel_anchor_delete) {
                this.showWarningDialog(message);
            } else if (key == R.string.sb_text_channel_anchor_save) {
                this.checkPermission(2006, new PermissionFragment.IPermissionHandler(){

                    @Override
                    public String[] getPermissions(int requestCode) {
                        return new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
                    }

                    @Override
                    public void onPermissionGranted(int requestCode) {
                        ChannelFragment.this.download((FileMessage)message);
                    }
                });
            }
        };
    }

    private void download(final FileMessage message) {
        this.toastSuccess(R.string.sb_text_toast_success_start_download_file);
        TaskQueue.addTask(new JobResultTask<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                FileDownloader.getInstance().downloadFile(ChannelFragment.this.getContext(), message.getUrl(), message.getName());
                return true;
            }

            @Override
            public void onResultForUiThread(Boolean result, SendBirdException e) {
                if (e != null) {
                    Logger.e((Throwable)e);
                    ChannelFragment.this.toastError(R.string.sb_text_error_download_file);
                    return;
                }
                ChannelFragment.this.toastSuccess(R.string.sb_text_toast_success_download_file);
            }
        });
    }

    private void copyTextToClipboard(String text) {
        ClipboardManager clipboardManager = (ClipboardManager)this.getContext().getSystemService("clipboard");
        ClipData clipData = ClipData.newPlainText((CharSequence)"COPY_TEXT", (CharSequence)text);
        if (clipboardManager != null) {
            clipboardManager.setPrimaryClip(clipData);
            DialogHelper.toastSuccess(this.getContext(), R.string.sb_text_toast_success_copy);
        } else {
            this.toastError(R.string.sb_text_error_copy_message);
        }
    }

    private void editMessage(BaseMessage message) {
        this.editMessageId = message.getMessageId();
        this.binding.vgInputBox.showEditMode(message.getMessage());
    }

    private void showWarningDialog(BaseMessage message) {
        DialogHelper.showWarning(this.getContext(), R.string.sb_text_dialog_delete_message, R.string.sb_text_button_cancel, cancel -> Logger.dev("cancel"), R.string.sb_text_button_delete, delete -> {
            Logger.dev("delete");
            this.deleteMessage(message);
        });
    }

    private void setHeaderLeftButtonListener(View.OnClickListener listener) {
        this.headerLeftButtonListener = listener;
    }

    private void setHeaderRightButtonListener(View.OnClickListener listener) {
        this.headerRightButtonListener = listener;
    }

    private void setMessageListAdapter(MessageListAdapter adapter) {
        this.adapter = adapter;
    }

    private void setItemClickListener(OnItemClickListener<BaseMessage> itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    private void setItemLongClickListener(OnItemLongClickListener<BaseMessage> itemLongClickListener) {
        this.itemLongClickListener = itemLongClickListener;
    }

    private void setInputLeftButtonListener(View.OnClickListener listener) {
        this.inputLeftButtonListener = listener;
    }

    private void setEmojiReactionClickListener(OnEmojiReactionClickListener emojiReactionClickListener) {
        this.emojiReactionClickListener = emojiReactionClickListener;
    }

    private void setEmojiReactionLongClickListener(OnEmojiReactionLongClickListener emojiReactionLongClickListener) {
        this.emojiReactionLongClickListener = emojiReactionLongClickListener;
    }

    private void setEmojiReactionMoreButtonClickListener(OnItemClickListener<BaseMessage> emojiReactionMoreButtonClickListener) {
        this.emojiReactionMoreButtonClickListener = emojiReactionMoreButtonClickListener;
    }

    private void setMessageListParams(MessageListParams params) {
        this.params = params;
    }

    private void setOnProfileClickListener(OnItemClickListener<BaseMessage> profileClickListener) {
        this.profileClickListener = profileClickListener;
    }

    public static class Builder {
        private Bundle bundle = new Bundle();
        private ChannelFragment customFragment;
        private MessageListAdapter adapter;
        private View.OnClickListener headerLeftButtonListener;
        private View.OnClickListener headerRightButtonListener;
        private OnItemClickListener<BaseMessage> itemClickListener;
        private OnItemLongClickListener<BaseMessage> itemLongClickListener;
        private View.OnClickListener inputLeftButtonListener;
        private MessageListParams params;
        private OnEmojiReactionClickListener emojiReactionClickListener;
        private OnEmojiReactionLongClickListener emojiReactionLongClickListener;
        private OnItemClickListener<BaseMessage> emojiReactionMoreButtonClickListener;
        private OnItemClickListener<BaseMessage> profileClickListener;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends ChannelFragment> Builder setCustomChannelFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderRightButton(boolean useHeaderRightButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_RIGHT_BUTTON", useHeaderRightButton);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setUseLastSeenAt(boolean useLastSeenAt) {
            this.bundle.putBoolean("KEY_LAST_SEEN_AT", useLastSeenAt);
            return this;
        }

        public Builder setUseTypingIndicator(boolean useTypingIndicator) {
            this.bundle.putBoolean("KEY_TYPING_INDICATOR", useTypingIndicator);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setHeaderRightButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_RIGHT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setInputLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_INPUT_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setInputRightButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_INPUT_RIGHT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setInputHint(String hint) {
            this.bundle.putString("KEY_INPUT_HINT", hint);
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public Builder setHeaderRightButtonListener(View.OnClickListener listener) {
            this.headerRightButtonListener = listener;
            return this;
        }

        public Builder setMessageListAdapter(MessageListAdapter adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setItemClickListener(OnItemClickListener<BaseMessage> itemClickListener) {
            this.itemClickListener = itemClickListener;
            return this;
        }

        public Builder setItemLongClickListener(OnItemLongClickListener<BaseMessage> itemLongClickListener) {
            this.itemLongClickListener = itemLongClickListener;
            return this;
        }

        public Builder setInputLeftButtonListener(View.OnClickListener listener) {
            this.inputLeftButtonListener = listener;
            return this;
        }

        public Builder setMessageListParams(MessageListParams params) {
            this.params = params;
            return this;
        }

        public Builder setEmojiReactionClickListener(OnEmojiReactionClickListener emojiReactionClickListener) {
            this.emojiReactionClickListener = emojiReactionClickListener;
            return this;
        }

        public Builder setEmojiReactionLongClickListener(OnEmojiReactionLongClickListener emojiReactionLongClickListener) {
            this.emojiReactionLongClickListener = emojiReactionLongClickListener;
            return this;
        }

        public Builder setEmojiReactionMoreButtonClickListener(OnItemClickListener<BaseMessage> emojiReactionMoreButtonClickListener) {
            this.emojiReactionMoreButtonClickListener = emojiReactionMoreButtonClickListener;
            return this;
        }

        public Builder setUseMessageGroupUI(boolean useMessageGroupUI) {
            this.bundle.putBoolean("KEY_USE_MESSAGE_GROUP_UI", useMessageGroupUI);
            return this;
        }

        public Builder setOnProfileClickListener(OnItemClickListener<BaseMessage> profileClickListener) {
            this.profileClickListener = profileClickListener;
            return this;
        }

        public Builder setUseUserProfile(boolean useUserProfile) {
            this.bundle.putBoolean("KEY_USE_USER_PROFILE", useUserProfile);
            return this;
        }

        public ChannelFragment build() {
            ChannelFragment fragment = this.customFragment != null ? this.customFragment : new ChannelFragment();
            fragment.setArguments(this.bundle);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            fragment.setHeaderRightButtonListener(this.headerRightButtonListener);
            fragment.setMessageListAdapter(this.adapter);
            fragment.setItemClickListener(this.itemClickListener);
            fragment.setItemLongClickListener(this.itemLongClickListener);
            fragment.setInputLeftButtonListener(this.inputLeftButtonListener);
            fragment.setMessageListParams(this.params);
            fragment.setEmojiReactionClickListener(this.emojiReactionClickListener);
            fragment.setEmojiReactionLongClickListener(this.emojiReactionLongClickListener);
            fragment.setEmojiReactionMoreButtonClickListener(this.emojiReactionMoreButtonClickListener);
            fragment.setOnProfileClickListener(this.profileClickListener);
            return fragment;
        }
    }
}

