/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.sendbird.android.OGMetaData;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewOgtagBinding;
import com.sendbird.uikit.utils.TextUtils;

public class OgtagView
extends FrameLayout {
    private SbViewOgtagBinding binding;

    public OgtagView(@NonNull Context context) {
        this(context, null);
    }

    public OgtagView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_message_user_style);
    }

    public OgtagView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, null);
    }

    public static OgtagView inflate(@NonNull Context context, @Nullable ViewGroup parent) {
        return new OgtagView(context, null, R.attr.sb_message_user_style, parent);
    }

    private OgtagView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, ViewGroup parent) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, ViewGroup parent) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MessageView_User, defStyleAttr, 0);
        try {
            if (parent == null) {
                parent = this;
            }
            this.binding = (SbViewOgtagBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.getContext()), (int)R.layout.sb_view_ogtag, (ViewGroup)parent, (boolean)true);
            int ogtagTitleAppearance = a.getResourceId(R.styleable.MessageView_User_sb_message_ogtag_title_appearance, R.style.SendbirdBody3OnLight01);
            int ogtagDescriptionAppearance = a.getResourceId(R.styleable.MessageView_User_sb_message_ogtag_description_appearance, R.style.SendbirdCaption2OnLight01);
            int ogtagUrlAppearance = a.getResourceId(R.styleable.MessageView_User_sb_message_ogtag_url_appearance, R.style.SendbirdCaption2OnLight02);
            this.binding.tvOgTitle.setTextAppearance(context, ogtagTitleAppearance);
            this.binding.tvOgDescription.setTextAppearance(context, ogtagDescriptionAppearance);
            this.binding.tvOgUrl.setTextAppearance(context, ogtagUrlAppearance);
        }
        finally {
            a.recycle();
        }
    }

    public void drawOgtag(OGMetaData ogMetaData) {
        if (ogMetaData == null || this.binding == null) {
            return;
        }
        if (ogMetaData.getOGImage() != null && (ogMetaData.getOGImage().getSecureUrl() != null || ogMetaData.getOGImage().getUrl() != null)) {
            this.binding.ivOgImage.setVisibility(0);
            String ogImageUrl = ogMetaData.getOGImage().getSecureUrl() != null ? ogMetaData.getOGImage().getSecureUrl() : ogMetaData.getOGImage().getUrl();
            RequestBuilder builder = (RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)this.getContext()).asDrawable().diskCacheStrategy(DiskCacheStrategy.ALL)).placeholder(SendBirdUIKit.isDarkMode() ? R.drawable.icon_thumbnail_dark : R.drawable.icon_thumbnail_light)).error(SendBirdUIKit.isDarkMode() ? R.drawable.icon_no_thumbnail_dark : R.drawable.icon_no_thumbnail_light);
            this.binding.ivOgImage.setScaleType(ImageView.ScaleType.CENTER);
            ((RequestBuilder)builder.load(ogImageUrl).centerCrop()).thumbnail(0.3f).listener((RequestListener)new RequestListener<Drawable>(){

                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                    return false;
                }

                public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                    ((OgtagView)OgtagView.this).binding.ivOgImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
                    return false;
                }
            }).into((ImageView)this.binding.ivOgImage);
        } else {
            this.binding.ivOgImage.setVisibility(8);
        }
        if (!TextUtils.isEmpty(ogMetaData.getTitle())) {
            this.binding.tvOgTitle.setVisibility(0);
            this.binding.tvOgTitle.setText((CharSequence)ogMetaData.getTitle());
        } else {
            this.binding.tvOgTitle.setVisibility(8);
        }
        if (!TextUtils.isEmpty(ogMetaData.getDescription())) {
            this.binding.tvOgDescription.setVisibility(0);
            this.binding.tvOgDescription.setText((CharSequence)ogMetaData.getDescription());
        } else {
            this.binding.tvOgDescription.setVisibility(8);
        }
        if (!TextUtils.isEmpty(ogMetaData.getUrl())) {
            this.binding.tvOgUrl.setVisibility(0);
            this.binding.tvOgUrl.setText((CharSequence)ogMetaData.getUrl());
        } else {
            this.binding.tvOgUrl.setVisibility(8);
        }
    }
}

