/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.vm;

import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.OnLifecycleEvent;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.uikit.interfaces.CustomMemberListQueryHandler;
import com.sendbird.uikit.interfaces.DialogProvider;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.vm.BaseViewModel;
import com.sendbird.uikit.widgets.PagerRecyclerView;
import com.sendbird.uikit.widgets.StatusFrameView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UserTypeListViewModel
extends BaseViewModel
implements LifecycleObserver,
PagerRecyclerView.Pageable {
    private final String CHANNEL_HANDLER_MEMBER_LIST = "CHANNEL_HANDLER_MEMBER_LIST" + System.currentTimeMillis();
    private final MutableLiveData<StatusFrameView.Status> statusFrame = new MutableLiveData();
    private final MutableLiveData<List<User>> memberList = new MutableLiveData();
    private CustomMemberListQueryHandler<User> queryHandler;
    protected GroupChannel channel;

    private void onResult(List<User> memberList, Exception e) {
        if (e != null) {
            Logger.e(e);
            this.changeAlertStatus(StatusFrameView.Status.ERROR);
            this.notifyDataSetChanged((Collection)this.memberList.getValue());
        } else {
            ArrayList<User> newUsers = new ArrayList<User>(memberList);
            List origin = (List)this.memberList.getValue();
            if (origin != null) {
                newUsers.addAll(0, origin);
            }
            this.applyUserList(newUsers);
        }
    }

    UserTypeListViewModel(DialogProvider provider, GroupChannel channel, CustomMemberListQueryHandler<User> customQuery) {
        super(provider);
        this.channel = channel;
        this.queryHandler = customQuery;
    }

    private boolean isCurrentChannel(@NonNull String channelUrl) {
        return channelUrl.equals(this.channel.getUrl());
    }

    private void updateChannel(@NonNull GroupChannel channel) {
        if (this.isCurrentChannel(channel.getUrl())) {
            Logger.i(">> MemberListViewModel::updateChannel()", new Object[0]);
            this.channel = channel;
            this.loadInitial();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_RESUME)
    private void onResume() {
        Logger.i(">> MemberListViewModel::onResume()", new Object[0]);
        SendBird.addChannelHandler((String)this.CHANNEL_HANDLER_MEMBER_LIST, (SendBird.ChannelHandler)new SendBird.ChannelHandler(){

            public void onMessageReceived(BaseChannel channel, BaseMessage message) {
            }

            public void onOperatorUpdated(BaseChannel groupChannel) {
                UserTypeListViewModel.this.updateChannel((GroupChannel)groupChannel);
            }

            public void onUserMuted(BaseChannel channel, User user) {
                UserTypeListViewModel.this.updateChannel((GroupChannel)channel);
            }

            public void onUserUnmuted(BaseChannel channel, User user) {
                UserTypeListViewModel.this.updateChannel((GroupChannel)channel);
            }

            public void onUserBanned(BaseChannel channel, User user) {
                UserTypeListViewModel.this.updateChannel((GroupChannel)channel);
            }

            public void onUserUnbanned(BaseChannel channel, User user) {
                UserTypeListViewModel.this.updateChannel((GroupChannel)channel);
            }

            public void onChannelChanged(BaseChannel channel) {
                UserTypeListViewModel.this.updateChannel((GroupChannel)channel);
            }
        });
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    private void onDestroy() {
        Logger.i(">> MemberListViewModel::onDestroy()", new Object[0]);
        SendBird.removeChannelHandler((String)this.CHANNEL_HANDLER_MEMBER_LIST);
    }

    public MutableLiveData<StatusFrameView.Status> getStatusFrame() {
        return this.statusFrame;
    }

    @Override
    public boolean hasMore() {
        return this.queryHandler.hasMore();
    }

    public void loadInitial() {
        Logger.d(">> MemberListViewModel::loadInitial()");
        List origin = (List)this.memberList.getValue();
        if (origin != null) {
            origin.clear();
        }
        this.queryHandler.loadInitial(this::onResult);
    }

    @Override
    public void loadMore() {
        this.queryHandler.load(this::onResult);
    }

    protected void changeAlertStatus(StatusFrameView.Status status) {
        if (!this.hasData() || status == StatusFrameView.Status.NONE) {
            this.statusFrame.postValue((Object)status);
        }
    }

    protected boolean hasData() {
        List origin = (List)this.memberList.getValue();
        return origin != null && origin.size() > 0;
    }

    public MutableLiveData<? extends Collection<?>> getMemberList() {
        return this.memberList;
    }

    private void applyUserList(List<User> newUserList) {
        this.changeAlertStatus(newUserList.size() == 0 ? StatusFrameView.Status.EMPTY : StatusFrameView.Status.NONE);
        this.notifyDataSetChanged(newUserList);
    }

    protected void notifyDataSetChanged(Collection<User> list) {
        this.memberList.postValue(list == null ? new ArrayList() : (List)list);
    }
}

