/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.utils;

import android.content.Context;
import com.sendbird.uikit.R;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class DateUtils {
    private DateUtils() {
    }

    public static String formatTime(Context context, long timeInMillis) {
        int flags = 1;
        return android.text.format.DateUtils.formatDateTime((Context)context, (long)timeInMillis, (int)flags);
    }

    public static String formatDateTime(Context context, long timeInMillis) {
        if (DateUtils.isToday(timeInMillis)) {
            return DateUtils.formatTime(context, timeInMillis);
        }
        if (DateUtils.isYesterday(timeInMillis)) {
            return context.getString(R.string.sb_text_yesterday);
        }
        return DateUtils.formatDate2(timeInMillis);
    }

    public static String formatDate(long timeInMillis) {
        int flags = 98330;
        return android.text.format.DateUtils.formatDateTime(null, (long)timeInMillis, (int)flags);
    }

    public static String formatDate2(long timeInMillis) {
        int flags = 65560;
        return android.text.format.DateUtils.formatDateTime(null, (long)timeInMillis, (int)flags);
    }

    public static boolean isToday(long timeInMillis) {
        return android.text.format.DateUtils.isToday((long)timeInMillis);
    }

    public static boolean isYesterday(long timeInMillis) {
        Calendar now = Calendar.getInstance();
        Calendar cdate = Calendar.getInstance();
        cdate.setTimeInMillis(timeInMillis);
        now.add(5, -1);
        return now.get(1) == cdate.get(1) && now.get(2) == cdate.get(2) && now.get(5) == cdate.get(5);
    }

    public static boolean hasSameDate(long millisFirst, long millisSecond) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd", Locale.getDefault());
        return dateFormat.format(millisFirst).equals(dateFormat.format(millisSecond));
    }

    public static boolean hasSameTimeInMinute(long millisFirst, long millisSecond) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.getDefault());
        return dateFormat.format(millisFirst).equals(dateFormat.format(millisSecond));
    }

    public static String getTimeDiff(long time) {
        int flags = 65560;
        return (String)android.text.format.DateUtils.getRelativeTimeSpanString((long)time, (long)System.currentTimeMillis(), (long)60000L, (int)flags);
    }
}

