/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit;

import android.content.Context;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.sendbird.android.AppInfo;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.adapter.SendBirdUIKitAdapter;
import com.sendbird.uikit.interfaces.CustomParamsHandler;
import com.sendbird.uikit.interfaces.CustomUserListQueryHandler;
import com.sendbird.uikit.interfaces.UserInfo;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.EmojiManager;
import com.sendbird.uikit.tasks.JobResultTask;
import com.sendbird.uikit.tasks.TaskQueue;
import com.sendbird.uikit.utils.FileUtils;
import com.sendbird.uikit.utils.TextUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class SendBirdUIKit {
    private static volatile SendBirdUIKitAdapter adapter;
    private static volatile ThemeMode defaultThemeMode;
    private static volatile boolean useDefaultUserProfile;
    private static CustomUserListQueryHandler customUserListQueryHandler;
    private static CustomParamsHandler customParamsHandler;

    static void clearAll() {
        customUserListQueryHandler = null;
        defaultThemeMode = ThemeMode.Light;
    }

    public static synchronized void init(@NonNull SendBirdUIKitAdapter adapter, @NonNull Context context) {
        SendBirdUIKit.adapter = adapter;
        SendBird.init((String)adapter.getAppId(), (Context)context);
        FileUtils.removeDeletableDir(context.getApplicationContext());
        try {
            SendBird.addExtension((String)"sb_uikit", (String)"1.2.2");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setLogLevel(@NonNull LogLevel level) {
        Logger.setLogLevel(level.getLevel());
    }

    public static ThemeMode getDefaultThemeMode() {
        return defaultThemeMode;
    }

    public static void setDefaultThemeMode(ThemeMode themeMode) {
        defaultThemeMode = themeMode;
    }

    public static boolean isDarkMode() {
        return defaultThemeMode == ThemeMode.Dark;
    }

    public static SendBirdUIKitAdapter getAdapter() {
        return adapter;
    }

    public static CustomUserListQueryHandler getCustomUserListQueryHandler() {
        return customUserListQueryHandler;
    }

    public static CustomParamsHandler getCustomParamsHandler() {
        return customParamsHandler;
    }

    public static boolean shouldUseDefaultUserProfile() {
        return useDefaultUserProfile;
    }

    public static void setUseDefaultUserProfile(boolean useDefaultUserProfile) {
        SendBirdUIKit.useDefaultUserProfile = useDefaultUserProfile;
    }

    public static void connect(final SendBird.ConnectHandler handler) {
        TaskQueue.addTask(new JobResultTask<User>(){

            @Override
            public User call() throws Exception {
                String profileUrl;
                User user = SendBirdUIKit.connect();
                UserInfo userInfo = adapter.getUserInfo();
                String userId = userInfo.getUserId();
                String nickname = TextUtils.isEmpty(userInfo.getNickname()) ? userId : userInfo.getNickname();
                String string = profileUrl = TextUtils.isEmpty(userInfo.getProfileUrl()) ? user.getProfileUrl() : userInfo.getProfileUrl();
                if (!nickname.equals(user.getNickname()) || !TextUtils.isEmpty(profileUrl) && !profileUrl.equals(user.getProfileUrl())) {
                    SendBirdUIKit.updateUserInfoBlocking(nickname, profileUrl);
                }
                Logger.dev("++ user nickname = %s, profileUrl = %s", user.getNickname(), user.getProfileUrl());
                AppInfo appInfo = SendBird.getAppInfo();
                if (appInfo != null && appInfo.useReaction() && appInfo.needUpdateEmoji(EmojiManager.getInstance().getEmojiHash())) {
                    SendBirdUIKit.updateEmojiList();
                }
                return user;
            }

            @Override
            public void onResultForUiThread(User user, SendBirdException e) {
                if (handler != null) {
                    handler.onConnected((User)(e == null ? user : null), e);
                }
            }
        });
    }

    private static User connect() throws InterruptedException, SendBirdException {
        AtomicReference result = new AtomicReference();
        AtomicReference error = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        UserInfo userInfo = adapter.getUserInfo();
        String userId = userInfo.getUserId();
        String accessToken = adapter.getAccessToken();
        SendBird.connect((String)userId, (String)accessToken, (user, e) -> {
            if (e != null) {
                error.set(e);
                latch.countDown();
                return;
            }
            result.set(user);
            latch.countDown();
        });
        latch.await();
        if (error.get() != null) {
            throw (SendBirdException)error.get();
        }
        return (User)result.get();
    }

    public static void disconnect(SendBird.DisconnectHandler handler) {
        SendBird.disconnect(() -> {
            SendBirdUIKit.clearAll();
            if (handler != null) {
                handler.onDisconnected();
            }
        });
    }

    public static void updateUserInfo(String nickname, String profileUrl, SendBird.UserInfoUpdateHandler handler) {
        SendBird.updateCurrentUserInfo((String)nickname, (String)profileUrl, (SendBird.UserInfoUpdateHandler)handler);
    }

    private static void updateUserInfoBlocking(String nickname, String profileUrl) throws SendBirdException, InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference error = new AtomicReference();
        SendBird.updateCurrentUserInfo((String)nickname, (String)profileUrl, e -> {
            if (e != null) {
                error.set(e);
            }
            latch.countDown();
        });
        latch.await();
        if (error.get() != null) {
            throw (SendBirdException)error.get();
        }
    }

    public static void setCustomUserListQueryHandler(CustomUserListQueryHandler handler) {
        customUserListQueryHandler = handler;
    }

    public static void setCustomParamsHandler(CustomParamsHandler handler) {
        customParamsHandler = handler;
    }

    private static void updateEmojiList() {
        SendBird.getAllEmoji((emojiContainer, e) -> {
            if (e != null) {
                Logger.e((Throwable)e);
            } else {
                EmojiManager.getInstance().upsertEmojiContainer(emojiContainer);
            }
        });
    }

    static {
        defaultThemeMode = ThemeMode.Light;
        useDefaultUserProfile = false;
    }

    public static enum ThemeMode {
        Light(R.style.SendBird, R.color.primary_300),
        Dark(R.style.SendBird_Dark, R.color.primary_200);

        @StyleRes
        int resId;
        @ColorRes
        int tintResId;

        private ThemeMode(int resId, int tintResId) {
            this.resId = resId;
            this.tintResId = tintResId;
        }

        @StyleRes
        public int getResId() {
            return this.resId;
        }

        @ColorRes
        public int getTintResId() {
            return this.tintResId;
        }
    }

    public static enum LogLevel {
        ALL(2),
        INFO(4),
        WARN(5),
        ERROR(6);

        int level;

        private LogLevel(int level) {
            this.level = level;
        }

        int getLevel() {
            return this.level;
        }
    }
}

