/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.User;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.activities.ChannelActivity;
import com.sendbird.uikit.activities.adapter.UserListAdapter;
import com.sendbird.uikit.fragments.SelectUserFragment;
import com.sendbird.uikit.interfaces.CustomUserListQueryHandler;
import com.sendbird.uikit.log.Logger;
import java.util.ArrayList;
import java.util.List;

public class InviteChannelFragment
extends SelectUserFragment {
    @Override
    protected List<String> getDisabledUserIds() {
        Logger.d(">> InviteChannelFragment::getDisabledUserIds()");
        ArrayList<String> invitedUserIds = new ArrayList<String>();
        if (this.channel == null) {
            return invitedUserIds;
        }
        if (!this.channel.isSuper() && !this.channel.isBroadcast()) {
            for (User user : this.channel.getMembers()) {
                invitedUserIds.add(user.getUserId());
            }
        }
        return invitedUserIds;
    }

    @Override
    protected void onUserSelectComplete(List<String> selectedUsers) {
        Logger.d(">> InviteChannelFragment::onUserSelectComplete()");
        this.inviteUser(selectedUsers);
    }

    protected void onBeforeInviteUsers(@NonNull List<String> userIds) {
    }

    protected void inviteUser(@NonNull List<String> userIds) {
        Logger.d(">> InviteChannelFragment::inviteUser()");
        if (this.channel != null) {
            this.onBeforeInviteUsers(userIds);
            this.channel.inviteWithUserIds(userIds, e -> {
                if (e != null) {
                    this.toastError(R.string.sb_text_error_invite_member);
                    Logger.e((Throwable)e);
                    return;
                }
                this.onNewUserInvited(this.channel);
            });
        }
    }

    protected void onNewUserInvited(@NonNull GroupChannel channel) {
        Logger.d(">> InviteChannelFragment::onNewUserInvited()");
        if (this.isActive()) {
            Intent intent = new Intent(this.getContext(), ChannelActivity.class);
            intent.addFlags(0x4000000);
            this.startActivity(intent);
        }
    }

    protected void setInviteButtonText(CharSequence text) {
        this.setRightButtonText(text);
    }

    protected void setInviteButtonEnabled(boolean enabled) {
        this.setRightButtonEnabed(enabled);
    }

    public static class Builder {
        private Bundle bundle = new Bundle();
        private InviteChannelFragment customFragment;
        private CustomUserListQueryHandler customUserListQueryHandler = null;
        private UserListAdapter adapter;
        private View.OnClickListener headerLeftButtonListener;

        public Builder(@NonNull String channelUrl) {
            this(channelUrl, SendBirdUIKit.getDefaultThemeMode());
        }

        public Builder(@NonNull String channelUrl, SendBirdUIKit.ThemeMode themeMode) {
            this.bundle.putInt("KEY_THEME_RES_ID", themeMode.getResId());
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public Builder(@NonNull String channelUrl, @StyleRes int customThemeResId) {
            this.bundle.putInt("KEY_THEME_RES_ID", customThemeResId);
            this.bundle.putString("KEY_CHANNEL_URL", channelUrl);
        }

        public <T extends InviteChannelFragment> Builder setCustomInviteChannelFragment(T fragment) {
            this.customFragment = fragment;
            return this;
        }

        public Builder setInviteButtonText(String inviteButtonText) {
            this.bundle.putString("KEY_HEADER_LEFT_BUTTON_TEXT", inviteButtonText);
            return this;
        }

        public Builder setHeaderTitle(String title) {
            this.bundle.putString("KEY_HEADER_TITLE", title);
            return this;
        }

        public Builder setUseHeader(boolean useHeader) {
            this.bundle.putBoolean("KEY_USE_HEADER", useHeader);
            return this;
        }

        public Builder setUseHeaderLeftButton(boolean useHeaderLeftButton) {
            this.bundle.putBoolean("KEY_USE_HEADER_LEFT_BUTTON", useHeaderLeftButton);
            return this;
        }

        public Builder setHeaderLeftButtonIconResId(@DrawableRes int resId) {
            this.bundle.putInt("KEY_HEADER_LEFT_BUTTON_ICON_RES_ID", resId);
            return this;
        }

        public Builder setCustomUserListQueryHandler(CustomUserListQueryHandler handler) {
            this.customUserListQueryHandler = handler;
            return this;
        }

        public Builder setUserListAdapter(UserListAdapter adapter) {
            this.adapter = adapter;
            return this;
        }

        public Builder setHeaderLeftButtonListener(View.OnClickListener listener) {
            this.headerLeftButtonListener = listener;
            return this;
        }

        public InviteChannelFragment build() {
            InviteChannelFragment fragment = this.customFragment != null ? this.customFragment : new InviteChannelFragment();
            fragment.setArguments(this.bundle);
            fragment.setCustomUserListQueryHandler(this.customUserListQueryHandler);
            fragment.setUserListAdapter(this.adapter);
            fragment.setHeaderLeftButtonListener(this.headerLeftButtonListener);
            return fragment;
        }
    }
}

