/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.fragments;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.dialogs.DialogHelper;
import com.sendbird.uikit.interfaces.DialogProvider;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.model.ReadyStatus;
import com.sendbird.uikit.utils.EventProvider;
import com.sendbird.uikit.widgets.WaitingDialog;

abstract class BaseFragment
extends Fragment
implements DialogProvider {
    private final String CONNECTION_HANDLER_ID = this.getClass().getName() + System.currentTimeMillis();
    protected GroupChannel channel;

    BaseFragment() {
    }

    public abstract void onReady(User var1, ReadyStatus var2);

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.connect();
    }

    protected boolean isActive() {
        boolean isDeactive = this.isRemoving() || this.isDetached() || this.getContext() == null;
        return !isDeactive;
    }

    protected void connect() {
        SendBirdUIKit.connect((user, e) -> {
            ReadyStatus status = ReadyStatus.PENDING;
            if (e != null) {
                if (SendBird.getCurrentUser() == null) {
                    status = ReadyStatus.ERROR;
                } else {
                    SendBird.addConnectionHandler((String)this.CONNECTION_HANDLER_ID, (SendBird.ConnectionHandler)new SendBird.ConnectionHandler(){

                        public void onReconnectStarted() {
                        }

                        public void onReconnectSucceeded() {
                            if (!BaseFragment.this.isActive()) {
                                return;
                            }
                            SendBird.removeConnectionHandler((String)BaseFragment.this.CONNECTION_HANDLER_ID);
                            BaseFragment.this.checkAndNotify(ReadyStatus.READY);
                        }

                        public void onReconnectFailed() {
                            if (!BaseFragment.this.isActive()) {
                                return;
                            }
                            SendBird.removeConnectionHandler((String)BaseFragment.this.CONNECTION_HANDLER_ID);
                            BaseFragment.this.checkAndNotify(ReadyStatus.ERROR);
                        }
                    });
                }
            } else {
                status = ReadyStatus.READY;
            }
            if (!this.isActive()) {
                return;
            }
            this.checkAndNotify(status);
        });
    }

    private void checkAndNotify(ReadyStatus status) {
        if (this.hasChannelUrl() && status == ReadyStatus.READY) {
            String channelUrl = this.getChannelUrl();
            if (channelUrl != null && channelUrl.length() > 0) {
                this.retrieveChannel(channelUrl, (channel, e) -> {
                    if (e != null) {
                        Logger.w((Throwable)e);
                    }
                    if (this.isActive()) {
                        this.channel = channel;
                        this.onReady(SendBird.getCurrentUser(), channel != null ? ReadyStatus.READY : ReadyStatus.ERROR);
                    }
                });
            }
        } else {
            this.onReady(SendBird.getCurrentUser(), status);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        SendBird.removeConnectionHandler((String)this.CONNECTION_HANDLER_ID);
        EventProvider.getInstance().unRegister(this.getClass());
    }

    @Override
    public void showWaitingDialog() {
        WaitingDialog.show(this.getContext());
    }

    @Override
    public void dismissWaitingDialog() {
        WaitingDialog.dismiss();
    }

    @Override
    public void toastError(int messageRes) {
        DialogHelper.toastError(this.getContext(), messageRes);
    }

    @Override
    public void toastError(@NonNull String message) {
        DialogHelper.toastError(this.getContext(), message);
    }

    @Override
    public void toastSuccess(@NonNull int messageRes) {
        DialogHelper.toastSuccess(this.getContext(), messageRes);
    }

    protected void finish() {
        if (this.getActivity() != null) {
            this.getActivity().finish();
        }
    }

    protected boolean hasChannelUrl() {
        Bundle args = this.getArguments();
        return args != null && args.containsKey("KEY_CHANNEL_URL");
    }

    @Nullable
    private String getChannelUrl() {
        Bundle args = this.getArguments();
        if (args != null) {
            return args.getString("KEY_CHANNEL_URL");
        }
        return null;
    }

    public GroupChannel getChannel() {
        return this.channel;
    }

    private void retrieveChannel(@NonNull String channelUrl, @NonNull GroupChannel.GroupChannelGetHandler handler) {
        GroupChannel.getChannel((String)channelUrl, (GroupChannel.GroupChannelGetHandler)handler);
    }
}

