/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.adapter;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DiffUtil;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Reaction;
import java.util.List;

class MessageDiffCallback
extends DiffUtil.Callback {
    private final List<BaseMessage> oldMessageList;
    private final List<BaseMessage> newMessageList;
    private final GroupChannel oldChannel;
    private final GroupChannel newChannel;

    public MessageDiffCallback(@NonNull GroupChannel oldChannel, @NonNull GroupChannel newChannel, @NonNull List<BaseMessage> oldMessageList, @NonNull List<BaseMessage> newMessageList) {
        this.oldChannel = oldChannel;
        this.newChannel = newChannel;
        this.oldMessageList = oldMessageList;
        this.newMessageList = newMessageList;
    }

    public int getOldListSize() {
        return this.oldMessageList.size();
    }

    public int getNewListSize() {
        return this.newMessageList.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        return this.oldMessageList.get(oldItemPosition).equals((Object)this.newMessageList.get(newItemPosition));
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        BaseMessage oldMessage = this.oldMessageList.get(oldItemPosition);
        BaseMessage newMessage = this.newMessageList.get(newItemPosition);
        if (!this.areItemsTheSame(oldItemPosition, newItemPosition)) {
            return false;
        }
        if (oldMessage.getSendingStatus() != newMessage.getSendingStatus()) {
            return false;
        }
        if (oldMessage.getUpdatedAt() != newMessage.getUpdatedAt()) {
            return false;
        }
        if (this.oldChannel.getUnreadMemberCount(newMessage) != this.newChannel.getUnreadMemberCount(newMessage)) {
            return false;
        }
        if (this.oldChannel.getUndeliveredMemberCount(newMessage) != this.newChannel.getUndeliveredMemberCount(newMessage)) {
            return false;
        }
        if (this.oldChannel.isFrozen() != this.newChannel.isFrozen()) {
            return false;
        }
        if (this.oldChannel.getMyRole() != this.newChannel.getMyRole()) {
            return false;
        }
        if (this.oldChannel.isFrozen() != this.newChannel.isFrozen()) {
            return false;
        }
        if (this.oldChannel.getMyRole() != this.newChannel.getMyRole()) {
            return false;
        }
        List oldReactions = oldMessage.getReactions();
        List newReactions = newMessage.getReactions();
        if (oldReactions.size() != newReactions.size()) {
            return false;
        }
        for (int i = 0; i < oldReactions.size(); ++i) {
            Reaction newReaction;
            Reaction oldReaction = (Reaction)oldReactions.get(i);
            if (!oldReaction.equals((Object)(newReaction = (Reaction)newReactions.get(i)))) {
                return false;
            }
            if (oldReaction.getUserIds() == null || oldReaction.getUserIds().equals(newReaction.getUserIds())) continue;
            return false;
        }
        if (oldMessage.getOgMetaData() == null && newMessage.getOgMetaData() != null) {
            return false;
        }
        return oldMessage.getOgMetaData() == null || oldMessage.getOgMetaData().equals((Object)newMessage.getOgMetaData());
    }
}

