/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.activities.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.sendbird.android.Member;
import com.sendbird.uikit.activities.adapter.BaseAdapter;
import com.sendbird.uikit.activities.viewholder.BaseViewHolder;
import com.sendbird.uikit.databinding.SbViewMemberPreviewBinding;
import com.sendbird.uikit.interfaces.OnItemClickListener;
import com.sendbird.uikit.interfaces.OnItemLongClickListener;
import com.sendbird.uikit.widgets.MemberPreview;
import java.util.Collections;
import java.util.List;

public class MemberListAdapter
extends BaseAdapter<Member, BaseViewHolder<Member>> {
    private List<Member> members;
    private OnItemClickListener<Member> listener;
    private OnItemLongClickListener<Member> longClickListener;
    private OnItemClickListener<Member> actionItemClickListener;
    private Member.Role myRole = Member.Role.NONE;

    @NonNull
    public BaseViewHolder<Member> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new MemberPreviewHolder(SbViewMemberPreviewBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false));
    }

    public void onBindViewHolder(@NonNull BaseViewHolder<Member> holder, int position) {
        holder.bind(this.getItem(position));
    }

    public int getItemCount() {
        return this.members == null ? 0 : this.members.size();
    }

    @Override
    public Member getItem(int position) {
        return this.members != null ? this.members.get(position) : null;
    }

    @Override
    public List<Member> getItems() {
        return this.members != null ? Collections.unmodifiableList(this.members) : null;
    }

    public long getItemId(int position) {
        return this.getItem(position).hashCode();
    }

    public void setOnItemClickListener(@Nullable OnItemClickListener<Member> listener) {
        this.listener = listener;
    }

    public void setOnItemLongClickListener(@Nullable OnItemLongClickListener<Member> listener) {
        this.longClickListener = listener;
    }

    public void setOnActionItemClickListener(@Nullable OnItemClickListener<Member> listener) {
        this.actionItemClickListener = listener;
    }

    public void setItems(List<Member> memberList, Member.Role myRole) {
        this.members = memberList;
        this.myRole = myRole;
        this.notifyDataSetChanged();
    }

    private class MemberPreviewHolder
    extends BaseViewHolder<Member> {
        private SbViewMemberPreviewBinding binding;

        MemberPreviewHolder(SbViewMemberPreviewBinding binding) {
            super(binding.getRoot());
            this.binding = binding;
            binding.memberViewHolder.setOnClickListener(v -> {
                int userPosition = this.getAdapterPosition();
                if (userPosition != -1 && MemberListAdapter.this.listener != null) {
                    Member member = MemberListAdapter.this.getItem(userPosition);
                    MemberListAdapter.this.listener.onItemClick(v, userPosition, member);
                }
            });
            binding.memberViewHolder.setOnLongClickListener(v -> {
                int userPosition = this.getAdapterPosition();
                if (userPosition != -1 && MemberListAdapter.this.longClickListener != null) {
                    MemberListAdapter.this.longClickListener.onItemLongClick(v, userPosition, MemberListAdapter.this.getItem(userPosition));
                    return true;
                }
                return false;
            });
            binding.memberViewHolder.setOnActionMenuClickListener(v -> {
                int userPosition = this.getAdapterPosition();
                if (userPosition != -1 && MemberListAdapter.this.actionItemClickListener != null) {
                    Member member = MemberListAdapter.this.getItem(userPosition);
                    MemberListAdapter.this.actionItemClickListener.onItemClick(v, userPosition, member);
                }
            });
        }

        @Override
        public void bind(Member member) {
            this.binding.memberViewHolder.useActionMenu(MemberListAdapter.this.myRole == Member.Role.OPERATOR && MemberListAdapter.this.actionItemClickListener != null);
            MemberPreview.drawMember(this.binding.memberViewHolder, member);
            this.binding.executePendingBindings();
        }
    }
}

