/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.databinding.SbViewUserListItemBinding;
import java.util.List;

public class UserPreview
extends FrameLayout {
    private SbViewUserListItemBinding binding;

    public UserPreview(Context context) {
        this(context, null);
    }

    public UserPreview(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.sb_user_preview_style);
    }

    public UserPreview(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyle) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.UserPreview, defStyle, 0);
        try {
            this.binding = SbViewUserListItemBinding.inflate(LayoutInflater.from((Context)this.getContext()));
            this.addView(this.binding.getRoot(), -1, -2);
            int nicknameAppearance = a.getResourceId(R.styleable.UserPreview_sb_user_preview_nickname_appearance, R.style.SendbirdSubtitle2OnLight01);
            this.binding.tvNickname.setTextAppearance(context, nicknameAppearance);
            this.binding.tvNickname.setEllipsize(TextUtils.TruncateAt.END);
            this.binding.tvNickname.setMaxLines(1);
            if (Build.VERSION.SDK_INT >= 21) {
                int checkBoxTint = SendBirdUIKit.isDarkMode() ? R.color.sb_checkbox_tint_dark : R.color.sb_checkbox_tint_light;
                this.binding.cbUserPreview.setButtonTintList(context.getResources().getColorStateList(checkBoxTint));
            }
        }
        finally {
            a.recycle();
        }
    }

    public View getLayout() {
        return this;
    }

    public SbViewUserListItemBinding getBinding() {
        return this.binding;
    }

    public void setNickname(String text) {
        this.binding.tvNickname.setText((CharSequence)text);
    }

    public void setCoverImages(List<String> urls) {
        this.binding.ivUserCover.loadImages(urls);
    }

    public void setOnCheckedChangeListener(CompoundButton.OnCheckedChangeListener listener) {
        this.binding.cbUserPreview.setOnCheckedChangeListener(listener);
    }

    public void setChecked(boolean checked) {
        this.binding.cbUserPreview.setChecked(checked);
    }

    public boolean isChecked() {
        return this.binding.cbUserPreview.isChecked();
    }

    public void setInvited(boolean invited) {
        this.setEnabled(!invited);
        this.binding.cbUserPreview.setEnabled(!invited);
        this.binding.tvNickname.setEnabled(!invited);
    }
}

