/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.sendbird.uikit.R;
import com.sendbird.uikit.SendBirdUIKit;
import com.sendbird.uikit.utils.TextUtils;
import com.sendbird.uikit.widgets.ImageWaffleView;
import java.util.List;

public class ChannelCoverView
extends ImageWaffleView {
    public ChannelCoverView(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public ChannelCoverView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public ChannelCoverView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyle) {
    }

    public void loadImages(@NonNull List<String> imageUrlList) {
        if (imageUrlList.size() <= 0) {
            this.drawEmptyProfile(this.prepareSingleImageView());
            return;
        }
        List<ImageView> profileIamges = this.prepareImageViews(imageUrlList.size());
        int size = Math.min(4, imageUrlList.size());
        for (int i = 0; i < size; ++i) {
            ImageView imageView = profileIamges.get(i);
            String url = imageUrlList.get(i);
            if (TextUtils.isEmpty(url)) {
                this.drawEmptyProfile(imageView);
                continue;
            }
            int overrideSize = this.getResources().getDimensionPixelSize(R.dimen.sb_size_64);
            ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)imageView.getContext()).load(url).override(overrideSize, overrideSize)).centerCrop()).diskCacheStrategy(DiskCacheStrategy.ALL)).error(this.getEmptyIconResId())).into(imageView);
        }
    }

    private int getEmptyIconResId() {
        return SendBirdUIKit.isDarkMode() ? R.drawable.icon_avatar_dark : R.drawable.icon_avatar_light;
    }

    private void drawEmptyProfile(ImageView imageView) {
        imageView.setImageResource(this.getEmptyIconResId());
    }
}

