/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.method.MovementMethod;
import android.text.util.Linkify;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatTextView;
import com.sendbird.uikit.R;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.widgets.SBLinkMovementMethod;

public class AutoLinkTextView
extends AppCompatTextView {
    private SBLinkMovementMethod.OnLinkClickListener onLinkClickListener;
    private SBLinkMovementMethod.OnLinkLongClickListener onLinkLongClickListener;
    private int clickedLinkBackgroundColor;
    private int clickedLinkTextColor;
    private int linkifyMask = 15;

    public AutoLinkTextView(Context context) {
        this(context, null);
    }

    public AutoLinkTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoLinkTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AutoLinkTextView, defStyleAttr, 0);
        try {
            this.linkifyMask = a.getInt(R.styleable.AutoLinkTextView_sb_auto_link_text_view_linkify_mask, 15);
            this.clickedLinkBackgroundColor = a.getResourceId(R.styleable.AutoLinkTextView_sb_auto_link_text_view_clicked_background_color, 0);
            this.clickedLinkTextColor = a.getResourceId(R.styleable.AutoLinkTextView_sb_auto_link_text_view_clicked_text_color, 0);
        }
        catch (Exception e) {
            Logger.e(e);
        }
        finally {
            a.recycle();
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        Linkify.addLinks((TextView)this, (int)this.linkifyMask);
        this.setMovementMethod((MovementMethod)new SBLinkMovementMethod.Builder().setOnLinkClickListener(this.onLinkClickListener).setOnLinkLongClickListener(this.onLinkLongClickListener).setClickedLinkBackgroundColor(this.clickedLinkBackgroundColor).setClickedLinkTextColor(this.clickedLinkTextColor).create());
    }

    public void setOnLinkClickListener(SBLinkMovementMethod.OnLinkClickListener onLinkClickListener) {
        this.onLinkClickListener = onLinkClickListener;
    }

    public void setOnLinkLongClickListener(SBLinkMovementMethod.OnLinkLongClickListener onLinkLongClickListener) {
        this.onLinkLongClickListener = onLinkLongClickListener;
    }

    void setClickedLinkBackgroundColor(int clickedLinkBackgroundColor) {
        this.clickedLinkBackgroundColor = clickedLinkBackgroundColor;
    }

    void setClickedLinkTextColor(int clickedLinkTextColor) {
        this.clickedLinkTextColor = clickedLinkTextColor;
    }

    public int getLinkifyMask() {
        return this.linkifyMask;
    }
}

