/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.uikit.dialogs;

import android.app.Dialog;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.sendbird.uikit.R;
import com.sendbird.uikit.databinding.SbViewDialogBinding;
import com.sendbird.uikit.log.Logger;
import com.sendbird.uikit.utils.DrawableUtils;
import com.sendbird.uikit.utils.SoftInputUtils;
import com.sendbird.uikit.utils.TextUtils;
import java.lang.reflect.Field;

class DialogView
extends LinearLayout {
    private Dialog dialog;
    private SbViewDialogBinding binding;
    private int backgroundBottomId;
    private int backgroundAnchorId;
    private ColorStateList editTextHintColor;

    DialogView(Context context) {
        this(context, null);
    }

    DialogView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.sb_dialog_view_style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DialogView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DialogView, defStyleAttr, 0);
        try {
            this.binding = (SbViewDialogBinding)DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)context), (int)R.layout.sb_view_dialog, null, (boolean)false);
            this.addView(this.binding.getRoot(), -1, -2);
            int backgroundId = a.getResourceId(R.styleable.DialogView_sb_dialog_view_background, R.drawable.sb_rounded_rectangle_light);
            this.backgroundBottomId = a.getResourceId(R.styleable.DialogView_sb_dialog_view_background_bottom, R.drawable.sb_top_rounded_rectangle_light);
            this.backgroundAnchorId = a.getResourceId(R.styleable.DialogView_sb_dialog_view_background_anchor, R.drawable.layer_dialog_anchor_background_light);
            int titleAppearance = a.getResourceId(R.styleable.DialogView_sb_dialog_view_title_appearance, R.style.SendbirdH1OnLight01);
            int messageAppearance = a.getResourceId(R.styleable.DialogView_sb_dialog_view_message_appearance, R.style.SendbirdSubtitle2OnLight01);
            int editTextAppearance = a.getResourceId(R.styleable.DialogView_sb_dialog_view_edit_text_appearance, R.style.SendbirdSubtitle2OnLight01);
            ColorStateList editTextTint = a.getColorStateList(R.styleable.DialogView_sb_dialog_view_edit_text_tint);
            int editTextCussorDrawable = a.getResourceId(R.styleable.DialogView_sb_dialog_view_edit_text_cursor_drawable, R.drawable.sb_message_input_cursor_light);
            this.editTextHintColor = a.getColorStateList(R.styleable.DialogView_sb_dialog_view_edit_text_hint_color);
            this.binding.sbParentPanel.setBackgroundResource(backgroundId);
            this.binding.tvDialogTitle.setTextAppearance(context, titleAppearance);
            this.binding.tvDialogMessage.setTextAppearance(context, messageAppearance);
            this.binding.etInputText.setTextAppearance(context, editTextAppearance);
            this.binding.etInputText.setBackground(DrawableUtils.setTintList(this.binding.etInputText.getBackground(), editTextTint));
            if (Build.VERSION.SDK_INT >= 29) {
                this.binding.etInputText.setTextCursorDrawable(editTextCussorDrawable);
            } else {
                Field f = TextView.class.getDeclaredField("mCursorDrawableRes");
                f.setAccessible(true);
                f.set(this.binding.etInputText, editTextCussorDrawable);
            }
        }
        catch (Exception e) {
            Logger.e(e);
        }
        finally {
            a.recycle();
        }
    }

    void setTitle(int title) {
        if (title == 0) {
            return;
        }
        this.binding.tvDialogTitle.setText(title);
        this.binding.tvDialogTitle.setVisibility(0);
    }

    void setTitle(CharSequence title) {
        if (TextUtils.isEmpty(title)) {
            return;
        }
        this.binding.tvDialogTitle.setText(title);
        this.binding.tvDialogTitle.setVisibility(0);
    }

    void setMessage(int message) {
        if (message == 0) {
            return;
        }
        this.binding.tvDialogMessage.setText(message);
        this.binding.tvDialogMessage.setVisibility(0);
    }

    void setEditText(int hint) {
        this.binding.etInputText.setHint(hint);
        this.binding.etInputText.setVisibility(0);
        SoftInputUtils.showSoftKeyboard((EditText)this.binding.etInputText);
        if (this.editTextHintColor != null) {
            this.binding.etInputText.setHintTextColor(this.editTextHintColor);
        }
    }

    void setAdapter(RecyclerView.Adapter adapter) {
        this.binding.rvSelectView.setAdapter(adapter);
        this.binding.rvSelectView.setVisibility(0);
    }

    void setLeftButton(int text, View.OnClickListener listener) {
        this.binding.btLeft.setText(text);
        this.binding.btLeft.setOnClickListener(v -> {
            if (listener != null) {
                listener.onClick(v);
            }
            this.dialog.dismiss();
        });
        this.binding.sbButtonPanel.setVisibility(0);
        this.binding.btLeft.setVisibility(0);
    }

    void setRightButton(int text, View.OnClickListener listener) {
        this.binding.btRight.setText(text);
        this.binding.btRight.setOnClickListener(v -> {
            if (listener != null) {
                listener.onClick(v);
            }
            this.dialog.dismiss();
        });
        this.binding.sbButtonPanel.setVisibility(0);
        this.binding.btRight.setVisibility(0);
    }

    void setCancelButton(int text, View.OnClickListener listener) {
        this.binding.btCancel.setText(text);
        this.binding.btCancel.setOnClickListener(v -> {
            if (listener != null) {
                listener.onClick(v);
            }
            this.dialog.dismiss();
        });
        this.binding.sbButtonPanel.setVisibility(0);
        this.binding.btCancel.setVisibility(0);
    }

    void setWarningButton(int text, View.OnClickListener listener) {
        this.binding.btWarning.setText(text);
        this.binding.btWarning.setOnClickListener(v -> {
            if (listener != null) {
                listener.onClick(v);
            }
            this.dialog.dismiss();
        });
        this.binding.sbButtonPanel.setVisibility(0);
        this.binding.btWarning.setVisibility(0);
    }

    void setBackgroundBottom() {
        this.binding.sbParentPanel.setBackgroundResource(this.backgroundBottomId);
    }

    void setBackgroundAnchor() {
        this.binding.sbParentPanel.setBackgroundResource(this.backgroundAnchorId);
    }

    void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    String getEditText() {
        Editable text = this.binding.etInputText.getText();
        return text == null ? "" : text.toString();
    }

    void setTopView(View view) {
        this.binding.sbTopViewPanel.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
    }
}

